
#ifndef __CHANNEL_LIST_H__
#define __CHANNEL_LIST_H__

#include <gnome.h>
#include <glade/glade.h>

class ChannelList
{
public:
    ChannelList (GtkWidget *, GtkWindow *);
    
    void init (GtkWidget *);
    void setInfo (ChanInfo *);
    void deleteInfo (ChanInfo *);

    Channel *selectedChannel (void);
    GtkTreeSelection *getSelection () { return selection ; }

    /* Actions */
    void playSelected (gboolean);
    void infoSelected (void);
    void urlSelected (void);
    void bumpSelected (void);
    void stopSelected (void);
    Channel *getPopupChannel (void);
    GtkWidget *getMenuItem (const gchar *name) {
        return glade_xml_get_widget (popup_xml, name); };
    void popupSignalConnect (const gchar *handler,
                             GCallback callback, gpointer data) {
        glade_xml_signal_connect_data (popup_xml, handler, callback, data);
    };
    
private:
    GtkWindow *parent;
    GladeXML *popup_xml;
    GtkTreeSelection *selection;
    GtkTreeView *treeview;
};

#endif
