/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* utils.cpp
 *
 * Copyright (C) 2005 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "servmgr.h"
#include "channel.h"

#include <gnome.h>
#include <glade/glade.h>

#include "utils.h"


/* make uptime string */
void
make_time_str (gchar *str, size_t len, guint t)
{
	guint sec, min, hour, day;
	sec = t % 60;
	min = (t / 60) % 60;
	hour = (t / 3600) % 24;
	day = (t / 86400);

	if (day)
		g_snprintf (str, len, _("%dd, %02d:%02d:%02d"),
			    day, hour, min, sec);
	else if (hour)
		g_snprintf (str, len, _("%02d:%02d:%02d"),
			    hour, min, sec);
	else if (min)
		g_snprintf (str, len, _("%02d:%02d"),
			    min, sec);
	else if (sec)
		g_snprintf (str, len, _("%02d"), sec);
	else
		g_snprintf (str, len, "-");
}

FW_TYPE
servent_firewall_type (Servent *s)
{
	if (s->type != Servent::T_NONE &&
	    (s->type == Servent::T_RELAY) &&
	    (s->status == Servent::S_CONNECTED)) {
		Host h = s->getHost ();
		gint ip = h.ip;
		gint port = h.port;
		Host h2 (ip, port);
		gint numHits=0;
		gboolean isfw = FALSE;
		gint numRelay = 0;
		ChanHitList *chl = chanMgr->hitlist;
		gboolean br = FALSE;
		
		while (chl) {
			if (chl->isUsed () ){
				chl = chl->next;
				continue;
			}
			ChanHit *hit = chl->hit;
			while (hit) {
				if (hit->host.isValid () &&
				    h2.ip == hit->host.ip && 
				    hit->firewalled) {
					isfw = TRUE;
					numRelay = hit->numRelays;
					br = TRUE;
					break;
				}
				hit = hit->next;
			}
			if (br) break;
			chl = chl->next;
		}
		if (isfw && numRelay == 0)
			return FW_TYPE_ON;
		else if (isfw)
			return FW_TYPE_PUSH;
		else
			return FW_TYPE_OFF;
	} /* CONNECTED && T_NONE */
	return FW_TYPE_UNKNOWN;
}

Servent *
servent_find_by_index (gint index)
{
	Servent *s;

	s = servMgr->servents;
	while (s) {
		if (index == s->serventIndex)
			return s;
		s = s->next;
	}
	return NULL;
}

void
parse_peercast_url (const gchar *url, bool keep)
{
	gchar *chanURL = NULL;
	gchar *tmp;
	ChanInfo info;

	if (! url)
		return;

	LOG_DEBUG ("URL: %s\n", url);

	tmp = g_strdup (url);
	if (strnicmp (tmp, "peercast://", 11) == 0) {
		if (strnicmp (tmp + 11, "pls/", 4) == 0)
			chanURL = tmp + 11 +4;
		else
			chanURL = tmp + 11;
	}
	if (chanURL) {
		LOG_DEBUG ("open channel by arg: %s\n", chanURL);
		servMgr->procConnectArgs (chanURL, info);
		chanMgr->findAndPlayChannel (info, keep);
	}
	g_free (tmp);
}

GladeXML *
load_glade_xml (const gchar *file, const gchar *root)
{
	GladeXML *xml;
	gchar *filename;

	filename = g_build_filename ("./", file, NULL);
	g_assert (filename != NULL);
	if (! g_file_test (filename, G_FILE_TEST_EXISTS)) {
		g_free (filename);
		filename = g_build_filename (GLADE_DIR, "/", file, NULL);
		g_assert (filename != NULL);
		if (! g_file_test (filename, G_FILE_TEST_EXISTS)) {
			g_critical (_("The file %s doesn't exist, "
				      "please check if gnome-peercast is correcly installed"),
				    filename);
			return NULL;
		}
	}
	xml = glade_xml_new (filename, root, NULL);
	g_free (filename);
	return xml;

}

gchar *
get_local_ip (void)
{
	Host lh(ClientSocket::getIP(NULL),0);
	char ipStr[64];
	lh.IPtoStr(ipStr);

	return g_strdup (ipStr);
}

gchar *
get_global_ip (void)
{
	gchar buf[64];

	if (servMgr->serverHost.globalIP ())
		servMgr->serverHost.IPtoStr (buf);
	else
		return NULL;

	return g_strdup (buf);
}

gchar *
gen_local_url (ChanInfo info, gboolean pls)
{
	gchar *ret;
	gchar *ip;
	gchar id[64];

	ip = get_local_ip ();
	if (!ip)
		return NULL;

	info.id.toStr (id);
	ret = g_strdup_printf ("http://%s:%d/%s/%s%s",
			       ip, servMgr->serverHost.port,
			       pls ? "pls" : "stream", id,
			       pls ? ".pls" : ChanInfo::getTypeExt(info.contentType));
	g_free (ip);
	return ret;
}
gchar *
gen_global_url (ChanInfo info, gboolean pls)
{
	gchar *ret;
	gchar *ip;
	gchar id[64];

	ip = get_global_ip ();
	if (!ip)
		return NULL;

	info.id.toStr (id);
	ret = g_strdup_printf ("http://%s:%d/%s/%s%s",
			       ip, servMgr->serverHost.port,
			       pls ? "pls" : "stream", id,
			       pls ? ".pls" : ChanInfo::getTypeExt(info.contentType));
	g_free (ip);
	return ret;
}

gchar *
gen_peercast_url (ChanInfo info)
{
	gchar *ret;
	gchar id[64];

	info.id.toStr (id);
	ret = g_strconcat ("peercast://pls/", id, NULL);

	return ret;
}
