/*
This file is part of Gnome Photo Printer.

    Gnome Photo Printer is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Gnome Photo Printer is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Gnome Photo Printer; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <gnome.h>
#include <libgnome/gnome-i18n.h>
#include <glade/glade.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-print-job.h>
#include <libgnomeprintui/gnome-print-dialog.h>
#include <libgnomeprintui/gnome-print-job-preview.h>
#include <glib/gprintf.h>
#include "gpp_print.h"
#include "gpp_functions.h"
#include "gpp_widget.h"
#include "gpp_callbacks.h"
#include "gpp.h"

/* Callback for the Drag and Drop stuff */
void
drag_received (GtkWidget * widget, GdkDragContext * context, gint x, gint y,
	       GtkSelectionData * data, guint info, guint time,
	       gpointer userdata)
{
	GtkTreeModel *model;
	GtkTreeIter iter;
	GList *file_names, *help;
	GnomeVFSURI *file_names_uri;
	gchar *file_name;
	GError *error = NULL;
	GdkPixbuf *pixbuf;

	model = gtk_tree_view_get_model (userdata);

	file_names = gnome_vfs_uri_list_parse ((gchar *) data->data);
	help = file_names;

	while (help != NULL && help->data != NULL)
	{

		file_names_uri = (GnomeVFSURI *) help->data;

		file_name = gnome_vfs_uri_to_string (file_names_uri,
						     GNOME_VFS_URI_HIDE_TOPLEVEL_METHOD);

		if (gpp_check_for_image (file_name))
		{
			pixbuf = gdk_pixbuf_new_from_file
				(gnome_vfs_unescape_string
				 (file_name, G_DIR_SEPARATOR_S), &error);
			if (!error)
			{
				gtk_list_store_append (GTK_LIST_STORE (model),
						       &iter);
				pixbuf = gdk_pixbuf_scale_simple (pixbuf, 50,
								  50,
								  GDK_INTERP_NEAREST);
				gtk_list_store_set (GTK_LIST_STORE (model),
						    &iter, PIXBUF_COLUMN,
						    pixbuf, FILE_COLUMN,
						    file_name, -1);
				gpp_definition->number_of_files++;
				g_object_unref (pixbuf);
			}
			else
			{
				g_critical (_("Could not load pixbuf: %s\n"),
					    error->message);
				g_error_free (error);
			}
		}

		help = help->next;
	}

	gnome_vfs_uri_list_unref (file_names);
}

/* Exit the Program */
void
func_gpp_quit (GtkWidget * widget, gpointer data)
{
	gtk_main_quit ();
}

/* Removes Files from GTreeStore ( gpp_definition->file_names(_n) )*/
void
func_gpp_remove (GtkWidget * widget, gpointer view)
{
	gchar *file_name;
	GtkTreeIter iter;
	GtkTreeSelection *select;
	GtkTreeModel *model;

	model = gtk_tree_view_get_model (view);

	select = gtk_tree_view_get_selection (view);

	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, FILE_COLUMN, &file_name,
				    -1);

/* Debug information
		g_printf(_("File to remove: ->%s<-\n"),file_name);
*/
		gpp_definition->number_of_files--;

		gtk_list_store_remove (GTK_LIST_STORE (model), &iter);
		g_free (file_name);
	}
}

/* Add Files to the GTreeStore ( gpp_definition->file_names(_n) )*/
void
func_gpp_add (GtkWidget * widget, gpointer data)
{
	gtk_widget_show (data);
}

void
func_gpp_add_ok (GtkWidget * widget, gpointer view)
{
	GtkFileSelection *select;
	GtkTreeIter iter;
	GtkTreeModel *model;
	GdkPixbuf *pixbuf;
	GError *error = NULL;
	gchar **files;
	gchar *file_name;
	gint i = 0;

	GladeXML *xml;
	GtkWidget *file_select;

	xml = glade_get_widget_tree (GTK_WIDGET (widget));
	file_select = glade_xml_get_widget (xml, "fileselection");

	model = gtk_tree_view_get_model (view);

	select = GTK_FILE_SELECTION (file_select);
	files = gtk_file_selection_get_selections (select);


	while (files[i] != NULL)
	{
		file_name =
			g_filename_to_utf8 (files[i], -1, NULL, NULL, &error);

		if (gpp_check_for_image (file_name))
		{
			pixbuf = gdk_pixbuf_new_from_file
				(gnome_vfs_unescape_string
				 (file_name, G_DIR_SEPARATOR_S), &error);
			if (!error)
			{
				gtk_list_store_append (GTK_LIST_STORE (model),
						       &iter);
				pixbuf = gdk_pixbuf_scale_simple (pixbuf, 50,
								  50,
								  GDK_INTERP_NEAREST);
				gtk_list_store_set (GTK_LIST_STORE (model),
						    &iter, PIXBUF_COLUMN,
						    pixbuf, FILE_COLUMN,
						    file_name, -1);
				gpp_definition->number_of_files++;
				g_object_unref (pixbuf);
			}
			else
			{
				g_critical (_("Could not load pixbuf: %s\n"),
					    error->message);
				g_error_free (error);

				// Setting error=NULL for next iteration
				error = NULL;
			}
		}

		i++;
	}
	g_strfreev (files);

	gtk_widget_hide (file_select);
}

void
func_gpp_add_cancel (GtkWidget * widget, gpointer data)
{
	gtk_widget_hide (data);
}

/* Callback for the Preview Button,
   Closes the print job, creates the preview and after all a new print job */
void
func_gpp_preview (GtkWidget * widget, gpointer progress)
{
	GtkWidget *preview;
	GtkWidget *progress_bar;

	progress_bar = gtk_progress_bar_new ();
	gtk_container_add (GTK_CONTAINER (progress),
			   GTK_WIDGET (progress_bar));
	gtk_widget_show_all (progress);
	while (g_main_context_iteration (NULL, FALSE)) ;

	if (gpp_get_settings_from_libgnomeprint () != FALSE)
	{
		gpp_set_layout ();
		if (gpp_check_page_size () )
		{
			gpp_context = gnome_print_job_get_context (gpp_job);
			gpp_arrange_pictures (progress_bar);
			gnome_print_job_close (gpp_job);

			preview =
				GTK_WIDGET (gnome_print_job_preview_new
					    (gpp_job, "Preview!"));
			gtk_window_set_modal (GTK_WINDOW (preview), TRUE);
			gtk_widget_show (preview);
			while (g_main_context_iteration (NULL, FALSE)) ;

			/* Create new Print Job */
			g_object_unref (G_OBJECT (gpp_context));
			g_object_unref (G_OBJECT (gpp_job));
			gpp_job = gnome_print_job_new (gpp_config);
		}
	}

	gtk_widget_destroy (progress_bar);
	gtk_widget_hide (progress);
}

/* Callback for the Print Button */
void
func_gpp_print (GtkWidget * widget, gpointer progress)
{
	GtkWidget *progress_bar;

	/* Create Progressbar */
	progress_bar = gtk_progress_bar_new ();
	gtk_container_add (GTK_CONTAINER (progress),
			   GTK_WIDGET (progress_bar));
	gtk_widget_show_all (progress);
	while (g_main_context_iteration (NULL, FALSE)) ;

	/* Print */
	if (gpp_get_settings_from_libgnomeprint () != FALSE)
	{
		gpp_set_layout ();
		if (gpp_check_page_size ())
		{
			gpp_context = gnome_print_job_get_context (gpp_job);
			gpp_arrange_pictures (progress_bar);
			gpp_start_printing ();

			/* Create new Print Job */
			gpp_job = gnome_print_job_new (gpp_config);
		}
	}

	gtk_widget_destroy (progress_bar);
	gtk_widget_hide (progress);
}

/* Callback for the Layout Button */
void
func_gpp_layout (GtkWidget * widget, gpointer data)
{
	gpp_definition->layout = GPOINTER_TO_INT(data);
}

void
func_gpp_image_1 (GtkWidget * widget, gpointer data)
{
	gpp_definition->image_scale_with_ratio = TRUE;
}

void
func_gpp_image_2 (GtkWidget * widget, gpointer data)
{
	gpp_definition->image_scale_with_ratio = FALSE;
}
