/* Generated by GOB (v2.0.16)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 16

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gnome-pilot-conduit-management.h"

#include "gnome-pilot-conduit-management-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 82 "gnome-pilot-conduit-management.gob"

#include <config.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include <libxml/tree.h>
#include <libxml/parser.h>

/* 
   MT-Level :
   Change these defines to make the lib MT safe. 
   (UN)LOCK_MY_HASHES should mutex the conduitname_to_datastruct hash
   (UN)LOCK_MY_COUNTER should mutex the number_of_instances counter
   (UN)LOCK_INSTANCE should mutex the current Gnome:Pilot:Conduit:Management instance
   uhm, don't think I'll use LOCK_INSTANCE
*/
#define LOCK_MY_COUNTER
#define UNLOCK_MY_COUNTER

#define LOCK_MY_HASHES
#define UNLOCK_MY_HASHES

#define LOCK_INSTANCE
#define UNLOCK_INSTANCE

  /* the version that the conduit xml spec files should have */
#define CONDUIT_XML_VERSION "1.0"

gboolean gpcm_initialized = FALSE;
int number_of_instances  = 0;
GHashTable *conduitname_to_datastruct; 
GHashTable *conduitid_to_datastruct; 

/* these are the list of valid tags in addition to conduit-attribute */
static const gchar *gpcm_valid_tags[] = {"conduit","name",NULL};

#line 64 "gnome-pilot-conduit-management.c"
/* self casting macros */
#define SELF(x) GNOME_PILOT_CONDUIT_MANAGEMENT(x)
#define SELF_CONST(x) GNOME_PILOT_CONDUIT_MANAGEMENT_CONST(x)
#define IS_SELF(x) GNOME_IS_PILOT_CONDUIT_MANAGEMENT(x)
#define TYPE_SELF GNOME_TYPE_PILOT_CONDUIT_MANAGEMENT
#define SELF_CLASS(x) GNOME_PILOT_CONDUIT_MANAGEMENT_CLASS(x)

#define SELF_GET_CLASS(x) GNOME_PILOT_CONDUIT_MANAGEMENT_GET_CLASS(x)

/* self typedefs */
typedef GnomePilotConduitManagement Self;
typedef GnomePilotConduitManagementClass SelfClass;

/* here are local prototypes */
#line 0 "gnome-pilot-conduit-management.gob"
static void gnome_pilot_conduit_management_init (GnomePilotConduitManagement * o) G_GNUC_UNUSED;
#line 81 "gnome-pilot-conduit-management.c"
#line 0 "gnome-pilot-conduit-management.gob"
static void gnome_pilot_conduit_management_class_init (GnomePilotConduitManagementClass * c) G_GNUC_UNUSED;
#line 84 "gnome-pilot-conduit-management.c"
#line 143 "gnome-pilot-conduit-management.gob"
static void gnome_pilot_conduit_management_initializer (void) G_GNUC_UNUSED;
#line 87 "gnome-pilot-conduit-management.c"
#line 235 "gnome-pilot-conduit-management.gob"
static gchar * gnome_pilot_conduit_management_select_dir_entry (gchar * path, gchar * filename, gchar * extension) G_GNUC_UNUSED;
#line 90 "gnome-pilot-conduit-management.c"
#line 271 "gnome-pilot-conduit-management.gob"
static GList * gnome_pilot_conduit_management_get_conduit_file_names (gchar * path, gchar * ext) G_GNUC_UNUSED;
#line 93 "gnome-pilot-conduit-management.c"
#line 324 "gnome-pilot-conduit-management.gob"
static gboolean gnome_pilot_conduit_management_is_other_valid_tag (const gchar * s) G_GNUC_UNUSED;
#line 96 "gnome-pilot-conduit-management.c"
#line 334 "gnome-pilot-conduit-management.gob"
static GnomePilotConduitMgmtData * gnome_pilot_conduit_management_check_xml_version (xmlNodePtr root) G_GNUC_UNUSED;
#line 99 "gnome-pilot-conduit-management.c"
#line 354 "gnome-pilot-conduit-management.gob"
static gboolean gnome_pilot_conduit_management_read_conduit_topdata (GnomePilotConduitMgmtData * obj, xmlNodePtr root) G_GNUC_UNUSED;
#line 102 "gnome-pilot-conduit-management.c"
#line 413 "gnome-pilot-conduit-management.gob"
static const gchar * gnome_pilot_conduit_management_get_lang (void) G_GNUC_UNUSED;
#line 105 "gnome-pilot-conduit-management.c"
#line 423 "gnome-pilot-conduit-management.gob"
static gboolean gnome_pilot_conduit_management_read_conduit_name (GnomePilotConduitMgmtData * obj, xmlNodePtr root) G_GNUC_UNUSED;
#line 108 "gnome-pilot-conduit-management.c"
#line 465 "gnome-pilot-conduit-management.gob"
static void gnome_pilot_conduit_management_read_conduit_attributes (GnomePilotConduitMgmtData * obj, xmlNodePtr root) G_GNUC_UNUSED;
#line 111 "gnome-pilot-conduit-management.c"
#line 527 "gnome-pilot-conduit-management.gob"
static GnomePilotConduitMgmtData * gnome_pilot_conduit_management_read_conduit_xml (gchar * filename) G_GNUC_UNUSED;
#line 114 "gnome-pilot-conduit-management.c"
#line 583 "gnome-pilot-conduit-management.gob"
static void gnome_pilot_conduit_management_hfunc_build_name_list (gchar * name, GnomePilotConduitMgmtData * data, GList ** output) G_GNUC_UNUSED;
#line 117 "gnome-pilot-conduit-management.c"
#line 612 "gnome-pilot-conduit-management.gob"
static void gnome_pilot_conduit_management_attribs_foreach (gchar * key, gpointer unused, GList ** l) G_GNUC_UNUSED;
#line 120 "gnome-pilot-conduit-management.c"
#line 618 "gnome-pilot-conduit-management.gob"
static void gnome_pilot_conduit_management_attribs_filter_lang_foreach (gchar * key, gpointer unused, GList ** l) G_GNUC_UNUSED;
#line 123 "gnome-pilot-conduit-management.c"
#line 679 "gnome-pilot-conduit-management.gob"
static gint gnome_pilot_conduit_management_shlib_loader (GnomePilotConduitManagement * self) G_GNUC_UNUSED;
#line 126 "gnome-pilot-conduit-management.c"

/* pointer to the class of our parent */
static GtkObjectClass *parent_class = NULL;

/* Short form macros */
#define self_initializer gnome_pilot_conduit_management_initializer
#define self_new gnome_pilot_conduit_management_new
#define self_destroy gnome_pilot_conduit_management_destroy
#define self_select_dir_entry gnome_pilot_conduit_management_select_dir_entry
#define self_get_conduit_file_names gnome_pilot_conduit_management_get_conduit_file_names
#define self_is_other_valid_tag gnome_pilot_conduit_management_is_other_valid_tag
#define self_check_xml_version gnome_pilot_conduit_management_check_xml_version
#define self_read_conduit_topdata gnome_pilot_conduit_management_read_conduit_topdata
#define self_get_lang gnome_pilot_conduit_management_get_lang
#define self_read_conduit_name gnome_pilot_conduit_management_read_conduit_name
#define self_read_conduit_attributes gnome_pilot_conduit_management_read_conduit_attributes
#define self_read_conduit_xml gnome_pilot_conduit_management_read_conduit_xml
#define self_get_name gnome_pilot_conduit_management_get_name
#define self_get_id gnome_pilot_conduit_management_get_id
#define self_hfunc_build_name_list gnome_pilot_conduit_management_hfunc_build_name_list
#define self_get_conduits gnome_pilot_conduit_management_get_conduits
#define self_attribs_foreach gnome_pilot_conduit_management_attribs_foreach
#define self_attribs_filter_lang_foreach gnome_pilot_conduit_management_attribs_filter_lang_foreach
#define self_get_attribute_list gnome_pilot_conduit_management_get_attribute_list
#define self_get_attribute gnome_pilot_conduit_management_get_attribute
#define self_shlib_loader gnome_pilot_conduit_management_shlib_loader
#define self_instantiate_conduit gnome_pilot_conduit_management_instantiate_conduit
#define self_destroy_conduit gnome_pilot_conduit_management_destroy_conduit
GType
gnome_pilot_conduit_management_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GnomePilotConduitManagementClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_pilot_conduit_management_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GnomePilotConduitManagement),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gnome_pilot_conduit_management_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_OBJECT, "GnomePilotConduitManagement", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GnomePilotConduitManagement *)g_object_new(gnome_pilot_conduit_management_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GnomePilotConduitManagement * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GnomePilotConduitManagement *
GET_NEW_VARG (const char *first, ...)
{
	GnomePilotConduitManagement *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GnomePilotConduitManagement *)g_object_new_valist (gnome_pilot_conduit_management_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::finalize"
	GnomePilotConduitManagement *self G_GNUC_UNUSED = GNOME_PILOT_CONDUIT_MANAGEMENT (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
gnome_pilot_conduit_management_init (GnomePilotConduitManagement * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,GNOME_TYPE_PILOT_CONDUIT_MANAGEMENT,GnomePilotConduitManagementPrivate);
}
#undef __GOB_FUNCTION__
static void 
gnome_pilot_conduit_management_class_init (GnomePilotConduitManagementClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(GnomePilotConduitManagementPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_OBJECT);

	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 143 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_initializer (void)
{
#line 236 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::initializer"
{
#line 144 "gnome-pilot-conduit-management.gob"
	
		if (!gpcm_initialized) {
			GList *conduit_files;
			GList *iterator;

			/* Do read of all .conduit files here */
			conduit_files = self_get_conduit_file_names ("gnome-pilot/conduits", ".conduit");
 
			LOCK_MY_HASHES;
			conduitname_to_datastruct  = g_hash_table_new (g_str_hash,g_str_equal);
			conduitid_to_datastruct  = g_hash_table_new (g_str_hash,g_str_equal);

			/* g_message ("direntries = %d",dirs); */
			for (iterator = conduit_files; iterator; iterator = g_list_next (iterator)) {
				GnomePilotConduitMgmtData *conduitdata;
				gchar *filename = (char*)iterator->data;

				conduitdata = self_read_conduit_xml (filename);
			}

			UNLOCK_MY_HASHES;
			g_list_foreach (conduit_files, (GFunc)g_free, NULL);
			g_list_free (conduit_files);
		}
		gpcm_initialized = TRUE;
	}}
#line 266 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 174 "gnome-pilot-conduit-management.gob"
GnomePilotConduitManagement * 
gnome_pilot_conduit_management_new (gchar * _name, enum GnomePilotConduitFilter filter)
{
#line 273 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::new"
#line 174 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (_name != NULL, (GnomePilotConduitManagement * )NULL);
#line 277 "gnome-pilot-conduit-management.c"
{
#line 177 "gnome-pilot-conduit-management.gob"
	
		GtkObject *ret = NULL;
		GHashTable *which_to_use = NULL;
		GnomePilotConduitManagement *obj  = NULL;
		GnomePilotConduitMgmtData *_mgmtdata = NULL;

		LOCK_MY_COUNTER;
		if (number_of_instances==0) {
			gnome_pilot_conduit_management_initializer ();
		}
		number_of_instances++;
		UNLOCK_MY_COUNTER;
		
		switch (filter) {
		case GNOME_PILOT_CONDUIT_MGMT_ID:
			which_to_use = conduitid_to_datastruct;
			break;
		case GNOME_PILOT_CONDUIT_MGMT_NAME:
			which_to_use = conduitname_to_datastruct;
			break;
		}

		_mgmtdata = g_hash_table_lookup (which_to_use,_name);
		if (_mgmtdata) {
			ret = GTK_OBJECT (GET_NEW);
			obj = SELF (ret);
			obj->_priv->loaded = FALSE;
			obj->_priv->mgmtdata = _mgmtdata;
		} else {
			g_warning ("Unknown conduit, name=\"%s\"",_name);
		}

		return obj;
	}}
#line 314 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 215 "gnome-pilot-conduit-management.gob"
void 
gnome_pilot_conduit_management_destroy (GnomePilotConduitManagement * self)
{
#line 321 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::destroy"
#line 215 "gnome-pilot-conduit-management.gob"
	g_return_if_fail (self != NULL);
#line 215 "gnome-pilot-conduit-management.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self));
#line 327 "gnome-pilot-conduit-management.c"
{
#line 216 "gnome-pilot-conduit-management.gob"
	
		LOCK_INSTANCE;
		LOCK_MY_COUNTER;
		number_of_instances--;
		if (number_of_instances==0) {
			/* g_message ("No more instances"); */
		}
		gtk_object_destroy (GTK_OBJECT (self));
		UNLOCK_MY_COUNTER;
		UNLOCK_INSTANCE;
	}}
#line 341 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 235 "gnome-pilot-conduit-management.gob"
static gchar * 
gnome_pilot_conduit_management_select_dir_entry (gchar * path, gchar * filename, gchar * extension)
{
#line 348 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::select_dir_entry"
{
#line 236 "gnome-pilot-conduit-management.gob"
	
		gchar *result = NULL;
		gchar *ptr;
		struct stat st;

		if (filename==NULL) {
			return NULL;
		}

		if (strlen (filename) < strlen (extension)) {
			return NULL;
		}

		ptr = filename;
		ptr += (strlen (filename) - strlen (extension));

		if (strcmp (ptr, extension)) {
			return NULL;
		}

		result = g_strdup_printf ("%s/%s", path, filename);

		stat (result, &st);
		if (S_ISDIR (st.st_mode) || 
		    S_ISCHR (st.st_mode) || 
		    S_ISFIFO (st.st_mode) || 
		    S_ISSOCK (st.st_mode)) {
			g_free (result);
			return NULL;
		}

		return result;
	}}
#line 385 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 271 "gnome-pilot-conduit-management.gob"
static GList * 
gnome_pilot_conduit_management_get_conduit_file_names (gchar * path, gchar * ext)
{
#line 392 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_conduit_file_names"
{
#line 272 "gnome-pilot-conduit-management.gob"
	
		gchar *gnome_path = NULL;
		const gchar *gnome2path;
		GList *result = NULL;
		GDir *dir;
		const char *name;
		gchar **paths;
		int idx;
		
		gnome2path = g_getenv ("GNOME2_PATH");
		/* Concat GNOME2_PATH, and CONDUITDIR
		   This is so that we can load all conduits in these paths */
		gnome_path = g_strconcat (CONDUITDIR, ":",
					  gnome2path ? gnome2path : "",
					  gnome2path ? "/share": "",
					  NULL);

		if (gnome_path == NULL) {
			g_warning ("Cannot locate the %s files", ext);
			return NULL;
		}

		paths = g_strsplit (gnome_path, ":", -1);

		for (idx = 0; paths[idx]; idx++) {
			gchar *cur_path;

			/* Ensure we end in / */
			cur_path = g_strdup_printf ("%s/%s/", paths[idx], path);

			/* Go through all the files and select the ones we want */
			dir = g_dir_open (cur_path, 0, NULL);
			if (dir == NULL) {
				g_free (cur_path);
				continue;
			}
			while ((name = g_dir_read_name (dir))) {
				gchar *fullname;
				if ((fullname = self_select_dir_entry (cur_path, (char *)name, ext))!=NULL) {
					result = g_list_prepend (result, fullname);
				}
			}
			g_dir_close (dir);
			g_free (cur_path);
		}
		
		g_strfreev (paths);
		g_free (gnome_path);
		return result;
	}}
#line 446 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 324 "gnome-pilot-conduit-management.gob"
static gboolean 
gnome_pilot_conduit_management_is_other_valid_tag (const gchar * s)
{
#line 453 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::is_other_valid_tag"
{
#line 325 "gnome-pilot-conduit-management.gob"
	
		gint i = 0;
		for (i=0;gpcm_valid_tags[i];i++)
			if (g_ascii_strcasecmp (s,gpcm_valid_tags[i]) == 0) return TRUE;
		return FALSE;
		
	}}
#line 464 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 334 "gnome-pilot-conduit-management.gob"
static GnomePilotConduitMgmtData * 
gnome_pilot_conduit_management_check_xml_version (xmlNodePtr root)
{
#line 471 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::check_xml_version"
{
#line 335 "gnome-pilot-conduit-management.gob"
	
		GnomePilotConduitMgmtData *ret;
		xmlChar *version;
		
		version = xmlGetProp (root,(unsigned char *)"version");
		/* g_message ("version = %s",version); */
		if (version==NULL || g_ascii_strcasecmp ((char *) version, CONDUIT_XML_VERSION) != 0) {
			g_warning ("incompatible version");
			xmlFree (version);
			return NULL;	
		}
		xmlFree (version);
		/* g_message ("XML version is ok, creating entry"); */
		ret = g_new (GnomePilotConduitMgmtData,1);
		ret->string_attributes = g_hash_table_new (g_str_hash,g_str_equal);
		return ret;
	}}
#line 492 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 354 "gnome-pilot-conduit-management.gob"
static gboolean 
gnome_pilot_conduit_management_read_conduit_topdata (GnomePilotConduitMgmtData * obj, xmlNodePtr root)
{
#line 499 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::read_conduit_topdata"
{
#line 355 "gnome-pilot-conduit-management.gob"
	
		xmlNodePtr node;
		xmlChar *type,*location,*id_string;

		node = root->children;
		/* until we find the "conduit" node */
		while (node && g_ascii_strcasecmp ((char *) node->name,"conduit") != 0) {
			node = node->next;
		}
		if (!node) {
			g_warning ("error in XML, missing the \"conduit\" node");
			return FALSE;
		}
		type = xmlGetProp (node,(unsigned char *) "type");
		location = xmlGetProp (node,(unsigned char *) "location");
		id_string = xmlGetProp (node,(unsigned char *) "id");

		if (id_string==NULL) {
			g_warning ("error in XML, missing id_string");
			xmlFree (type);
			xmlFree (location);
			return FALSE;
		} else {
			if (strchr ((char *)id_string,' ')) {
				g_warning ("error in XML, id_string bad");
				xmlFree (id_string);
				xmlFree (type);
				xmlFree (location);
				return FALSE;
			}
		}
		if (location==NULL) {
			g_warning ("error in XML, missing location");
			xmlFree (id_string);
			xmlFree (type);
			return FALSE;
		}

		if (type && g_ascii_strcasecmp ((char *) type,"shlib") == 0) {
			obj->type = GNOME_PILOT_CONDUIT_TYPE_SHLIB;
		} else {
			g_warning ("Unknown conduit type");
			xmlFree (id_string);
			xmlFree (type);
			xmlFree (location);
			return FALSE;	
		}
		obj->location = g_strdup ((char *) location);
		obj->id = g_strdup ((char *) id_string);
		g_hash_table_insert (conduitid_to_datastruct,
				    obj->id,
				    obj);
		xmlFree (id_string);
		xmlFree (type);
		xmlFree (location);
		return TRUE;
	}}
#line 560 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 413 "gnome-pilot-conduit-management.gob"
static const gchar * 
gnome_pilot_conduit_management_get_lang (void)
{
#line 567 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_lang"
{
#line 415 "gnome-pilot-conduit-management.gob"
	
		const gchar * const *ll;
	
		ll = g_get_language_names();
		return ll[0];
	}}
#line 577 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 423 "gnome-pilot-conduit-management.gob"
static gboolean 
gnome_pilot_conduit_management_read_conduit_name (GnomePilotConduitMgmtData * obj, xmlNodePtr root)
{
#line 584 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::read_conduit_name"
{
#line 424 "gnome-pilot-conduit-management.gob"
	
		xmlNodePtr node;
		xmlChar *value,*lang;
		gchar *current_name=NULL;

		node = root->children;
		/* until we find a name node */
		while (node) {
			while (node && g_ascii_strcasecmp ((char *) node->name, "name")) {
				node = node->next;
			}
			if (node) {
				value = xmlGetProp (node, (unsigned char *)"value");
				lang = xmlGetProp (node,(unsigned char *)"lang");
				/* if this is a default name, and there
				   is no current_name, set it. If on the
				   other hand there is a lang, and it's the current, set it*/
				if ((!lang && !current_name) ||
				    (lang && g_ascii_strcasecmp ((char *) lang, self_get_lang ()) == 0)) {
					if (current_name) g_free (current_name);
					current_name = g_strdup ((char *) value);
				}
				node = node->next;
				xmlFree (value);
				xmlFree (lang);
			}
		}
		if (!current_name) {
			g_warning ("could not determine name from XML");
			return FALSE;
		}

		obj->name = g_strdup (current_name);
		g_hash_table_insert (conduitname_to_datastruct,
				    obj->name,
				    obj);
		return TRUE;
	}}
#line 626 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 465 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_read_conduit_attributes (GnomePilotConduitMgmtData * obj, xmlNodePtr root)
{
#line 633 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::read_conduit_attributes"
{
#line 466 "gnome-pilot-conduit-management.gob"
	
		xmlNodePtr node;

		/* loop over the children */
		for (node = root->children; node!=NULL; node=node->next) {
			if (g_ascii_strcasecmp ((char *) node->name, "conduit-attribute") == 0) {
				xmlChar *lang,*name,*type,*value;
				gchar *attr_with_lang;
				
				lang = xmlGetProp (node,(unsigned char *)"lang");
				name = xmlGetProp (node,(unsigned char *)"name");
				type = xmlGetProp (node,(unsigned char *)"type");
				value = xmlGetProp (node,(unsigned char *)"value");

				if (value==NULL) {
					g_warning ("attribute %s for %s(%s) has no value",
						   name, obj->name, obj->id);
					xmlFree (lang);
					xmlFree (name);
					xmlFree (type);
					continue;
				}
				if (name==NULL) {
					g_warning ("attribute has no name");
					xmlFree (lang);
					xmlFree (type);
					xmlFree (value);
					continue;
				}

				/* g_message ("conduit-attribute [%s-%s] is \"%s\"/%s",
				  name,lang,value,type); */
				if (lang) {
					attr_with_lang = g_strdup_printf ("%s-%s",
									 name, lang);
				} else {
					attr_with_lang = g_strdup ((char *) name);
				}
				/* if no type, assume string */
				if (type==NULL || g_ascii_strcasecmp ((char *) type, "string") == 0) {
					g_hash_table_insert (obj->string_attributes,
							     attr_with_lang,
							     g_strdup ((char *) value));
				} else {
					g_warning ("Unknown type %s",type);
				}
				
				xmlFree (lang);
				xmlFree (name);
				xmlFree (type);
				xmlFree (value);
			} else if (g_ascii_strcasecmp ((char *) node->name, "text") == 0) {
				/* ignore text */
			} else if (!self_is_other_valid_tag ((const gchar *)node->name)) { 
				g_warning ("node->name = \"%s\", unhandled ",node->name);
			} 
		} 
	}}
#line 695 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 527 "gnome-pilot-conduit-management.gob"
static GnomePilotConduitMgmtData * 
gnome_pilot_conduit_management_read_conduit_xml (gchar * filename)
{
#line 702 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::read_conduit_xml"
{
#line 528 "gnome-pilot-conduit-management.gob"
	
		xmlDocPtr doc;
		xmlNodePtr root;
		GnomePilotConduitMgmtData *ret;

		/* g_message ("read_conduit_xml: reading from %s",name); */
		
		/* load the thing */
		doc = xmlParseFile (filename);

		/* check validity 1 */
		if (!doc)
			return NULL;

		root = xmlDocGetRootElement (doc);
		if (!root ||
		    !root->name ||
		    g_ascii_strcasecmp ((char *) root->name, "gnome-pilot-conduit") != 0) {
			xmlFreeDoc (doc);
			return NULL;
		}      
		
		ret = self_check_xml_version (root);
		if (!self_read_conduit_topdata (ret,root) ||
		    !self_read_conduit_name (ret,root)) {
			g_hash_table_destroy (ret->string_attributes);
			g_free (ret);
			xmlFreeDoc (doc);
			return NULL;
		}
		;
		self_read_conduit_attributes (ret,root);

		xmlFreeDoc (doc);
		return ret;
	}}
#line 742 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 571 "gnome-pilot-conduit-management.gob"
const gchar * 
gnome_pilot_conduit_management_get_name (GnomePilotConduitManagement * self)
{
#line 749 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_name"
#line 571 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (const gchar * )0);
#line 571 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (const gchar * )0);
#line 755 "gnome-pilot-conduit-management.c"
{
#line 572 "gnome-pilot-conduit-management.gob"
	
		return self->_priv->mgmtdata->name;
	}}
#line 761 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 577 "gnome-pilot-conduit-management.gob"
const gchar * 
gnome_pilot_conduit_management_get_id (GnomePilotConduitManagement * self)
{
#line 768 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_id"
#line 577 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (const gchar * )0);
#line 577 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (const gchar * )0);
#line 774 "gnome-pilot-conduit-management.c"
{
#line 578 "gnome-pilot-conduit-management.gob"
	
		return self->_priv->mgmtdata->id;
	}}
#line 780 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 583 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_hfunc_build_name_list (gchar * name, GnomePilotConduitMgmtData * data, GList ** output)
{
#line 787 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::hfunc_build_name_list"
{
#line 584 "gnome-pilot-conduit-management.gob"
	
		(*output) = g_list_append (*output,name);
	}}
#line 794 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 588 "gnome-pilot-conduit-management.gob"
gint 
gnome_pilot_conduit_management_get_conduits (GList ** output, enum GnomePilotConduitFilter filter)
{
#line 801 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_conduits"
#line 588 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (output != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 805 "gnome-pilot-conduit-management.c"
{
#line 591 "gnome-pilot-conduit-management.gob"
	
		GHashTable *which_to_use = NULL;
		gnome_pilot_conduit_management_initializer ();
		LOCK_MY_HASHES;
		switch (filter) {
		case GNOME_PILOT_CONDUIT_MGMT_ID:
			which_to_use = conduitid_to_datastruct;
			break;
		case GNOME_PILOT_CONDUIT_MGMT_NAME:
			which_to_use = conduitname_to_datastruct;
			break;
		}
		g_hash_table_foreach (which_to_use,
				     (GHFunc)self_hfunc_build_name_list,
				     output);
		UNLOCK_MY_HASHES;		
		return GNOME_PILOT_CONDUIT_MGMT_OK;
	}}
#line 826 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 612 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_attribs_foreach (gchar * key, gpointer unused, GList ** l)
{
#line 833 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::attribs_foreach"
{
#line 613 "gnome-pilot-conduit-management.gob"
	
		(*l) = g_list_append (*l,key);
	}}
#line 840 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 618 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_attribs_filter_lang_foreach (gchar * key, gpointer unused, GList ** l)
{
#line 847 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::attribs_filter_lang_foreach"
{
#line 619 "gnome-pilot-conduit-management.gob"
	
		if (!strstr (key,"##"))
			(*l) = g_list_append (*l,key);
	}}
#line 855 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 628 "gnome-pilot-conduit-management.gob"
GList * 
gnome_pilot_conduit_management_get_attribute_list (GnomePilotConduitManagement * self, gboolean filter_lang)
{
#line 862 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_attribute_list"
#line 628 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (GList * )0);
#line 628 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (GList * )0);
#line 868 "gnome-pilot-conduit-management.c"
{
#line 629 "gnome-pilot-conduit-management.gob"
	
		GList *attribs = NULL;
		LOCK_MY_HASHES;
		
		if (filter_lang) {
			g_hash_table_foreach (self->_priv->mgmtdata->string_attributes,(GHFunc)self_attribs_filter_lang_foreach,&attribs);
		} else {
			g_hash_table_foreach (self->_priv->mgmtdata->string_attributes,(GHFunc)self_attribs_foreach,&attribs);
		}
		UNLOCK_MY_HASHES;
		return attribs;
	}}
#line 883 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 644 "gnome-pilot-conduit-management.gob"
const gpointer * 
gnome_pilot_conduit_management_get_attribute (GnomePilotConduitManagement * self, gchar * attribute_name, gchar * lang)
{
#line 890 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::get_attribute"
#line 644 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (const gpointer * )NULL);
#line 644 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (const gpointer * )NULL);
#line 644 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (attribute_name != NULL, (const gpointer * )NULL);
#line 898 "gnome-pilot-conduit-management.c"
{
#line 649 "gnome-pilot-conduit-management.gob"
			
		gpointer *attr = NULL;		
		gchar *attribute_name_with_lang;
		LOCK_MY_HASHES;
		/* if no such conduit, do nothing and NULL will be returned */
		if (strstr (attribute_name,"##")==NULL) {
			attribute_name_with_lang = g_strdup_printf ("%s##%s",
								   lang?lang:self_get_lang (),
								   attribute_name);
		} else {
			attribute_name_with_lang = g_strdup (attribute_name);
		}
		attr = g_hash_table_lookup (self->_priv->mgmtdata->string_attributes,
					   attribute_name_with_lang);
		g_free (attribute_name_with_lang);
		if (!attr) {
			/* no luck, try without language */
			attr = g_hash_table_lookup (self->_priv->mgmtdata->string_attributes,attribute_name);
		}
		UNLOCK_MY_HASHES;
		return attr;
	}}
#line 923 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 679 "gnome-pilot-conduit-management.gob"
static gint 
gnome_pilot_conduit_management_shlib_loader (GnomePilotConduitManagement * self)
{
#line 930 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::shlib_loader"
#line 679 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 679 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (gint )0);
#line 936 "gnome-pilot-conduit-management.c"
{
#line 680 "gnome-pilot-conduit-management.gob"
	
		gchar *location = self->_priv->mgmtdata->location;
		GModule *dlhandle = self->_priv->dlhandle;
		if (g_module_supported ()!=TRUE) {
			g_warning (_("module loading not supported, fatal!"));
			return GNOME_PILOT_CONDUIT_MGMT_FATAL;
		}
		if ((dlhandle = g_module_open (location,0))==NULL) {
			g_warning ("unable to g_module_open (%s), reason %s", location, g_module_error ());
#ifdef DLOPEN_TEST
			{
				void *handle;
				g_warning ("doing dlopen_test");
				handle = dlopen (location, RTLD_LAZY);
				if (handle == NULL) {
					g_message ("dlopen error is %s",dlerror ());
				}
				dlclose (handle);
			}
#endif
			return GNOME_PILOT_CONDUIT_MGMT_ERROR;
		} 
		if (g_module_symbol (dlhandle,"conduit_load_gpilot_conduit",
				    (gpointer)&(self->_priv->load_func))==FALSE) {
			self->_priv->load_func = NULL;
			/* Try the old loader */
			if (g_module_symbol (dlhandle,"conduit_get_gpilot_conduit",
					     (gpointer)&(self->_priv->old_load_func))==FALSE) {
				g_warning ("malformed conduit, cannot locate symbol"
					   "\"conduit_get_gpilot_conduit\", error %s",
					   g_module_error ());
				return GNOME_PILOT_CONDUIT_MGMT_ERROR;
			}
		}
		if (g_module_symbol (dlhandle,"conduit_destroy_gpilot_conduit",
				    (gpointer)&(self->_priv->destroy_func))==FALSE) {
			g_warning ("malformed conduit, cannot locate symbol"
				  "\"conduit_destroy_gpilot_conduit\", error %s",
				  g_module_error ());
			return GNOME_PILOT_CONDUIT_MGMT_ERROR;
		}
		self->_priv->loaded = TRUE;
		return GNOME_PILOT_CONDUIT_MGMT_OK;
	}}
#line 983 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 729 "gnome-pilot-conduit-management.gob"
gint 
gnome_pilot_conduit_management_instantiate_conduit (GnomePilotConduitManagement * self, GPilotPilot * pilot, GnomePilotConduit ** instance)
{
#line 990 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::instantiate_conduit"
#line 729 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 729 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 729 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (pilot != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 729 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (instance != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 1000 "gnome-pilot-conduit-management.c"
{
#line 734 "gnome-pilot-conduit-management.gob"
	
		gint err = GNOME_PILOT_CONDUIT_MGMT_OK;
		(*instance) = NULL;
		LOCK_INSTANCE;
		if (self->_priv->loaded==FALSE) {
			switch (self->_priv->mgmtdata->type) {
			case GNOME_PILOT_CONDUIT_TYPE_SHLIB: 
				err = self_shlib_loader (self);
				break;
			default:
				g_warning ("unknown conduit type");
				break;
			}
		}
		if (err == GNOME_PILOT_CONDUIT_MGMT_OK) {
			/* Here we check between the old and the new loader */
			if (self->_priv->load_func) {
				(*instance) = self->_priv->load_func (pilot);
			} else {
				(*instance) = self->_priv->old_load_func (pilot->pilot_id);
			}
			/* Set the conduits name field */
			/* Avoid dependency on the gpilotd/ directory */
			/*gnome_pilot_conduit_set_name (*instance, self->_priv->mgmtdata->name);*/
			g_object_set(G_OBJECT(*instance), "name", self->_priv->mgmtdata->name, NULL);
		}
		UNLOCK_INSTANCE;
		return err;
	}}
#line 1032 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 765 "gnome-pilot-conduit-management.gob"
gint 
gnome_pilot_conduit_management_destroy_conduit (GnomePilotConduitManagement * self, GnomePilotConduit ** instance)
{
#line 1039 "gnome-pilot-conduit-management.c"
#define __GOB_FUNCTION__ "Gnome:Pilot:Conduit:Management::destroy_conduit"
#line 765 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 765 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 765 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (instance != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 1047 "gnome-pilot-conduit-management.c"
{
#line 768 "gnome-pilot-conduit-management.gob"
	
		LOCK_INSTANCE;
		if (self->_priv->loaded==TRUE) {
			self->_priv->destroy_func (*instance);
		}
		UNLOCK_INSTANCE;
		return GNOME_PILOT_CONDUIT_MGMT_OK;
	}}
#line 1058 "gnome-pilot-conduit-management.c"
#undef __GOB_FUNCTION__

#line 778 "gnome-pilot-conduit-management.gob"



#line 1065 "gnome-pilot-conduit-management.c"
