/***************************************************************************
 *            wvdial.c
 *
 *  Mon May 10 20:28:59 2004
 *  Copyright  2004  Vladimir Đokić
 *  vladeck@gnome-ppp.org
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "gnome-ppp.h"


gboolean on_wvdial_out (GIOChannel *source, GIOCondition condition, gpointer data)
{
	gchar *line;
	GIOStatus status;
	
	status = g_io_channel_read_line (source, &line, NULL, NULL, NULL);
	
	if (status != G_IO_STATUS_NORMAL)
		return FALSE;
	
	g_print ("GNOME PPP: STDOUT: %s", line);
	g_free (line);
	
	return TRUE;
}

gboolean on_wvdial_err (GIOChannel *source, GIOCondition condition, gpointer data)
{
	gchar *line;
	GIOStatus status;
	GIOChannel *in; /* stdin */
	GtkTextBuffer *txt;
	GtkTextIter end_iter;
		
	status = g_io_channel_read_line (source, &line, NULL, NULL, NULL);
	
	if (status != G_IO_STATUS_NORMAL)
		return FALSE;
	
	g_print ("GNOME PPP: STDERR: %s", line);
	
	if (g_strrstr (line, "--> Cannot open") != NULL)
		gtk_label_set_text (GTK_LABEL (gnome_ppp.connecting.msgs), _("Can not open modem."));
	
	if (g_strrstr (line, "--> Modem not responding") != NULL)
		gtk_label_set_text (GTK_LABEL (gnome_ppp.connecting.msgs), _("Modem not responding."));
	
	if (g_strrstr (line, "--> Please enter password") != NULL) {
		const gchar *password;
		
		gtk_label_set_text (GTK_LABEL (gnome_ppp.connecting.msgs), _("Sending password..."));
		
		password = gtk_entry_get_text (GTK_ENTRY (gnome_ppp.gnome_ppp.password));
				
		in = g_io_channel_unix_new ((guint)data);
		g_io_channel_set_encoding (in, NULL, NULL);
		g_io_channel_write_chars (in, password, -1, NULL, NULL);
		g_io_channel_shutdown (in, TRUE, NULL);
	}
	
	if (g_strrstr (line, "--> Configuration does not specify a valid password.") != NULL)
		gtk_label_set_text (GTK_LABEL (gnome_ppp.connecting.msgs), _("No valid password."));
	
	if (g_strrstr (line, "ATM") != NULL) {
		const gchar *phone;
		gchar *message;
		
		phone = gtk_entry_get_text (GTK_ENTRY (GTK_BIN (gnome_ppp.gnome_ppp.phone)->child));
		message = g_strdup_printf (_("Dialing %s..."), phone);
		
		gtk_label_set_text (GTK_LABEL (gnome_ppp.connecting.msgs), message);
		
		g_free (message);
	}
	
	if (g_strrstr (line, "--> Carrier detected.  Waiting for prompt.") != NULL)
		gtk_label_set_text (GTK_LABEL (gnome_ppp.connecting.msgs), _("Waiting for prompt..."));
	
	if (g_strrstr (line, "Username:") != NULL)
		gtk_label_set_text (GTK_LABEL (gnome_ppp.connecting.msgs), _("Authenticating..."));
	
	if (g_strrstr (line, "--> Using interface") != NULL) {
		gchar iface[255];
		gchar tmp[255];
		
		sscanf (line, "%s %s %s %s", tmp, tmp, tmp, iface);
		gtk_label_set_text (GTK_LABEL (gnome_ppp.details.interface), &iface[0]);
	}
	/* in case we are using auto reconnect */
	if (g_strrstr (line, "--> Auto Reconnect") != NULL) {
		gtk_label_set_text (GTK_LABEL (gnome_ppp.connecting.msgs), _("Reconnecting..."));
		gtk_widget_hide (gnome_ppp.gnome_ppp.window);
		gtk_widget_hide (gnome_ppp.details.window);
		gtk_widget_show (gnome_ppp.connecting.window);		
	}
	/* we're about to connect (pppd) */
	if (g_strrstr (line, "--> Starting pppd") != NULL) {
		gboolean minimize;
				
		minimize = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.minimize));
				
		gtk_label_set_text (GTK_LABEL (gnome_ppp.connecting.msgs), _("Starting pppd..."));
		/* show connected window */
		gtk_widget_hide (gnome_ppp.connecting.window);
		gtk_widget_hide (gnome_ppp.log.window);
		gtk_widget_show (gnome_ppp.connected.window);
		
		if (minimize)
			gtk_window_iconify (GTK_WINDOW (gnome_ppp.connected.window));
		
		if (gnome_ppp.dock == TRUE) {
			init_notification ();
			update_notification (3);
			show_notification (TRUE);
			gtk_widget_hide (gnome_ppp.connected.window);
		}
		/* start timer */
		gnome_ppp.connected.update = g_timeout_add (1000, (GSourceFunc)timer, NULL);
	}
	
	if (g_strrstr (line, "--> The PPP daemon has died") != NULL
		|| g_strrstr (line, "--> Disconnecting") != NULL) {
	
		if (gnome_ppp.connected.update) {
			g_source_remove (gnome_ppp.connected.update);
			gnome_ppp.connected.update = FALSE;
			gnome_ppp.connected.seconds = 0;
			gnome_ppp.connected.old_bytes_in = 0;
			gnome_ppp.connected.old_bytes_out = 0;
			gtk_label_set_markup (GTK_LABEL (gnome_ppp.connected.time),
						_("<big>Connected: 00:00:00</big>"));
			
			gtk_window_set_title (GTK_WINDOW(gnome_ppp.connected.window), "00:00:00");
		}
		
		if (gnome_ppp.notification.tray != NULL) {
			show_notification (FALSE);
			/* destroy notification */
			destroy_notification ();
		}
		gtk_widget_hide (gnome_ppp.connected.window);
		gtk_widget_hide (gnome_ppp.details.window);
		/* if there was an auto reconnect */
		gtk_widget_hide (gnome_ppp.connecting.window);
		gtk_widget_show (gnome_ppp.gnome_ppp.window);
	}
	/* write wvdial output */
	txt = gtk_text_view_get_buffer (GTK_TEXT_VIEW (gnome_ppp.log.text_log));
	gtk_text_buffer_get_end_iter (txt, &end_iter);
	gtk_text_buffer_insert (txt, &end_iter, line, -1);
	/* scroll text to end */
	gtk_text_buffer_get_end_iter (txt, &end_iter);
	gtk_text_buffer_move_mark_by_name (txt, "insert", &end_iter);
	gtk_text_view_scroll_to_mark (GTK_TEXT_VIEW (gnome_ppp.log.text_log),
	                        gtk_text_buffer_get_mark (txt, "insert"),
	                        0.0, FALSE, 0.0, 0.0);
	
	g_free (line);
	
	return TRUE;
}
