/***************************************************************************
 *            gnome-ppp.c
 *
 *  Mon May 10 20:23:19 2004
 *  Copyright  2004  Vladimir Đokić
 *  vladeck@gnome-ppp.org
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "gnome-ppp.h"


void read_conf (void)
{
	const gchar *home;
	gchar *wvconf;
	gchar line[100];
	FILE *file;

	gchar username[100];
	gchar password[100];
	gchar ask_pwd[100];
	gchar phone[100];
	
	gchar device[100];
	gchar type[100];
	gchar speed[100];
	gchar dial_cmd[100];
	gchar phone1[100];
	gchar phone2[100];
	gchar phone3[100];
	gchar phone4[100];
	gchar init[100];
	gchar init2[100];
	gchar init3[100];
	gchar init4[100];
	gchar init5[100];
	gchar init6[100];
	gchar init7[100];
	gchar init8[100];
	gchar init9[100];
	gchar prefix[100];
	gchar attempts[100];
	
	gchar ip[100];
	gchar auto_dns[100];
	gchar domain[100];
	gchar dns1[100];
	gchar dns2[100];
	
	gchar minimize[100];
	gchar dock[100];
	gchar auto_reconnect[100];
	gchar abort_on_busy[100];
	gchar abort_on_no_dialtone[100];
	gchar check_carrier[100];
	gchar check_def_route[100];
	gchar stupid_mode[100];
	gchar custom_reply[100];
	gchar idle[100];
	
	GtkListStore *store;
	GtkTreeIter iter;
	
	username[0] = '\0';
	password[0] = '\0';
	ask_pwd[0] = '\0';
	phone[0] = '\0';
	
	device[0] = '\0';
	type[0] = '\0';
	speed[0] = '\0';
	dial_cmd[0] = '\0';
	phone1[0] = '\0';
	phone2[0] = '\0';
	phone3[0] = '\0';
	phone4[0] = '\0';
	init[0] = '\0';
	init2[0] = '\0';
	init3[0] = '\0';
	init4[0] = '\0';
	init5[0] = '\0';
	init6[0] = '\0';
	init7[0] = '\0';
	init8[0] = '\0';
	init9[0] = '\0';
	prefix[0] = '\0';
	attempts[0] = '\0';
	
	ip[0] = '\0';
	auto_dns[0] = '\0';
	domain[0] = '\0';
	dns1[0] = '\0';
	dns2[0] = '\0';
	
	minimize[0] = '\0';
	dock[0] = '\0';
	auto_reconnect[0] = '\0';
	abort_on_busy[0] = '\0';
	abort_on_no_dialtone[0] = '\0';
	check_carrier[0] = '\0';
	check_def_route[0] = '\0';
	stupid_mode[0] = '\0';
	custom_reply[0] = '\0';
	idle[0] = '\0';
	
	home = g_get_home_dir ();
	wvconf = g_build_filename (home, ".wvdial.conf", NULL);
	
	file = fopen (wvconf, "r");
	
	if (file == NULL) {
		creat (wvconf, S_IRUSR|S_IWUSR);
		file = fopen (wvconf, "w");
		g_fprintf (file, "Init2 = ATQ0 V1 E1 S0=0 &C1 &D2 +FCLASS=0\n");
		fclose (file);
		g_stpcpy (init2, "ATQ0 V1 E1 S0=0 &C1 &D2 +FCLASS=0");
		gtk_widget_set_sensitive (gnome_ppp.setup.list_dns, FALSE);
		/* /dev/modem as default */
		gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.device), 0);
		/* analog modem as default */
		gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.type), 0);
		/* 115200 as default */
		gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.speed), 2);
		/* high volume as default */
		gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.volume), 2);
		
		populate_phone_list ("", "", "", "");
		populate_init_strs_list ("ATQ0 V1 E1 S0=0 &C1 &D2 +FCLASS=0", "", "", "", "", "", "", "");
		populate_dns_list ("", "");
	} else {
		while (feof (file) == 0) {
			fgets (line, 100, file);
			
			if (g_strrstr (line, "Username = ") != NULL)
				parse_conf_line (line, username);
			
			if (g_strrstr (line, "Password = ") != NULL)
				parse_conf_line (line, password);
			
			if (g_strrstr (line, "Ask Password = ") != NULL)
				parse_conf_line (line, ask_pwd);
			
			if (g_strrstr (line, "Phone = ") != NULL)
				parse_conf_line (line, phone);
			
			if (g_strrstr (line, "Modem = ") != NULL)
				parse_conf_line (line, device);
			
			if (g_strrstr (line, "Modem Type = ") != NULL)
				parse_conf_line (line, type);
			
			if (g_strrstr (line, "Baud = ") != NULL)
				parse_conf_line (line, speed);
			
			if (g_strrstr (line, "Dial Command = ") != NULL)
				parse_conf_line (line, dial_cmd);
			
			if (g_strrstr (line, "Phone1 = ") != NULL)
				parse_conf_line (line, phone1);
			
			if (g_strrstr (line, "Phone2 = ") != NULL)
				parse_conf_line (line, phone2);
			
			if (g_strrstr (line, "Phone3 = ") != NULL)
				parse_conf_line (line, phone3);
			
			if (g_strrstr (line, "Phone4 = ") != NULL)
				parse_conf_line (line, phone4);
			
			if (g_strrstr (line, "Init = ") != NULL)
				parse_conf_line (line, init);
			
			if (g_strrstr (line, "Init2 = ") != NULL)
				parse_conf_line (line, init2);
			
			if (g_strrstr (line, "Init3 = ") != NULL)
				parse_conf_line (line, init3);
			
			if (g_strrstr (line, "Init4 = ") != NULL)
				parse_conf_line (line, init4);
			
			if (g_strrstr (line, "Init5 = ") != NULL)
				parse_conf_line (line, init5);
			
			if (g_strrstr (line, "Init6 = ") != NULL)
				parse_conf_line (line, init6);
			
			if (g_strrstr (line, "Init7 = ") != NULL)				
				parse_conf_line (line, init7);
			
			if (g_strrstr (line, "Init8 = ") != NULL)				
				parse_conf_line (line, init8);
			
			if (g_strrstr (line, "Init9 = ") != NULL)				
				parse_conf_line (line, init9);			
			
			if (g_strrstr (line, "Dial Prefix = ") != NULL)				
				parse_conf_line (line, prefix);
			
			if (g_strrstr (line, "Dial Attempts = ") != NULL)				
				parse_conf_line (line, attempts);
			
			if (g_strrstr (line, "Force Address = ") != NULL)				
				parse_conf_line (line, ip);
			
			if (g_strrstr (line, "Auto DNS = ") != NULL)				
				parse_conf_line (line, auto_dns);
			
			if (g_strrstr (line, ";Domain = ") != NULL)				
				parse_conf_line (line, domain);
			
			if (g_strrstr (line, ";Nameserver = ") != NULL)				
				parse_conf_line (line, dns1);
			
			if (g_strrstr (line, ";Nameserver2 = ") != NULL)				
				parse_conf_line (line, dns2);
			
			if (g_strrstr (line, ";Minimize = ") != NULL)				
				parse_conf_line (line, minimize);
			
			if (g_strrstr (line, ";Dock = ") != NULL)				
				parse_conf_line (line, dock);
			
			if (g_strrstr (line, "Auto Reconnect = ") != NULL)				
				parse_conf_line (line, auto_reconnect);
			
			if (g_strrstr (line, "Abort on Busy = ") != NULL)				
				parse_conf_line (line, abort_on_busy);
			
			if (g_strrstr (line, "Abort on No Dialtone = ") != NULL)				
				parse_conf_line (line, abort_on_no_dialtone);
			
			if (g_strrstr (line, "Carrier Check = ") != NULL)				
				parse_conf_line (line, check_carrier);
			
			if (g_strrstr (line, "Check Def Route = ") != NULL)				
				parse_conf_line (line, check_def_route);
			
			if (g_strrstr (line, "Stupid Mode = ") != NULL)				
				parse_conf_line (line, stupid_mode);
			
			if (g_strrstr (line, "Default Reply = ") != NULL)				
				parse_conf_line (line, custom_reply);
			
			if (g_strrstr (line, "Idle Seconds = ") != NULL)				
				parse_conf_line (line, idle);
		}
		fclose (file);
		g_free (wvconf);
		
		if (username[0] != '\0')
			gtk_entry_set_text (GTK_ENTRY(gnome_ppp.gnome_ppp.username), username);
		
		if (g_strrstr (ask_pwd, "on") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.gnome_ppp.store_pwd), FALSE);
		else if ( g_strrstr( ask_pwd, "off" ) != NULL ) {
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.gnome_ppp.store_pwd), TRUE);
			
			if (password[0] != '\0')
				gtk_entry_set_text (GTK_ENTRY (gnome_ppp.gnome_ppp.password), password);
		}
		
		if (phone[0] != '\0')
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN (gnome_ppp.gnome_ppp.phone)->child), phone);
		
		if (device[0] != '\0')
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN (gnome_ppp.setup.device)->child), device);
		else
			gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.device), 0);
		
		if (g_strrstr (type, "Analog Modem") != NULL)
			gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.type), 0);
		else if (g_strrstr (type, "USB Modem") != NULL)
			gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.type), 1);
		else if (g_strrstr (type, "ISDN Terminal Adapter") != NULL)
			gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.type), 2);
		else
			gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.type), 0);
		
		if (speed[0] != '\0')
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN (gnome_ppp.setup.speed)->child), speed);
		else
			gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.speed), 2);
		
		if (g_strrstr (dial_cmd, "DT") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.tone), TRUE );
		else if ( g_strrstr( dial_cmd, "DP" ) != NULL )
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.pulse), TRUE );
		
		/* phones */
		store = gtk_list_store_new (1, G_TYPE_STRING);
		
		if (phone1[0] != '\0') {
			gtk_list_store_append (store, &iter);
			gtk_list_store_set (store, &iter, 0, phone1, -1);
		}
		
		if (phone2[0] != '\0') {
			gtk_list_store_append (store, &iter);
			gtk_list_store_set (store, &iter, 0, phone2, -1);
		}
		
		if (phone3[0] != '\0') {
			gtk_list_store_append (store, &iter);
			gtk_list_store_set (store, &iter, 0, phone3, -1);
		}
		
		if (phone4[0] != '\0') {
			gtk_list_store_append (store, &iter);
			gtk_list_store_set (store, &iter, 0, phone4, -1);
		}
		
		gtk_combo_box_set_model (GTK_COMBO_BOX (gnome_ppp.gnome_ppp.phone), GTK_TREE_MODEL (store));
		gtk_combo_box_entry_set_text_column (GTK_COMBO_BOX_ENTRY (gnome_ppp.gnome_ppp.phone), 0);
		/* phone numbers list */
		populate_phone_list (phone1, phone2, phone3, phone4);
		
		if (g_strrstr (init, "ATZ") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.dial_tone), TRUE);
		else if (g_strrstr (init, "ATX3") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.dial_tone), FALSE);
		
		if (g_strrstr (dial_cmd, "M0L0") != NULL)
			gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.volume), 0);
		else if (g_strrstr (dial_cmd, "M1L1") != NULL)
			gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.volume), 1);
		else if (g_strrstr (dial_cmd, "M1L3") != NULL)
			gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.volume), 2);
		else
			gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.volume), 2);
		/* init strings list */
		populate_init_strs_list (init2, init3, init4, init5, init6, init7, init8, init9);
		
		if (prefix[0] != '\0')
			gtk_entry_set_text (GTK_ENTRY (gnome_ppp.setup.dial_prefix), prefix);
		
		if (attempts[0] != '\0')
			gtk_spin_button_set_value (GTK_SPIN_BUTTON(gnome_ppp.setup.spin_dial_attempts), (gdouble)atoi (attempts));
		
		if (ip[0] != '\0') {
			gtk_entry_set_text (GTK_ENTRY (gnome_ppp.setup.entry_ip), ip);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.static_ip), TRUE);
		}
		
		if (g_strrstr (auto_dns, "on") != NULL) {		
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.auto_dns), TRUE);
			gtk_widget_set_sensitive (gnome_ppp.setup.list_dns, FALSE);
		} else if (g_strrstr (auto_dns, "off") != NULL) {
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.manual_dns), TRUE);
			gtk_widget_set_sensitive (gnome_ppp.setup.list_dns, TRUE);
		}
		else {
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.auto_dns), TRUE);
			gtk_widget_set_sensitive (gnome_ppp.setup.list_dns, FALSE);
		}
		/* dns list */
		populate_dns_list (dns1, dns2);
		
		if (domain[0] != '\0')
			gtk_entry_set_text (GTK_ENTRY (gnome_ppp.setup.domain), domain);
		
		if (g_strrstr (minimize, "on") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.minimize), TRUE);
		else if (g_strrstr (minimize, "off") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.minimize), FALSE);
		
		if (g_strrstr(dock, "on") != NULL) {
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.dock), TRUE);
			gnome_ppp.connected.show = FALSE;
			gnome_ppp.dock = TRUE;
		} else if (g_strrstr (dock, "off") != NULL) {
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.dock), FALSE);
			gnome_ppp.connected.show = TRUE;
			gnome_ppp.dock = FALSE;
		}
		
		if (g_strrstr (auto_reconnect, "on") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.auto_reconnect), TRUE);
		else if (g_strrstr (auto_reconnect, "off") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.auto_reconnect), FALSE);
		
		if (g_strrstr (abort_on_busy, "on") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.abort_on_busy), TRUE);
		else if (g_strrstr (abort_on_busy, "off") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.abort_on_busy), FALSE);
		
		if (g_strrstr (abort_on_no_dialtone, "on") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.abort_on_no_dialtone), TRUE);
		else if (g_strrstr (abort_on_no_dialtone, "off") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.abort_on_no_dialtone), FALSE);
		
		if (g_strrstr (check_carrier, "on") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.check_carrier), TRUE);
		else if (g_strrstr (check_carrier, "off") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.check_carrier), FALSE);
		
		if (g_strrstr (check_def_route, "on") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.check_def_route), TRUE);
		else if (g_strrstr (check_def_route, "off") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.check_def_route), FALSE);
		
		if (g_strrstr (stupid_mode, "on") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.stupid_mode), TRUE);
		else if (g_strrstr (stupid_mode, "off") != NULL)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.stupid_mode), FALSE);
		
		if (custom_reply[0] != '\0') {
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.custom_reply), TRUE);
			gtk_widget_set_sensitive (gnome_ppp.setup.entry_reply, TRUE);
			gtk_entry_set_text (GTK_ENTRY ( gnome_ppp.setup.entry_reply ), custom_reply);
		}
		
		if (idle[0] != '\0') {
			gdouble time;
			
			time = (gdouble)atoi (idle);
			gtk_spin_button_set_value (GTK_SPIN_BUTTON (gnome_ppp.setup.spin_idle), time);
			
			if ( time != 0.0 ) {
				gtk_widget_set_sensitive (gnome_ppp.setup.auto_reconnect, FALSE);
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.auto_reconnect), FALSE);
				
				if (time == 1.0 || time == 21.0 || time == 31.0 || time == 41.0
					|| time == 51.0 || time == 61.0 || time == 71.0 || time == 81.0
					|| time == 91.0 || time == 101.0 || time == 121.0 || time == 131.0
					|| time == 141.0 || time == 151.0 || time == 161.0 || time == 171.0
					|| time == 181.0 || time == 191.0 || time == 201.0 || time == 221.0
					|| time == 231.0)
					gtk_label_set_text (GTK_LABEL (gnome_ppp.setup.label_idle), _("second"));
				else
					gtk_label_set_text (GTK_LABEL (gnome_ppp.setup.label_idle), _("seconds"));
			} else {
				gtk_widget_set_sensitive (gnome_ppp.setup.auto_reconnect, TRUE);				
				gtk_label_set_text (GTK_LABEL (gnome_ppp.setup.label_idle), _("disabled"));
			}
		}
	}
}

void populate_phone_list (const gchar *phone1, const gchar *phone2, const gchar *phone3, const gchar *phone4)
{
	GtkListStore *store;
	GtkTreeViewColumn *column;
	GtkCellRenderer *renderer;
	GtkTreeIter iter;
	
	store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "1", 1, phone1, -1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "2", 1, phone2, -1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "3", 1, phone3, -1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "4", 1, phone4, -1);
	
	gtk_tree_view_set_model (GTK_TREE_VIEW (gnome_ppp.phone.phone_nums), GTK_TREE_MODEL (store));
	g_object_unref (G_OBJECT (store));

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Num", renderer, "text", 0, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (gnome_ppp.phone.phone_nums), column );
	
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Value", renderer, "text", 1, NULL);
	g_signal_connect (renderer, "edited", G_CALLBACK (on_phone_num_edited), store);
	g_object_set (G_OBJECT (renderer), "editable", TRUE, NULL);
	g_object_set_data (G_OBJECT (renderer), "column", (gpointer)1);
	gtk_tree_view_append_column (GTK_TREE_VIEW (gnome_ppp.phone.phone_nums), column);
	
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (gnome_ppp.phone.phone_nums), TRUE);
}

void populate_init_strs_list (const gchar *init2, const gchar *init3, const gchar *init4, const gchar *init5,
				const gchar *init6, const gchar *init7, const gchar *init8, const gchar *init9)
{
	GtkListStore *store;
	GtkTreeViewColumn *column;
	GtkCellRenderer *renderer;
	GtkTreeIter iter;
	
	store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "Init 2", 1, init2, -1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "Init 3", 1, init3, -1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "Init 4", 1, init4, -1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "Init 5", 1, init5, -1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "Init 6", 1, init6, -1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "Init 7", 1, init7, -1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "Init 8", 1, init8, -1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "Init 9", 1, init9, -1);
	
	gtk_tree_view_set_model (GTK_TREE_VIEW (gnome_ppp.init_strs.init_strs), GTK_TREE_MODEL (store));
	g_object_unref (G_OBJECT (store));

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Name", renderer, "text", 0, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (gnome_ppp.init_strs.init_strs), column);
	
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Value", renderer, "text", 1, NULL);	
	g_signal_connect (renderer, "edited", G_CALLBACK (on_init_str_edited), store);
	g_object_set (G_OBJECT (renderer), "editable", TRUE, NULL);
	g_object_set_data (G_OBJECT (renderer), "column", (gpointer)1);
	gtk_tree_view_append_column (GTK_TREE_VIEW (gnome_ppp.init_strs.init_strs), column);
	
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (gnome_ppp.init_strs.init_strs), TRUE);
}

void populate_dns_list (const gchar *dns1, const gchar *dns2)
{
	GtkListStore *store;
	GtkTreeViewColumn *column;
	GtkCellRenderer *renderer;
	GtkTreeIter iter;
	
	store = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "DNS 1", 1, dns1, -1);
	
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, "DNS 2", 1, dns2, -1);
	
	gtk_tree_view_set_model (GTK_TREE_VIEW (gnome_ppp.setup.list_dns), GTK_TREE_MODEL (store));
	g_object_unref (G_OBJECT (store));

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Name", renderer, "text", 0, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (gnome_ppp.setup.list_dns), column);
	
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Value", renderer, "text", 1, NULL);
	g_signal_connect (renderer, "edited", G_CALLBACK (on_dns_edited), store);
	g_object_set (G_OBJECT (renderer), "editable", TRUE, NULL);
	g_object_set_data (G_OBJECT (renderer), "column", (gpointer)1);
	gtk_tree_view_append_column (GTK_TREE_VIEW (gnome_ppp.setup.list_dns), column);
	
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (gnome_ppp.setup.list_dns), TRUE);
}

void write_conf()
{
	GtkTreeModel *model;
	
	const gchar *home;
	gchar *wvconf;
	
	FILE *file;
	
	const gchar *username;
	const gchar *password;
	gboolean store_pwd;
	const gchar *phone;
	
	const gchar *device;
	gint type;
	const gchar *speed;
	gboolean tone;
	gboolean pulse;
	gint volume;
	gboolean dial_tone;
	gchar *phone1;
	gchar *phone2;
	gchar *phone3;
	gchar *phone4;
	gchar *init2;
	gchar *init3;
	gchar *init4;
	gchar *init5;
	gchar *init6;
	gchar *init7;
	gchar *init8;
	gchar *init9;
	const gchar *prefix;
	gdouble attempts;
	
	gboolean dynamic_ip;
	gboolean static_ip;
	const gchar *ip;
	const gchar *domain;
	gboolean auto_dns;
	gboolean manual_dns;
	gchar *dns1;
	gchar *dns2;
	
	gboolean minimize;
	gboolean dock;
	gboolean auto_reconnect;
	gboolean abort_on_busy;
	gboolean abort_on_no_dialtone;
	gboolean check_carrier;
	gboolean check_def_route;
	gboolean stupid_mode;
	gboolean custom_reply;
	const gchar *reply;
	gboolean idle;
	
	gchar *str_volume;
	
	username = gtk_entry_get_text (GTK_ENTRY(gnome_ppp.gnome_ppp.username));
	password = gtk_entry_get_text (GTK_ENTRY(gnome_ppp.gnome_ppp.password));
	store_pwd = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.gnome_ppp.store_pwd));
	phone = gtk_entry_get_text (GTK_ENTRY (GTK_BIN (gnome_ppp.gnome_ppp.phone)->child));
	
	
	device = gtk_entry_get_text (GTK_ENTRY (GTK_BIN(gnome_ppp.setup.device)->child));
	type = gtk_combo_box_get_active( GTK_COMBO_BOX(gnome_ppp.setup.type));
	speed = gtk_entry_get_text (GTK_ENTRY (GTK_BIN(gnome_ppp.setup.speed)->child));
	tone = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.tone));
	pulse = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.pulse));
	volume = gtk_combo_box_get_active( GTK_COMBO_BOX(gnome_ppp.setup.volume));
	dial_tone = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.dial_tone));
	
	model = gtk_tree_view_get_model (GTK_TREE_VIEW (gnome_ppp.phone.phone_nums));
	phone1 = get_tree_value (model, "0");
	phone2 = get_tree_value (model, "1");
	phone3 = get_tree_value (model, "2");
	phone4 = get_tree_value (model, "3");
	
	model = gtk_tree_view_get_model (GTK_TREE_VIEW (gnome_ppp.init_strs.init_strs));
	init2 = get_tree_value (model, "0");
	init3 = get_tree_value (model, "1");
	init4 = get_tree_value (model, "2");
	init5 = get_tree_value (model, "3");
	init6 = get_tree_value (model, "4");
	init7 = get_tree_value (model, "5");
	init8 = get_tree_value (model, "6");
	init9 = get_tree_value (model, "7");
	
	prefix = gtk_entry_get_text (GTK_ENTRY (gnome_ppp.setup.dial_prefix));
	attempts = gtk_spin_button_get_value (GTK_SPIN_BUTTON (gnome_ppp.setup.spin_dial_attempts));
	
	
	dynamic_ip = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.dynamic_ip));
	static_ip = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.static_ip));
	ip = gtk_entry_get_text (GTK_ENTRY (gnome_ppp.setup.entry_ip));
	
	domain = gtk_entry_get_text (GTK_ENTRY (gnome_ppp.setup.domain));
	auto_dns = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.auto_dns));
	manual_dns = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.manual_dns));
	
	model = gtk_tree_view_get_model (GTK_TREE_VIEW (gnome_ppp.setup.list_dns));
	dns1 = get_tree_value (model, "0");
	dns2 = get_tree_value (model, "1");
	
	minimize = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.minimize));
	dock = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.dock));
	auto_reconnect = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.auto_reconnect));
	abort_on_busy = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.abort_on_busy));
	abort_on_no_dialtone = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.abort_on_no_dialtone));
	check_carrier = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.check_carrier));
	check_def_route = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.check_def_route));
	stupid_mode = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.stupid_mode));
	custom_reply = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.custom_reply));
	reply = gtk_entry_get_text (GTK_ENTRY (gnome_ppp.setup.entry_reply));
	idle = gtk_spin_button_get_value (GTK_SPIN_BUTTON (gnome_ppp.setup.spin_idle));
		
	home = g_get_home_dir ();
	wvconf = g_build_filename (home, ".wvdial.conf", NULL);

	creat (wvconf, S_IRUSR|S_IWUSR);	
	file = fopen (wvconf, "w");
	
	g_fprintf (file, "[Dialer Defaults]\n");
	g_fprintf (file, "Modem = %s\n", device);
	
	if (type == 0) {
		g_fprintf (file, "ISDN = off\n");
		g_fprintf (file, "Modem Type = Analog Modem\n");
	} else if (type == 1) {
		g_fprintf (file, "ISDN = off\n");
		g_fprintf (file, "Modem Type = USB Modem\n");
	} else if (type == 2) {
		g_fprintf (file, "ISDN = on\n");
		g_fprintf (file, "Modem Type = ISDN Terminal Adapter\n");
	}
	g_fprintf (file, "Baud = %s\n", speed);
	
	if (volume == 0)
		str_volume = g_strdup ("ATM0L0");
	else if ( volume == 1)
		str_volume = g_strdup ("ATM1L1");
	else if (volume == 2)
		str_volume = g_strdup ("ATM1L3");
	
	if (dial_tone == TRUE)
		g_fprintf (file, "Init = ATZ\n");
	else
		g_fprintf (file, "Init = ATX3\n");
	
	g_fprintf (file, "Init2 = %s\n", init2);
	g_fprintf (file, "Init3 = %s\n", init3);
	g_fprintf (file, "Init4 = %s\n", init4);
	g_fprintf (file, "Init5 = %s\n", init5);
	g_fprintf (file, "Init6 = %s\n", init6);
	g_fprintf (file, "Init7 = %s\n", init7);
	g_fprintf (file, "Init8 = %s\n", init8);
	g_fprintf (file, "Init9 = %s\n", init9);
	g_fprintf (file, "Phone = %s\n", phone);
	g_fprintf (file, "Phone1 = %s\n", phone1);
	g_fprintf (file, "Phone2 = %s\n", phone2);
	g_fprintf (file, "Phone3 = %s\n", phone3);
	g_fprintf (file, "Phone4 = %s\n", phone4);
	g_fprintf (file, "Dial Prefix = %s\n", prefix);
	g_fprintf (file, "Dial Attempts = %d\n", (gint)attempts);
	
	if (tone == TRUE && pulse == FALSE) {
		g_fprintf (file, "Dial Command = %s", str_volume);
		g_fprintf (file, "DT\n");
	} else if ( tone == FALSE && pulse == TRUE ) {
		g_fprintf (file, "Dial Command = %s", str_volume);
		g_fprintf (file, "DP\n");
	}
	
	g_free (str_volume);
	
	if (dynamic_ip == FALSE && static_ip == TRUE)
		g_fprintf (file, "Force Address = %s\n", ip);
	
	if (store_pwd == TRUE) {
		g_fprintf (file, "Ask Password = off\n");
		g_fprintf (file, "Password = %s\n", password);
	} else {
		g_fprintf (file, "Ask Password = on\n" );
		g_fprintf (file, "Password = \n");
	}
	g_fprintf (file, "Username = %s\n", username );
	
	if (auto_reconnect == TRUE)
		g_fprintf (file, "Auto Reconnect = on\n");
	else
		g_fprintf (file, "Auto Reconnect = off\n");
	
	if (abort_on_busy == TRUE)
		g_fprintf (file, "Abort on Busy = on\n");
	else
		g_fprintf (file, "Abort on Busy = off\n");
	
	if (check_carrier == TRUE)
		g_fprintf (file, "Carrier Check = on\n");
	else
		g_fprintf (file, "Carrier Check = off\n");
	
	if (check_def_route == TRUE)
		g_fprintf (file, "Check Def Route = on\n");
	else
		g_fprintf (file, "Check Def Route = off\n");
	
	if (abort_on_no_dialtone == TRUE)
		g_fprintf (file, "Abort on No Dialtone = on\n");
	else
		g_fprintf (file, "Abort on No Dialtone = off\n");
	
	if (stupid_mode == TRUE)
		g_fprintf (file, "Stupid Mode = on\n");
	else
		g_fprintf (file, "Stupid Mode = off\n");
	
	if (custom_reply == TRUE)
		g_fprintf (file, "Default Reply = %s\n", reply);
	
	g_fprintf (file, "Idle Seconds = %d\n", (gint)idle);
	
	if (auto_dns == TRUE && manual_dns == FALSE)
		g_fprintf (file, "Auto DNS = on\n");
	else if (auto_dns == FALSE && manual_dns == TRUE) {		
		g_fprintf (file, "Auto DNS = off\n");
		g_fprintf (file, ";Domain = %s\n", domain);
		g_fprintf (file, ";Nameserver = %s\n", dns1);
		g_fprintf (file, ";Nameserver2 = %s\n", dns2);
		write_resolv_conf (domain, dns1, dns2);	
	}
	
	if (minimize == TRUE)
		g_fprintf (file, ";Minimize = on\n");
	else
		g_fprintf (file, ";Minimize = off\n");
	
	if (dock == TRUE)
		g_fprintf (file, ";Dock = on\n");
	else
		g_fprintf (file, ";Dock = off\n");
	
	g_fprintf (file, ";Do NOT edit this file by hand!\n");
	
	fclose (file);
	g_free (wvconf);
}

gchar *get_tree_value (GtkTreeModel *model, const gchar *index)
{
	GtkTreePath *path;
	GtkTreeIter iter;
	gchar *value;
	
	path = gtk_tree_path_new_from_string (index);
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_path_free (path);
	gtk_tree_model_get (model, &iter, 1, &value, -1);
	
	return value;
}

gchar *parse_conf_line (const gchar *line, gchar *str)
{
	int i;
	int j;
	gboolean found = FALSE;
		
	for (i = 0; i <= 99; i++) {
	
		if (line[i] == '=' && found == FALSE) {			
			int start = i + 2;
			found = TRUE;
						
			for (j = start; j <= 99; j++) {

				if ( line[j] != '\n' )
					str[j - start] = line[j];
				else
					str[j - start] = '\0';
			}
		}
	}
	
	return str;
}

void write_resolv_conf (const gchar *domain, const gchar *dns1, const gchar *dns2)
{
	/* i want something better here :/ */
	/* i want something better here :/ */
	/* i want something better here :/ */
	/* this needs root and overwrites /etc/resolv.conf */
	FILE *resolv;
		
	resolv = fopen ("/etc/resolv.conf", "w");
		
	if (resolv != NULL) {	
		g_fprintf (resolv, "domain %s\n", domain);
		g_fprintf (resolv, "nameserver %s\n", dns1);
		g_fprintf (resolv, "nameserver %s\n", dns2);
		fclose (resolv);
	}
}

void on_connect (GtkWidget *widget, gpointer data)
{
	int i;
	const gchar *home;
	gchar *wvconf;
	gboolean dock;
	
	GtkTextBuffer *txt;
	GtkTextIter end_iter;
	GtkTextIter start_iter;
	
	dock = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (gnome_ppp.setup.dock));
	gnome_ppp.dock = dock;
	
	/* first, write ~/.wvdial.conf */
	write_conf();
	
	/* second, clear wvdial output */
	txt = gtk_text_view_get_buffer (GTK_TEXT_VIEW (gnome_ppp.log.text_log));
	gtk_text_buffer_get_start_iter (txt, &start_iter);
	gtk_text_buffer_get_end_iter (txt, &end_iter);
	gtk_text_buffer_delete (txt, &start_iter, &end_iter);
	
	/* third, connect */
	g_print (_("GNOME PPP: Connecting...\n"));
	gtk_label_set_text (GTK_LABEL (gnome_ppp.connecting.msgs), _("Connecting..."));
	
	gtk_widget_hide (gnome_ppp.gnome_ppp.window);
	gtk_widget_show (gnome_ppp.connecting.window);
	
	home = g_get_home_dir ();
	wvconf = g_build_filename (home, ".wvdial.conf", NULL);
	
	i = 0;
	wvdial.cmd[i++] = "wvdial";
	wvdial.cmd[i++] = "--config";
	wvdial.cmd[i++] = wvconf;
	wvdial.cmd[i++] = NULL;
	
	if (!g_spawn_async_with_pipes (NULL,
					(char **)wvdial.cmd,
					NULL,
					G_SPAWN_SEARCH_PATH,
					NULL, NULL,
					&wvdial.pid,
					&wvdial.in_pipe,
					&wvdial.out_pipe,
					&wvdial.err_pipe,
					&wvdial.error)) {		
		g_warning (_("GNOME PPP: Command failed: %s\n"), wvdial.error->message);
		g_error_free (wvdial.error);
		wvdial.error = NULL;
	} else {
		/* stdout */
		wvdial.out = g_io_channel_unix_new (wvdial.out_pipe);
		g_io_channel_set_encoding (wvdial.out, NULL, NULL);
		wvdial.out_tag = g_io_add_watch (wvdial.out,
						(G_IO_IN | G_IO_HUP | G_IO_ERR),
						on_wvdial_out,
						NULL);
		
		g_io_channel_unref (wvdial.out);
		/* stderr */
		wvdial.err = g_io_channel_unix_new (wvdial.err_pipe);
		g_io_channel_set_encoding (wvdial.err, NULL, NULL);
		wvdial.err_tag = g_io_add_watch (wvdial.err,
						(G_IO_IN | G_IO_HUP | G_IO_ERR),
						on_wvdial_err,
						NULL);
		
		g_io_channel_unref (wvdial.err);
	}
}

void on_setup (GtkWidget *widget, gpointer data)
{
	gtk_widget_show( gnome_ppp.setup.window );
}

void on_quit (GtkWidget *widget, gpointer data)
{
	write_conf ();
	on_delete_event (widget, GDK_DELETE, data);
}

gboolean on_delete_event (GtkWidget *widget, GdkEvent *event, gpointer data)
{
	
	if (gnome_ppp.gnome_ppp.window != NULL)
		gtk_widget_destroy (gnome_ppp.gnome_ppp.window);
	
	if (gnome_ppp.setup.window != NULL)
		gtk_widget_destroy (gnome_ppp.setup.window);
	
	if (gnome_ppp.connecting.window != NULL)
		gtk_widget_destroy (gnome_ppp.connecting.window);
	
	if (gnome_ppp.log.window != NULL)
		gtk_widget_destroy (gnome_ppp.log.window);
	
	if (gnome_ppp.connected.window != NULL)
		gtk_widget_destroy (gnome_ppp.connected.window);
	
	if (gnome_ppp.details.window != NULL)
		gtk_widget_destroy (gnome_ppp.details.window);
	
	if (gnome_ppp.phone.window != NULL)
		gtk_widget_destroy (gnome_ppp.phone.window);
	
	if (gnome_ppp.init_strs.window != NULL)
		gtk_widget_destroy (gnome_ppp.init_strs.window );
	/* quit main gtk loop */
	gtk_main_quit();
	
	return FALSE;
}
