(((N_ "GnuCash Tutorial and Concepts Guide") 
  "gnc-help:gnucash-guide/index.html"
 (((N_ "Overview")
  "gnc-help:gnucash-guide/chapter1.html"
   (((N_ "Introduction")
     "gnc-help:gnucash-guide/oview_intro1.html" #f)
   ((N_ "Features")
     "gnc-help:gnucash-guide/oview_features1.html"
     (((N_ "Easy to Use")
       "gnc-help:gnucash-guide/oview_features1.html#oview_featureseasy2" #f)
     ((N_ "Tracks Your Investments")
       "gnc-help:gnucash-guide/oview_features1.html#oview_featuresinvest2" #f)
     ((N_ "International Support")
       "gnc-help:gnucash-guide/oview_features1.html#oview_featuresintl2" #f)
     ((N_ "Business Support")
       "gnc-help:gnucash-guide/oview_features1.html#oview_featuresbus2" #f)
     ((N_ "Accounting")
       "gnc-help:gnucash-guide/oview_features1.html#oview_featuresaccounting2" #f)
     ((N_ "Misc")
       "gnc-help:gnucash-guide/oview_features1.html#oview_featuresmisc2" #f)
     ((N_ "What's New in v1.8")
       "gnc-help:gnucash-guide/oview_features1.html#oview_featuresnew2" #f)
     )
    )
   ((N_ "About this Book")
     "gnc-help:gnucash-guide/oview_about1.html" #f)
   ((N_ "Top Ten Reasons to Use GnuCash")
     "gnc-help:gnucash-guide/oview_reasons1.html" #f)
   ((N_ "Installation")
     "gnc-help:gnucash-guide/oview_install1.html" #f)
   )
  )
 ((N_ "The Basics")
  "gnc-help:gnucash-guide/chapter2.html"
   (((N_ "Accounting Concepts")
     "gnc-help:gnucash-guide/basics_accounting1.html"
     (((N_ "The 5 Basic Accounts")
       "gnc-help:gnucash-guide/basics_accounting1.html#basics_accounting52" #f)
     ((N_ "The Principal Accounting Equation")
       "gnc-help:gnucash-guide/basics_accounting1.html#basics_accountingequation2" #f)
     ((N_ "Double Entry")
       "gnc-help:gnucash-guide/basics_accounting1.html#basics_accountingdouble2" #f)
     )
    )
   ((N_ "Data Entry Concepts")
     "gnc-help:gnucash-guide/basics_entry1.html"
     (((N_ "File, Accounts and Transactions")
       "gnc-help:gnucash-guide/basics_entry1.html#basics_accounts2" #f)
     ((N_ "Double Entry")
       "gnc-help:gnucash-guide/basics_entry1.html#basics_dbentry2" #f)
     )
    )
   ((N_ "The GnuCash Interface")
     "gnc-help:gnucash-guide/basics_interface1.html"
     (((N_ "Create a new set of accounts")
       "gnc-help:gnucash-guide/basics_interface1.html#basics_setup2" #f)
     ((N_ "Tip of the Day")
       "gnc-help:gnucash-guide/basics_interface1.html#basics_tip2" #f)
     ((N_ "Account Tree Window")
       "gnc-help:gnucash-guide/basics_interface1.html#basics_main2" #f)
     ((N_ "Account Register Window")
       "gnc-help:gnucash-guide/basics_interface1.html#basics_register2" #f)
     ((N_ "Tool Bar Buttons")
       "gnc-help:gnucash-guide/basics_interface1.html#basics_toolbar2" #f)
     ((N_ "Menu Items")
       "gnc-help:gnucash-guide/basics_interface1.html#basics_options2" #f)
     ((N_ "Menu Shortcuts")
       "gnc-help:gnucash-guide/basics_interface1.html#basics_shortcut2" #f)
     )
   )
   ((N_ "Setting Preferences")
     "gnc-help:gnucash-guide/basics_prefs1.html"
     (((N_ "Accounts")
       "gnc-help:gnucash-guide/basics_prefs1.html#basics_acctprefs2" #f)
     ((N_ "Business")
       "gnc-help:gnucash-guide/basics_prefs1.html#basics_business2" #f)
     ((N_ "General")
       "gnc-help:gnucash-guide/basics_prefs1.html#basics_general2" #f)
     ((N_ "International")
       "gnc-help:gnucash-guide/basics_prefs1.html#basics_international2" #f)
     ((N_ "Online Banking")
       "gnc-help:gnucash-guide/basics_prefs1.html#basics_onlinebank2" #f)
     ((N_ "Reconcile")
       "gnc-help:gnucash-guide/basics_prefs1.html#basics_reconcile2" #f)
     ((N_ "Register")
       "gnc-help:gnucash-guide/basics_prefs1.html#basics_regprefs2" #f)
     ((N_ "Register Colors")
       "gnc-help:gnucash-guide/basics_prefs1.html#basics_registercolors2" #f)
     ((N_ "Scheduled Transactions")
       "gnc-help:gnucash-guide/basics_prefs1.html#basics_schedtrans2" #f)
     )
   )
   ((N_ "Getting Help")
     "gnc-help:gnucash-guide/basics_help1.html"
     (((N_ "Help Manual")
       "gnc-help:gnucash-guide/basics_help1.html#basics_manual2" #f)
     ((N_ "Web Access")
       "gnc-help:gnucash-guide/basics_help1.html#basics_web2" #f)
     ((N_ "Topic Search")
       "gnc-help:gnucash-guide/basics_help1.html#basics_topic2" #f)
     )
   )
   ((N_ "Creating and Saving Files")
     "gnc-help:gnucash-guide/basics_files1.html" #f)
   ((N_ "Importing QIF Files")
     "gnc-help:gnucash-guide/basics_import1.html" #f)
   ((N_ "Backing Up and Recovering Data")
     "gnc-help:gnucash-guide/basics_backup1.html"
     (((N_ "Backup file (.xac)")
       "gnc-help:gnucash-guide/basics_backup1.html#basics_backupxac2" #f)
      ((N_ "Log file (.log)")
       "gnc-help:gnucash-guide/basics_backup1.html#basics_backuplog2" #f)
      ((N_ "Lock files (.LNK and .LCK)")
       "gnc-help:gnucash-guide/basics_backup1.html#basics_backuplock2" #f)
      ((N_ "File Management")
       "gnc-help:gnucash-guide/basics_backup1.html#basics_backupmanage2" #f)
     )
    )
   ((N_ "Putting It All Together")
     "gnc-help:gnucash-guide/basics_together1.html" #f)
   )
  )
 ((N_ "Accounts")
  "gnc-help:gnucash-guide/chapter3.html"
   (((N_ "Basic Accounting Concepts")
     "gnc-help:gnucash-guide/accts_concepts1.html"
     (((N_ "Balance Sheet Accounts")
       "gnc-help:gnucash-guide/accts_concepts1.html#accts_bsa2" #f)
      ((N_ "Income and Expense Accounts")
       "gnc-help:gnucash-guide/accts_concepts1.html#accts_ie2" #f)
      ((N_ "Principle of Balance")
       "gnc-help:gnucash-guide/accts_concepts1.html#accts_balance2" #f)
      )
     )
     ((N_ "GnuCash Accounts")
      "gnc-help:gnucash-guide/accts_types1.html"
       (((N_ "Balance Sheet Accounts")
         "gnc-help:gnucash-guide/accts_types1.html#accts_gc_bsa2" #f)
        ((N_ "Income and Expense Accounts")
         "gnc-help:gnucash-guide/accts_types1.html#accts_gc_ie2" #f)
       )
     )
    ((N_ "Putting It All Together")
     "gnc-help:gnucash-guide/accts_examples1.html" 
       (((N_ "Simple Example")
         "gnc-help:gnucash-guide/accts_examples1.html#accts_examples_situation2" #f)
        ((N_ "The Basic Top Level Accounts")
         "gnc-help:gnucash-guide/accts_examples1.html#accts_examples_toplevel2" #f)
        ((N_ "Making Sub-Accounts")
         "gnc-help:gnucash-guide/accts_examples1.html#accts_examples_organization2" #f)
       )
    )
   )
  )
 ((N_ "Transactions")
  "gnc-help:gnucash-guide/chapter4.html"
   (((N_ "Basic Concepts")
     "gnc-help:gnucash-guide/txns_concepts1.html" #f)
    ((N_ "The Account Register")
     "gnc-help:gnucash-guide/txns_registers1.html"
     (((N_ "Simple Two Account Transaction")
       "gnc-help:gnucash-guide/txns_registers1.html#txns_registers_twoaccount2" #f)
      ((N_ "Multi Account Transaction")
       "gnc-help:gnucash-guide/txns_registers1.html#txns_registers_multiaccount2" #f)
      ((N_ "Features of the Account Register")
       "gnc-help:gnucash-guide/txns_registers1.html#txns_registers_features2" #f)
      )
     )
    ((N_ "Choosing a Register Style")
     "gnc-help:gnucash-guide/txns_regstyle1.html" #f)
    ((N_ "Using Entry Shortcuts")
     "gnc-help:gnucash-guide/txns_shortcuts1.html" #f)
    ((N_ "Reconciliation")
     "gnc-help:gnucash-guide/txns_reconcile1.html"
     (((N_ "Reconcile Window")
       "gnc-help:gnucash-guide/txns_reconcile1.html#txns_reconcile_window2" #f)
      )
     )
    ((N_ "Scheduled Transactions")
     "gnc-help:gnucash-guide/txns_sxn1.html"
     (((N_ "Creating from the Ledger")
       "gnc-help:gnucash-guide/txns_sxn1.html#txns_sxn_ledger2" #f)
      ((N_ "Creating from the Editor")
       "gnc-help:gnucash-guide/txns_sxn1.html#txns_sxn_editor2" #f)
      )
     )
    ((N_ "Putting It All Together")
     "gnc-help:gnucash-guide/txns_puttoget1.html"
     (((N_ "Opening Balances")
       "gnc-help:gnucash-guide/txns_puttoget1.html#txns_puttoget_open2" #f)
	   ((N_ "Additional Transaction Examples")
       "gnc-help:gnucash-guide/txns_puttoget1.html#txns_puttoget_add2" #f)
     )
    )
   )
  )
 ((N_ "Checkbook")
  "gnc-help:gnucash-guide/chapter5.html"
   (((N_ "Setting up Accounts")
     "gnc-help:gnucash-guide/cbook_accounts1.html" #f)
    ((N_ "Entering Deposits")
     "gnc-help:gnucash-guide/cbook_deposits1.html" #f)
    ((N_ "Entering Withdrawals")
     "gnc-help:gnucash-guide/cbook_withdrawals1.html"
      (((N_ "ATM/Cash Withdrawals")
        "gnc-help:gnucash-guide/cbook_withdrawals1.html#cbook_atm2" #f)
      )
    )
    ((N_ "Reconciling Your Accounts")
     "gnc-help:gnucash-guide/cbook_reconacct1.html" #f)
    ((N_ "Putting It All Together")
     "gnc-help:gnucash-guide/cbook_together1.html" #f)
   )
  )
 ((N_ "Credit Cards")
  "gnc-help:gnucash-guide/chapter6.html"
   (((N_ "Concepts")
     "gnc-help:gnucash-guide/cc_concepts1.html" #f)
    ((N_ "Setting up Accounts")
     "gnc-help:gnucash-guide/cc_accounts1.html"
      (((N_ "Simple Setup")
        "gnc-help:gnucash-guide/cc_accounts1.html#cc_accounts_simple2" #f)
	    ((N_ "Complete Setup")
        "gnc-help:gnucash-guide/cc_accounts1.html#cc_accounts_complete2" #f)
      )
	 )
    ((N_ "Entering Charges")
     "gnc-help:gnucash-guide/cc_entercharge1.html" #f)
    ((N_ "Entering Payments")
     "gnc-help:gnucash-guide/cc_enterpay1.html" #f)
    ((N_ "Putting It All Together")
     "gnc-help:gnucash-guide/cc_together1.html"
      (((N_ "Purchases")
        "gnc-help:gnucash-guide/cc_together1.html#cc_together_purchases2" #f)
	    ((N_ "Refund")
        "gnc-help:gnucash-guide/cc_together1.html#cc_together_refund2" #f)
	    ((N_ "Interest Charge")
        "gnc-help:gnucash-guide/cc_together1.html#cc_together_interest2" #f)
	    ((N_ "Reconciliation")
        "gnc-help:gnucash-guide/cc_together1.html#cc_together_reconcile2" #f)
	    ((N_ "Payment")
        "gnc-help:gnucash-guide/cc_together1.html#cc_together_payment2" #f)
      )
	 )
   )
  )
 ((N_ "Loans")
  "gnc-help:gnucash-guide/chapter7.html"
   (((N_ "Basic Concepts")
     "gnc-help:gnucash-guide/loans_concepts1.html"
     (((N_ "Terminology")
       "gnc-help:gnucash-guide/loans_concepts1.html#loans_conceptsterms2" #f)
      )
	)
    ((N_ "Setting Up Accounts")
       "gnc-help:gnucash-guide/loans_accounts1.html" #f)
    ((N_ "Mortgage (How-To)")
       "gnc-help:gnucash-guide/loans_mortgage1.html" #f)
    ((N_ "Calculations")
       "gnc-help:gnucash-guide/loans_calcs1.html"
      (((N_ "Example: Monthly Payments")
        "gnc-help:gnucash-guide/loans_calcs1.html#loans_calcsexample1_2" #f)
	    ((N_ "Example: Length of Loan")
        "gnc-help:gnucash-guide/loans_calcs1.html#loans_calcsexample2_2" #f)
	    ((N_ "Advanced: Calculation Details")
        "gnc-help:gnucash-guide/loans_calcs1.html#loans_calcsdetails2" #f)
	  )
	 )
   )
  )
 ((N_ "Investments")
  "gnc-help:gnucash-guide/chapter8.html"

   (((N_ "Basic Concepts")
     "gnc-help:gnucash-guide/invest_concepts1.html"
     (((N_ "Terminology")
       "gnc-help:gnucash-guide/invest_concepts1.html#invest_terms2" #f)
      ((N_ "Types of Investments")
       "gnc-help:gnucash-guide/invest_concepts1.html#invest_types2" #f)
      )
     )
    ((N_ "Setting up Accounts")
     "gnc-help:gnucash-guide/invest_accounts1.html"
     (((N_ "Predefined Accounts")
       "gnc-help:gnucash-guide/invest_accounts1.html#invest_predefined2" #f)
      ((N_ "Custom Accounts Example")
       "gnc-help:gnucash-guide/invest_accounts1.html#invest_custom2" #f)
      )
     )
    ((N_ "Interest Bearing Accounts")
     "gnc-help:gnucash-guide/invest_int1.html"
     (((N_ "Account Setup")
       "gnc-help:gnucash-guide/invest_int1.html#invest_intacct2" #f)
      ((N_ "Example")
       "gnc-help:gnucash-guide/invest_setup1.html#invest_intex2" #f)
      )
	 )
    ((N_ "Setup Your Stock Portfolio")
     "gnc-help:gnucash-guide/invest_setup1.html"
     (((N_ "Setup Your Preexisting Stocks")
       "gnc-help:gnucash-guide/invest_setup1.html#invest_setup_preexisting2" #f)
      ((N_ "Example Stock Account")
       "gnc-help:gnucash-guide/invest_setup1.html#invest_setup_example2" #f)
      ((N_ "Buying New Investments")
       "gnc-help:gnucash-guide/invest_setup1.html#invest_setup_new2" #f)
      )
     )
    ((N_ "Setting Stock Price")
     "gnc-help:gnucash-guide/invest_stockprice1.html"
     (((N_ "Initial Price Editor Setup")
       "gnc-help:gnucash-guide/invest_stockprice1.html#invest_stockprice_initial2" #f)
      ((N_ "Setting Stock Price Manually")
       "gnc-help:gnucash-guide/invest_stockprice1.html#invest_stockprice_manual2" #f)
      ((N_ "Setting Stock Price Automatically")
       "gnc-help:gnucash-guide/invest_stockprice1.html#invest_stockprice_auto2" #f)
      ((N_ "Display Stock Value")
       "gnc-help:gnucash-guide/invest_stockprice1.html#invest_stockprice_view2" #f)
      )
     )
    ((N_ "Dividends")
     "gnc-help:gnucash-guide/invest_dividends1.html" #f)
    ((N_ "Selling Stocks")
     "gnc-help:gnucash-guide/invest_sell1.html" 
      (((N_ "Example")
       "gnc-help:gnucash-guide/invest_sell1.html#invest_sellexample2" #f)
      )
    )
    ((N_ "Todo Investment Docs")
       "gnc-help:gnucash-guide/invest_todo1.html" #f)
   )
  )



 ((N_ "Capital Gains")
  "gnc-help:gnucash-guide/chapter9.html"

   (((N_ "Basic Concepts")
     "gnc-help:gnucash-guide/capgain_concepts1.html" #f)
    ((N_ "Estimating Valuation")
      "gnc-help:gnucash-guide/capgain_value1.html" #f)
    ((N_ "Account Setup")
      "gnc-help:gnucash-guide/capgain_accounts1.html" #f)
    ((N_ "Example")
      "gnc-help:gnucash-guide/capgain_example1.html"
      (((N_ "Unrealized Gains")
        "gnc-help:gnucash-guide/capgain_example1.html#capgain_exampleunrealized2" #f)
       ((N_ "Selling")
        "gnc-help:gnucash-guide/capgain_example1.html#capgain_examplesell2" #f)
       ((N_ "Caution about Valuation")
         "gnc-help:gnucash-guide/capgain1.html#depcap_examplecaution2" #f)
       )
    )
    ((N_ "Taxation")
      "gnc-help:gnucash-guide/capgain_tax1.html" #f)
   )
  )

 ((N_ "Multiple Currencies")
  "gnc-help:gnucash-guide/chapter10.html"
   (((N_ "Basic Concepts")
     "gnc-help:gnucash-guide/currency_concepts1.html" #f)
	((N_ "Account Setup")
     "gnc-help:gnucash-guide/currency_acct1.html" #f)
	((N_ "GnuCash Currency Support")
     "gnc-help:gnucash-guide/currency_support1.html" #f)
	((N_ "Setting International Preferences")
     "gnc-help:gnucash-guide/currency_prefs1.html" #f)
	((N_ "Recording Currency Exchange (How-To)")
     "gnc-help:gnucash-guide/currency_howtot1.html" #f)
	((N_ "Recording Purchases in a Foreign Currency (How-To)")
     "gnc-help:gnucash-guide/currency_purchase1.html" #f)
	((N_ "Tracking Currency Investments (How-To)")
     "gnc-help:gnucash-guide/currency_invest1.html" #f)
	((N_ "Reconciling Statements in a Foreign Currency (How-To)")
     "gnc-help:gnucash-guide/currency_reconcile1.html" #f)
	((N_ "Updating Exchange Rates (How-To)")
     "gnc-help:gnucash-guide/currency_update1.html" #f)
	((N_ "Putting It All Together (Examples)")
     "gnc-help:gnucash-guide/currency_examples1.html" #f)
   )
  )

 ((N_ "Depreciation")
  "gnc-help:gnucash-guide/chapter11.html"

    (((N_ "Basic Concepts")
      "gnc-help:gnucash-guide/dep_concepts1.html" #f)
     ((N_ "Estimating Valuation")
       "gnc-help:gnucash-guide/dep_value1.html"
       (((N_ "Depreciation Schemes")
         "gnc-help:gnucash-guide/dep_value1.html#dep_valueschemes2" #f)
       )
      )
    ((N_ "Account Setup")
      "gnc-help:gnucash-guide/dep_accounts1.html" #f)
    ((N_ "Example")
      "gnc-help:gnucash-guide/dep_example1.html" #f)
   )
 )

 ((N_ "Accounts Receivable")
  "gnc-help:gnucash-guide/chapter12.html"
   (((N_ "Overview of Business Features")
     "gnc-help:gnucash-guide/bus_ar_overview1.html" #f)
    ((N_ "Basic Concepts")
     "gnc-help:gnucash-guide/bus_ar_concepts1.html" #f)
	((N_ "Initial Setup")
     "gnc-help:gnucash-guide/bus_ar_setup1.html"
      (((N_ "Account Setup")
        "gnc-help:gnucash-guide/bus_ar_setup1.html#bus_ar_setupacct2" #f)
       ((N_ "Register Your Company")
        "gnc-help:gnucash-guide/bus_ar_setup1.html#bus_ar_setupcname2" #f)
      )
	)
	((N_ "System Components")
     "gnc-help:gnucash-guide/bus_ar_components1.html" #f)
	((N_ "Customers")
     "gnc-help:gnucash-guide/bus_ar_customers1.html"
      (((N_ "New")
        "gnc-help:gnucash-guide/bus_ar_customers1.html#bus_ar_custnew2" #f)
       ((N_ "Find and Edit")
        "gnc-help:gnucash-guide/bus_ar_customers1.html#bus_ar_custfind2" #f)
      )
     )
	((N_ "Invoices")
     "gnc-help:gnucash-guide/bus_ar_invoices1.html"
      (((N_ "New")
        "gnc-help:gnucash-guide/bus_ar_invoices1.html#bus_ar_invoicenew2" #f)
       ((N_ "Edit")
        "gnc-help:gnucash-guide/bus_ar_invoices1.html#bus_ar_invoiceedit2" #f)
       ((N_ "Post")
        "gnc-help:gnucash-guide/bus_ar_invoices1.html#bus_ar_invoicepost2" #f)
       ((N_ "Find")
        "gnc-help:gnucash-guide/bus_ar_invoices1.html#bus_ar_invoicefind2" #f)
       ((N_ "Print")
        "gnc-help:gnucash-guide/bus_ar_invoices1.html#bus_ar_invoiceprint2" #f)
       ((N_ "Assign Starting Invoice Number")
        "gnc-help:gnucash-guide/bus_ar_invoices1.html#bus_ar_invoicestarting2" #f)
       )
     )
	((N_ "Customer Jobs")
     "gnc-help:gnucash-guide/bus_ar_jobs1.html" #f)
	((N_ "Process Payment")
     "gnc-help:gnucash-guide/bus_ar_payment1.html" #f)
	((N_ "Changing the Invoice Appearance")
     "gnc-help:gnucash-guide/bus_ar_invoicechange1.html" #f)
    )
  )

 ((N_ "Accounts Payable")
  "gnc-help:gnucash-guide/chapter13.html"
   (((N_ "Basic Concepts")
     "gnc-help:gnucash-guide/bus_ap_concepts1.html" #f)
	((N_ "Initial Setup")
     "gnc-help:gnucash-guide/bus_ap_setup1.html"
      (((N_ "Account Setup")
        "gnc-help:gnucash-guide/bus_ap_setup1.html#bus_ap_setupacct2" #f)
       ((N_ "Register Your Company")
        "gnc-help:gnucash-guide/bus_ap_setup1.html#bus_ap_setupcname2" #f)
      )
	)
	((N_ "System Components")
     "gnc-help:gnucash-guide/bus_ap_components1.html" #f)
	((N_ "Vendors")
     "gnc-help:gnucash-guide/bus_ap_vendors1.html"
      (((N_ "New")
        "gnc-help:gnucash-guide/bus_ap_vendors1.html#bus_ap_vendornew2" #f)
       ((N_ "Find and Edit")
        "gnc-help:gnucash-guide/bus_ap_vendors1.html#bus_ap_vendorfind2" #f)
      )
     )
	((N_ "Bills")
     "gnc-help:gnucash-guide/bus_ap_bills1.html"
      (((N_ "New")
        "gnc-help:gnucash-guide/bus_ap_bills1.html#bus_ap_billnew2" #f)
       ((N_ "Edit")
        "gnc-help:gnucash-guide/bus_ap_bills1.html#bus_ap_billedit2" #f)
       ((N_ "Post")
        "gnc-help:gnucash-guide/bus_ap_bills1.html#bus_ap_billpost2" #f)
       ((N_ "Find")
        "gnc-help:gnucash-guide/bus_ap_bills1.html#bus_ap_billfind2" #f)
       )
     )
	((N_ "Vendor Jobs")
     "gnc-help:gnucash-guide/bus_ap_jobs1.html" #f)
	((N_ "Process Payment")
     "gnc-help:gnucash-guide/bus_ap_payment1.html" #f)
    )
  )

 ((N_ "Payroll")
  "gnc-help:gnucash-guide/chapter14.html"
   (((N_ "Basic Concepts")
     "gnc-help:gnucash-guide/bus_pay_concepts1.html" #f)
	((N_ "Account Setup")
     "gnc-help:gnucash-guide/bus_pay_acct1.html" #f)
	((N_ "Protocol")
     "gnc-help:gnucash-guide/bus_pay_protocol1.html"
      (((N_ "Step 1: Deductions List")
        "gnc-help:gnucash-guide/bus_pay_protocol1.html#bus_pay_protocolone2" #f)
       ((N_ "Step 2: Create the Transaction Map")
        "gnc-help:gnucash-guide/bus_pay_protocol1.html#bus_pay_protocoltwo2" #f)
       ((N_ "Step 3: Pay the Employee")
        "gnc-help:gnucash-guide/bus_pay_protocol1.html#bus_pay_protocolthree2" #f)
       ((N_ "Step 4: Pay the Government")
        "gnc-help:gnucash-guide/bus_pay_protocol1.html#bus_pay_protocolfour2" #f)
       )
     )
	((N_ "Example")
     "gnc-help:gnucash-guide/bus_pay_example1.html"
      (((N_ "Build Protocol")
        "gnc-help:gnucash-guide/bus_pay_example1.html#bus_pay_exampleprotocol2" #f)
       ((N_ "Pay an Employee")
        "gnc-help:gnucash-guide/bus_pay_example1.html#bus_pay_examplepay2" #f)
       ((N_ "Pay the Government")
        "gnc-help:gnucash-guide/bus_pay_example1.html#bus_pay_examplegovt2" #f)
      )
    )
   )
  )

 ((N_ "Appendix A: Migration Guide")
  "gnc-help:gnucash-guide/appendixa.html" #f)
 ((N_ "Appendix B: Frequently Asked Questions")
  "gnc-help:gnucash-guide/appendixb.html" #f)
 ((N_ "Appendix C: Contributed Account Trees")
  "gnc-help:gnucash-guide/appendixc.html" #f)
 ((N_ "Appendix D: GNU Free Documentation License")
  "gnc-help:gnucash-guide/fdl.html" #f)


 )
)

((N_ "GnuCash Help") 
 "gnc-help:gnucash-help/help.html"
 
 (((N_ "Introduction to GnuCash") 
   "gnc-help:gnucash-help/intro-to-gnucash.html"
   (((N_ "What is GnuCash?") 
     "gnc-help:gnucash-help/intro-to-gnucash.html#what-is-gnucash" #f)
    )
   )

  ((N_ "Getting Started") 
   "gnc-help:gnucash-help/getting-started.html"
   (((N_ "Running GnuCash for the First Time") 
     "gnc-help:gnucash-help/getting-started.html#first-time"
     (((N_ "New Account Hierarchy Setup") 
       "gnc-help:gnucash-help/getting-started.html#acct-hierarchy" #f)
      ((N_ "Import QIF Files")
       "gnc-help:gnucash-help/getting-started.html#import-qif" #f)
      ((N_ "GnuCash Tutorial and Concepts Guide")
       "gnc-help:gnucash-help/getting-started.html#tutorial" #f)
      )
     )
    ((N_ "Tip of the Day")
     "gnc-help:gnucash-help/getting-started.html#tip-of-the-day" #f)
    )
   )

  ((N_ "Usage") ""
   (((N_ "GnuCash Windows")
     "gnc-help:gnucash-help/usage.html#windows"
     (((N_ "Account Tree Window")
       "gnc-help:gnucash-help/usage.html#account-tree"
      (((N_ "Menus")
	"gnc-help:gnucash-help/usage.html#tree-menus" #f)
       ((N_ "Tool Bar Buttons")
	"gnc-help:gnucash-help/usage.html#tree-toolbar" #f)
       ((N_ "Summary Bar")
	"gnc-help:gnucash-help/usage.html#tree-summary" #f)
       ((N_ "Account Tree")
	"gnc-help:gnucash-help/usage.html#tree-main" #f)
       ((N_ "Status Bar")
	"gnc-help:gnucash-help/usage.html#tree-status" #f)
       )
      )
      ((N_ "Account Register Window")
       "gnc-help:gnucash-help/usage.html#account-register"
       (((N_ "Menus")
	"gnc-help:gnucash-help/usage.html#reg-menus" #f)
       ((N_ "Tool Bar Buttons")
	"gnc-help:gnucash-help/usage.html#reg-toolbar" #f)
       ((N_ "Summary Bar")
	"gnc-help:gnucash-help/usage.html#reg-summary" #f)
       ((N_ "List of Transactions")
	"gnc-help:gnucash-help/usage.html#reg-main" #f)
       ((N_ "Status Bar")
	"gnc-help:gnucash-help/usage.html#reg-status" #f)
       ((N_ "General Ledger")
	"gnc-help:gnucash-help/usage.html#reg-gl" #f)
       )
      )
      ((N_ "Report Window")
       "gnc-help:gnucash-help/usage.html#report-win"
       (((N_ "Tool Bar Buttons")
	"gnc-help:gnucash-help/usage.html#report-toolbar" #f)
       ((N_ "Report")
	"gnc-help:gnucash-help/usage.html#report-main" #f)
       )
      )
      ((N_ "Tool Windows")
       "gnc-help:gnucash-help/usage.html#tool-win"
       (((N_ "Scheduled Transactions Window")
	"gnc-help:gnucash-help/usage.html#tool-sched" #f)
       ((N_ "Reconcile Window")
	"gnc-help:gnucash-help/usage.html#tool-reconcile" #f)
       ((N_ "Price Editor")
	"gnc-help:gnucash-help/usage.html#tool-price" #f)
       ((N_ "Commodity Editor")
	"gnc-help:gnucash-help/usage.html#tool-commodity" #f)
       ((N_ "Financial Calculator")
	"gnc-help:gnucash-help/usage.html#tool-calc" #f)
       ((N_ "Find Transactions")
	"gnc-help:gnucash-help/usage.html#tool-find" #f)
       )
      )
      ((N_ "Help Window")
       "gnc-help:gnucash-help/usage.html#help-win" #f)
      )
     )
    ((N_ "Setting Up and Editing Accounts")
     "gnc-help:gnucash-help/usage.html#setup-accounts"
     (((N_ "Types of GnuCash Accounts")
       "gnc-help:gnucash-help/usage.html#acct-types" #f)
      ((N_ "To Create a Chart of Accounts")
       "gnc-help:gnucash-help/usage.html#chart-create" #f)
      ((N_ "To Create a New Account")
       "gnc-help:gnucash-help/usage.html#acct-create"
       (((N_ "General Information")
	 "gnc-help:gnucash-help/usage.html#gen-info" #f)
	((N_ "Opening Balance")
	 "gnc-help:gnucash-help/usage.html#open-balance" #f)
	)
       )
      ((N_ "To Edit an Account")
       "gnc-help:gnucash-help/usage.html#acct-edit" #f)
      ((N_ "To Edit a Chart of Accounts")
       "gnc-help:gnucash-help/usage.html#chart-edit" #f)
      ((N_ "To Delete an Account")
       "gnc-help:gnucash-help/usage.html#acct-delete" #f)
      ((N_ "To Jump to Another Account")
       "gnc-help:gnucash-help/usage.html#acct-jump" #f)
      ((N_ "To Reconcile an Account to a Statement")
       "gnc-help:gnucash-help/usage.html#acct-reconcile"
       (((N_ "Reconcile Information")
	 "gnc-help:gnucash-help/usage.html#rec-info" #f)
	((N_ "Reconcile Window")
	 "gnc-help:gnucash-help/usage.html#rec-win" #f)
	)
       )
      ((N_ "To Perform a Stock Split")
       "gnc-help:gnucash-help/usage.html#stock-split"
       (((N_ "Stock Split Druid")
	 "gnc-help:gnucash-help/usage.html#stock-split-druid" #f)
	)
       )
      )
     )
    ((N_ "Using the Register to Record Transactions")
     "gnc-help:gnucash-help/usage.html#transactions"
     (((N_ "Changing the Register View")
       "gnc-help:gnucash-help/usage.html#reg-views" #f)
      ((N_ "To Enter a Transaction")
       "gnc-help:gnucash-help/usage.html#trans-enter"
       (((N_ "Enter Directly in the Register Window")
	 "gnc-help:gnucash-help/usage.html#trans-reg-enter" #f)
	((N_ "Enter in the Transfer Funds Window")
	 "gnc-help:gnucash-help/usage.html#trans-win-enter" #f)
	)
       )
      ((N_ "To Enter Multiple Split Transactions")
       "gnc-help:gnucash-help/usage.html#trans-multi-enter" #f)
      ((N_ "To Enter Multiple Currency Transactions")
       "gnc-help:gnucash-help/usage.html#trans-currency-enter" #f)
      ((N_ "To Edit a Transaction")
       "gnc-help:gnucash-help/usage.html#trans-edit" #f)
      ((N_ "To Delete a Transaction")
       "gnc-help:gnucash-help/usage.html#trans-delete" #f)
      ((N_ "To Remove Transaction Splits")
       "gnc-help:gnucash-help/usage.html#trans-split-remove" #f)
      ((N_ "To Copy a Transaction")
       "gnc-help:gnucash-help/usage.html#trans-copy" #f)
      ((N_ "To Schedule Transactions")
       "gnc-help:gnucash-help/usage.html#tran-sched"
       (((N_ "Scheduled Transaction Editor")
	 "gnc-help:gnucash-help/usage.html#trans-sched-editor" #f)
	((N_ "Since Last Run Druid")
	 "gnc-help:gnucash-help/usage.html#trans-sched-slr" #f)
	((N_ "Mortgage & Loan Repayment Druid")
	 "gnc-help:gnucash-help/usage.html#trans-sched-loans" #f)
	)
       )
      ((N_ "To Print Checks")
       "gnc-help:gnucash-help/usage.html#print-check" #f)
      )
     )
    ((N_ "Using GnuCash Reports and Charts")
     "gnc-help:gnucash-help/usage.html#reports"
       (((N_ "Types of Reports and Graphs")
	 "gnc-help:gnucash-help/usage.html#report-types"
	 (((N_ "General Reports")
	   "gnc-help:gnucash-help/usage.html#report-general" #f)
	  ((N_ "Assets & Liabilities")
	   "gnc-help:gnucash-help/usage.html#report-assets" #f)
	  ((N_ "Income & Expense")
	   "gnc-help:gnucash-help/usage.html#report-income" #f)
	  ((N_ "Business Reports")
	   "gnc-help:gnucash-help/usage.html#report-biz" #f)
	  )
	 )
	((N_ "To Create Reports and Graphs")
	 "gnc-help:gnucash-help/usage.html#report-create" #f)
	((N_ "To Customize Reports and Graphs")
	 "gnc-help:gnucash-help/usage.html#report-custom" #f)
	((N_ "To Print or Export Reports and Graphs")
	 "gnc-help:gnucash-help/usage.html#report-print" #f)
	)
       )
    )
   )
  ((N_ "Customizing GnuCash")
   "gnc-help:gnucash-help/custom-gnucash.html"
   (((N_ "Account Options")
     "gnc-help:gnucash-help/custom-gnucash.html#account-options" #f)
    ((N_ "Setting Your Preferences")
     "gnc-help:gnucash-help/custom-gnucash.html#set-prefs"
     (((N_ "Accounts")
       "gnc-help:gnucash-help/custom-gnucash.html#prefs-accounts" #f)
      ((N_ "Business")
       "gnc-help:gnucash-help/custom-gnucash.html#prefs-biz" #f)
      ((N_ "General")
       "gnc-help:gnucash-help/custom-gnucash.html#prefs-general" #f)
      ((N_ "International")
       "gnc-help:gnucash-help/custom-gnucash.html#prefs-inter" #f)
      ((N_ "Online Banking & Importing")
       "gnc-help:gnucash-help/custom-gnucash.html#prefs-online" #f)
      ((N_ "Reconcile")
       "gnc-help:gnucash-help/custom-gnucash.html#prefs-rec" #f)
      ((N_ "Register")
       "gnc-help:gnucash-help/custom-gnucash.html#prefs-reg" #f)
      ((N_ "Register Colors")
       "gnc-help:gnucash-help/custom-gnucash.html#prefs-reg-color" #f)
      ((N_ "Scheduled Transactions")
       "gnc-help:gnucash-help/custom-gnucash.html#prefs-sched" #f)
      ((N_ "User Info")
       "gnc-help:gnucash-help/custom-gnucash.html#prefs-user" #f)
      ((N_ "Advanced")
       "gnc-help:gnucash-help/custom-gnucash.html#prefs-advanced" #f)
      )
     )
    ((N_ "Changing Style Sheets")
     "gnc-help:gnucash-help/custom-gnucash.html#change-style"
     (((N_ "Default")
       "gnc-help:gnucash-help/custom-gnucash.html#style-default"
       (((N_ "General")
	 "gnc-help:gnucash-help/custom-gnucash.html#style-def-general" #f)
	((N_ "Tables")
	 "gnc-help:gnucash-help/custom-gnucash.html#style-def-tables" #f)
	)
       )
      ((N_ "Technicolor")
       "gnc-help:gnucash-help/custom-gnucash.html#style-technicolor"
       (((N_ "Colors")
	 "gnc-help:gnucash-help/custom-gnucash.html#style-tech-colors" #f)
	((N_ "General")
	 "gnc-help:gnucash-help/custom-gnucash.html#style-tech-general" #f)
	((N_ "Images")
	 "gnc-help:gnucash-help/custom-gnucash.html#style-tech-images" #f)
	((N_ "Tables")
	 "gnc-help:gnucash-help/custom-gnucash.html#style-tech-tables" #f)
	)
       )
      )
     )
    ((N_ "Setting Tax Options")
     "gnc-help:gnucash-help/custom-gnucash.html#set-tax-options"
     (((N_ "TXF Export - Known Anomalies and Limitations")
       "gnc-help:gnucash-help/custom-gnucash.html#txf-probs" #f)
      ((N_ "Detailed TXF Category Descriptions")
       "gnc-help:gnucash-help/custom-gnucash.html#txf-defs" #f)
      )
     )
     )
    )
   )
  )
((N_ "Report a bug") "http://bugzilla.gnome.org" #f)
)
