# GNU Enterprise Application Server - Language interface application
#
# Copyright 2003-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: App.py 5043 2004-01-27 15:05:42Z johannes $

from gnue.common.apps import GClientApp
from gnue.common.datasources import GLoginHandler
from gnue.appserver import geasSessionManager
import Session

# =============================================================================
# Helper class for standalone applications using the Language Interface
# =============================================================================

class App (GClientApp.GClientApp):

  # ---------------------------------------------------------------------------
  # Initialize
  # ---------------------------------------------------------------------------

  def __init__ (self):
    GClientApp.GClientApp.__init__ (self)

    self.connections.setLoginHandler (myLoginHandler ())
    self._sm = geasSessionManager.geasSessionManager (self.connections)

  def newSession (self, username, password):
    return Session.LoginSession (self._sm, username, password)

# =============================================================================
# Login Handler
# =============================================================================

class myLoginHandler (GLoginHandler.LoginHandler):
  def getLogin (self, *arguments):
    return {'_username': 'gnue', '_password': None}
