# GNU Enterprise Application Server - Testing unit for Class Repository
#
# Copyright 2003-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: mtest.py 6851 2005-01-03 20:59:28Z jcater $
#
# This testing unit dumps some values of class definitions.
#

# from gnue.appserver import classrep
from gnue.appserver.test import testApp

# -----------------------------------------------------------------------------
# Dump some values of a class definition
# -----------------------------------------------------------------------------
def dumpClass (aName):
  print "\nRequesting class '%s' ..." % aName
  aClass = sm.classes [aName]

  print "Fullname: %s" % aClass.fullName
  print "Id      : %s" % aClass.gnue_id
  print "Module  : %s" % aClass.module.fullName
  print "Comment : %s" % aClass.gnue_comment

  print "\nProperties:"

  for prop in aClass.properties.values ():
    print "Fullname: %s" % prop.fullName
    print "Comment : %s" % prop.gnue_comment
    print "Module  : %s" % prop.gnue_module
    print "Type    : %s" % prop.gnue_type
    print 

  print "End of dump for '%s'\n" % aName

if __name__ == '__main__':
  # First we have to create a session from the language interface
  app = testApp ()
  sm  = app.getSessionManager ()

  # dump some class definitions
  dumpClass ('address_person')
  dumpClass ('gnue_class')

  print "Searching for property 'gnue_name' in class 'gnue_property' ..."
  x = sm.classes ['gnue_property']
  y = x.findProp ('gnue_name')
  print "Fullname: %s" % y.fullName
  print "Module  : %s" % y.gnue_module
  print "Type    : %s" % y.gnue_type
