# GNU Enterprise Application Server - Test Program
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: test.py 5257 2004-03-08 10:06:17Z johannes $

from gnue.common.apps.GClientApp import GClientApp
from gnue.common.apps import i18n
from gnue.common.datasources.GLoginHandler import LoginHandler
from gnue.appserver.geasSessionManager import geasSessionManager

# =============================================================================
# Test application
# =============================================================================

class testApp (GClientApp):

  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------
  def __init__ (self, connections = None):
    ConfigOptions = {}
    GClientApp.__init__ (self, connections, 'appserver', ConfigOptions)


  # ---------------------------------------------------------------------------
  # Create a session manager object
  # ---------------------------------------------------------------------------
  def getSessionManager (self):
    self.connections.setLoginHandler (testLoginHandler ())

    print "Creating session manager ..."
    sm = geasSessionManager (self.connections)

    return sm


  # ---------------------------------------------------------------------------
  # Main program
  # ---------------------------------------------------------------------------
  def run (self):
    sm = self.getSessionManager ()

    print "Opening session ..."
    session = sm.open ({"user":"hacker", "password":"secret"})

    print "Inserting new instance ..."
    sm.store (session, u'nicde_clss', [''], [u'nicde_prperty'],
              [[(u'dt').encode ('utf-8')]])
    sm.commit (session)

    print "Creating and populating list object ..."
    list = sm.request (session, u'nicde_clss', [], [], [u'nicde_prperty'])

    print "Retrieving first instance ..."
    rset = sm.fetch (session,list,0,1)

    print "Value:", o(unicode (rset[0][1], 'utf-8'))

    print "Calling procedure 'prcedure' for the first instance:"
    sm.call (session, u'nicde_clss', [rset[0][0]], u'nicde_prcedure', "")

    print "Creating and populating list object ..."
    list = sm.request (session, u'nicde_clss', [], [], [u'nicde_prperty'])

    print "Retrieving first instance ..."
    rset = sm.fetch (session,list,0,1)

    print "Value:", o(unicode (rset[0][1], 'utf-8'))

    print "Committing ..."
    sm.commit (session)

    print "Deleting the instance ..."
    sm.delete (session, u'nicde_clss', [rset[0][0]])

    print "Committing and closing session ..."
    sm.close (session, 1)


# =============================================================================
# Login Handler
# =============================================================================
class testLoginHandler (LoginHandler):
  def getLogin (self, *arguments):
    return {"_username": "gnue", "_password": None}


# =============================================================================
# Let it rock
# =============================================================================
if __name__ == "__main__":
  testApp().run()
  print "Thank you for playing!"
