#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# CheckBoxGroup.py
#
# DESCRIPTION:
#
# NOTES:
#


import math

from constants import *
from CheckBox import CheckBox
from RadioGroup import RadioGroup

class CheckBoxGroup(RadioGroup):
  def __init__(self,Root,GroupName,Y,X,W,**properties):
    RadioGroup.__init__(self,Root,GroupName,Y,X,W,**properties)
    self._activeState = 0
  
  def _ToggleItem( self, item, v2,v3):
    if item.ACTIVE:
      item.ACTIVE = 0
      self._activeState &= ~(int(math.pow(2,item.ID)))
      item.Paint(0,None,None)
    else:
      item.ACTIVE = 1
      self._activeState |= int(math.pow(2,item.ID))
      item.Paint(1,None,None)

  def AddItem(self,itemId,Caption,X=-1,Y=-1,W=-1):
    posX = X
    posY = Y
    posW = W

    if posW == -1:
      posW = self.W
    if posX == -1:
      posX = self.X
    if posY == -1:
      posY = self.Y+ len(self.buttons) #self.H

    if len(Caption) > posW-3:
      cutoff = len(Caption) - (posW-3 )
      Caption = Caption[:-cutoff]
    button = CheckBox(self.Parent,str(itemId), \
               posY, \
               posX, Caption, itemId)
    button.ACTIVE = 0
    self.Parent.AddControl(button)
    button.SetMethod("CLICK",self._ToggleItem)
    self.buttons.append(button)
    self.H += 1


