#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# GroupBox.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
import sio
from utility import _paintBorder
from Control import Control

class GroupBox(Control):
  def __init__( self, Root, Name, Y,X,W,H, Title='', **properties):
    Control.__init__(self, Root, Name, **properties)
    self.active = 0
    self.Y = Y
    self.X = X
    self.W = W
    self.H = H
    self.CAPTION = Title
    self.CANGETFOCUS = 0
    self.SetColor("DIALOG")
    self.SetMethod("SYSPAINT", self.Paint)

  def Paint(self,v1,v2,v3):
    Y = self._ABSY
    X = self._ABSX
    H = self.H
    W = self.W
    _paintBorder(self, Y, X, H, W, caption = self.CAPTION, color=self.COLOR)



