#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# Label.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from re import search
from string import split
from Control import Control
import sio

class Label(Control):
  """
    An example control.  This class implements a label.  A label is
    nothing more than a string of text on the screen.  It can't get
    update events and the user can't interact with it.
  """

  def __init__(self, Parent, LabelName, Y, X, Caption, Width=0,
    **properties):
    Control.__init__(self, Parent, LabelName, **properties)
    self.PadHeight = 2 # pad the height by this much if multiline
    self.PARENT = Parent
    self.X = X
    self.Y = Y
    self.W = Width

    self.CLASS = "LABEL"
    self.CAPTION = Caption
    self.CANGETFOCUS = 0
    self.SetMethod("SYSPAINT", self.Paint)
    self.SetMethod("SYSGOTFOCUS", None)
    self.SetMethod("SYSLOSTFOCUS", None)

    self.SetColor('LABEL')
    self.SetText(Caption)

  def SetText (self, Caption):
    # for more carefully formatted output
    if self.W == 0:
      self.W = len(Caption)

    # if there are newlines in the Caption: set the height of this
    # label appropriately
    if search( "\n", Caption):

      # "How many single Heights is this?"
      # if the very last character is a newline it is
      # len(mylist) -  1, else, len(mylist)
      # set the height to be two more than the count
      mylist = split( Caption, "\n")
      cnt = len(mylist)
      Caption.rstrip()
      if Caption[ len(Caption) -1] == "\n":
        # "last char is newline.  Send Height: %i" %% %(myht)
        myht = len(mylist) - 1 + self.PadHeight
      else:
        # "last char IS NOT newline"
        # "Send Height: %i" % (myht)
        myht = len(mylist) + self.PadHeight

      self.H = myht

    # otherwise, leave alone
    else:
      self.H = 1

  def Paint(self, v1, v2, v3):
    Container = self.PARENT.Screen()
    if Container == None:
      raise "No container--can't paint!"
    self.LoLight()
    Y = self._ABSY
    X = self._ABSX
    caption = self.CAPTION
    Container.PrintAt(Y,X,caption, self.COLOR)


