#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GDataObjects.py
#
# DESCRIPTION:
# This is a temporary backwards compatability file.
# Should be removed at some point.
#
# NOTES:
#

class Error(gException):
  # Base exception
  pass

class LoginError(Error):
  # Raised when invalid login user/pass was provided
  # Client should attempt to get better information and
  # try again
  pass

class ConnectError(Error):
  # Raised when connection data is invalid (e.g., host not found, etc).
  # Client should probably not attempt to relogin.  Exit gracefully
  # with a reason.
  pass

class ProviderNotSupportedError(Error):
  # Raised when a datasource type is requested that the dbdriver
  # does not support (e.g., not all dbdrivers support raw sql mode.)
  pass

class ObjectTypeNotAvailableError(Error):
  # Raised when a datasource type is requested that the dbdriver
  # does not support (e.g., not all dbdrivers support raw sql mode.)
  pass

class ReadOnlyError(Error):
  # Raised when an attempt is made to update a read-only data object.
  pass

class MasterDetailFieldMismatch(Error):
  # Raised when a the number of master fields doesn't match the
  # number of detail fields. (e.g., masterlink="id,subid"
  # and detaillink="id" would be a problem; must be 1:1)
  pass

class ConnectionError(Error):
  # Generic error reading from the database connection
  pass

class DataTypeNotAvailable(Error):
  # Raised when a datatype is not supported by an database
  # during writing a schema definition to the database
  pass

class NoWriteSchemaSupport(Error):
  # Raised when a database adapter doesn't support
  # writing Schema to datasource
  pass

