#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GConnection.py
#
# DESCRIPTION:
#
# NOTES:
#   Old methods in GDataObjects and their new counterparts:
#     * getSchemaTypes()       -->  types
#     * getSchemaList()        -->  find(type='...')
#     * getSchemaByName()      -->  findone(name='...')
#     * writeSchema()          -->  write()
#
#  Preferred way to access these discovery routines is:
#    connection.schema.<function>
#

import string

import Exceptions

#
# Schema (metadata) functions
#
class Introspection:

  def __init__(self, connection):
    self._connection = connection

  # Return a list of the types of Schema objects this driver provides
  # Contains tuples of (key, description, dataSource??)
  # dataSource?? is true if this schema type can be a datasource
  types = []


  # Return a list of Schema objects
  def find(self, name=None, type=None):
    return []

  def findone(self, *args, **parms):
    f = self.find(*args, **parms)
    try:
      return f[0]
    except IndexError:
      return None

  # write Schema to Database
  def write(self,obj,overwrite=0):
    tmsg = _("This database adapter doesn't have 'schema writing' support")
    raise Exceptions.NoWriteSchemaSupport, tmsg



# Used by the introspection classes
class Schema:
  def __init__(self, attrs={}, getChildSchema=None):
    self.name = ''
    self.type = ''
    self.__dict__.update(attrs)
    if getChildSchema != None:
      self._getChildSchema = getChildSchema

  def __cmp__(self, other):
    if not isinstance(other, Schema):
      return 1
    elif id(other) == id(self):
      return 0
    else:
      return cmp(string.lower(self.name), string.lower(other.name)) or 1

  def fields(self):
    return self._getChildSchema(self)

  # TODO: Last supported in 0.5.2... Delete before 1.0
  def getChildSchema(self, parent):
    print "WARNING: Your application is calling Schema.getChildSchema(parent), which has been deprecated in favor of Schema.fields()"
    return self.fields()

  def _getChildSchema(self, parent):
    return ()






