#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#

#
# Notes on this driver
#
name = _("adodbapi")
url = "http://sourceforge.net/projects/adodbapi"
doc = """
Description
-----------
A Python DB-API 2.0 module that makes it easy to use Microsoft ADO
for connecting with databases and other data sources.

Prerequisites:

  * Mark Hammond's win32all python for windows extensions.


Support
-------
Supported Platforms:

  - MS Windows 98/NT/2000/XP (Installer available)


Connection Properties
----------------------
* oledb_provider   (required)
* data_source      (required)
* initial_catalog  (optional for SQL Server)
* network_library  (optional for SQL Server)
* data_provider    (optional for SQL Server)

You can find more connection strings here:
   http://www.able-consulting.com/MDAC/ADO/Connection/OLEDB_Providers.htm

Examples
--------
  [access]
  comment = """ + _("MS Access database") + """
  provider = adodbapi
  oledb_provider = Microsoft.Jet.OLEDB.4.0
  data_source = C:\mydb.mdb

  [sqlserver]
  comment = """ + _("MS SQL Server database") + """
  provider = adodbapi
  oledb_provider = sqloledb
  data_source = myServerName
  initial_catalog = myDatabaseName

Notes
-----
1. This driver has been partially tested.  If you are successfully using
   this driver, please let us know.
"""
