# GNU Enterprise Datasource Library - Driver for GNUe-AppServer
#
# Copyright 2000-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: ResultSet.py 5628 2004-04-03 23:39:35Z reinhard $

from gnue.common.datasources.drivers import Base

import RecordSet

# =============================================================================
# ResultSet class
# =============================================================================

class ResultSet (Base.ResultSet):
  """
  Handles a resultset (i.e. a list) in the GNUe-AppServer backend.
  """
  # This is actually never used
  _recordSetClass = RecordSet.RecordSet

  # ---------------------------------------------------------------------------
  # Initialization
  # ---------------------------------------------------------------------------

  def __init__ (self, dataObject, sm, session_id, list_id, classname,
                fieldlist, fetchcount, readOnly, masterRecordSet):

    Base.ResultSet.__init__ (self, dataObject,
                             masterRecordSet = masterRecordSet)
    self._readOnly = readOnly

    self.__sm = sm
    self.__session_id = session_id
    self.__list_id = list_id
    self.__classname = classname
    self.__fieldlist = fieldlist
    self.__fetchcount = fetchcount

    if self.__list_id:
      self.__position = 0               # current fetch position in resultset
    else:
      # Empty result set
      self.__position = -1

  # ---------------------------------------------------------------------------
  # Fetch next records
  # ---------------------------------------------------------------------------

  def _loadNextRecord (self):

    if self.__position == -1:
      return False

    records = self.__sm.fetch (self.__session_id,
                               self.__list_id,
                               self.__position,
                               self.__fetchcount)
    if not records:
      self.__position = -1
      return False

    if len (records) < self.__fetchcount:
      self.__position = -1
    else:
      self.__position += len (records)

    for record in records:
      dict = {}
      j = 0
      for fieldName in ['gnue_id'] + self.__fieldlist:
        dict [fieldName] = record [j]
        j += 1

      r = RecordSet.RecordSet (self, self.__sm, self.__session_id,
                               self.__classname, dict)
      self._cachedRecords.append (r)
      self._recordCount += 1

    return True

  # ---------------------------------------------------------------------------
  # Create an empty record
  # ---------------------------------------------------------------------------

  def _createEmptyRecord (self):
    return RecordSet.RecordSet (self, self.__sm, self.__session_id,
                                self.__classname)
