#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# postgresql/Connection.py
#
# DESCRIPTION:
# Postgresql implementation of dbdriver using Python DB-SIG v2
# specification.
#
# NOTES:
#

__all__ = ('Connection')

from gnue.common.datasources import GDataObjects, GConditions, GConnections
from gnue.common.apps import GDebug

try:
  import pgdb
  from _pg import error as PGError   # This is so we can catch login errors
except ImportError:
  raise GConnections.DependencyError, ('pygresql', None)

from gnue.common.datasources.drivers.postgresql import Base

class Connection(Base.Connection):
  _driver = pgdb
  _DatabaseError = pgdb.Error

  def connect(self, connectData={}):
    GDebug.printMesg(1,"Postgresql database driver initializing")
    try:
      self.native = pgdb.connect(user=connectData['_username'],
                   password=connectData['_password'],
                   host=connectData['host'],
                   database=connectData['dbname'])
    except PGError, value:
      raise GDataObjects.LoginError, value
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

    if connectData.has_key ('encoding'):
      encoding = connectData['encoding']
      GDebug.printMesg(1,'Setting postgresql client_encoding to %s' % encoding)
      self.sql ("SET CLIENT_ENCODING TO '%s'" % encoding)
