#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# sapdb/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via MySQL's MaxDB/SAP-DB Python Driver
#
# NOTES:
#
#   Supported attributes (via connections.conf or <database> tag)
#
#     host=      This is the SAP-DB host for your connection (optional)
#     dbname=    This is the SAP-DB database to use (required)
#     timeout=   Command timeout in seconds (optional)
#     isolation= Isolation level (options)
#     sqlmode=   INTERNAL or ORACLE (optional)
#     sqlsubmode= ODBC or empty (optional)
#

__all__ = ['Connection']

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

import string
from string import lower
import sys
from gnue.common.datasources import GDataObjects, GConditions, GConnections
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers import DBSIG2

try:
  import sapdbapi as SIG2api
except ImportError:
  raise GConnections.DependencyError, ('sapdbapi', None)

from gnue.common.datasources.drivers.sapdb.Schema.Discovery.Introspection import Introspection


######################################################################
#
#  GConnection object for PostgreSQL-based drivers
#
class Connection(DBSIG2.Connection):

  driver = SIG2api
  _DatabaseError = SIG2api.DatabaseError
  defaultBehavior = Introspection
  supportedDataObjects = {
    'object': DataObject_Object,
    'sql':    DataObject_SQL
  }

  def connect(self, connectData={}):
    GDebug.printMesg(1,"SAP database driver initializing")
    try:
      options = {'autocommit': 'off'}
      for gnueName, sapdbName in [('sqlmode', 'sqlmode'),
                                  ('timeout', 'timeout'),
                                  ('isolation', 'isolation'),
                                  ('sqlsubmode', 'component')]:
          if connectData.has_key (gnueName):
              options [sapdbName] = connectData [gnueName]
      self.native = apply (SIG2api.connect,
        (connectData['_username'], connectData['_password'],
        connectData['dbname'], connectData.get ('host', '')),
        options)
      #self.native = SIG2api.connect( \
      #             user=connectData['_username'], \
      #             password=connectData['_password'], \
      #             database=connectData['dbname'], \
      #             host=connectData.get ('host', ''), \
      #             autocommit="off")
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value


def createConnection (conn, **overrides):
    from gnue.common.datasources.GConnections import GConnections
    connections = GConnections (r'D:\Python22\etc\connections.conf')
    parameters = connections.getConnectionParameters (conn).copy ()
    dataObject = connections.getDataObject (conn, 'object')
    parameters.update (overrides)
    dataObject.connect (parameters)
    return dataObject

def testConnection ():
    conn, user, pwd = sys.argv [1:4]
    connection = createConnection (conn, _username = user, _password = pwd)
    connection.getSchemaList ()

if __name__ == "__main__":
    testConnection ()
