#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# config/RecordSet.py
#
# DESCRIPTION:
# Implementation of dbdriver for use with configuration files
#
# NOTES and TODO:
#
# @see Connection.py
#

from gnue.common.datasources.drivers.Base.RecordSet import RecordSet
from gnue.common.apps import GDebug


class Configfile_RecordSet(RecordSet):
  
  def _postChanges(self):
    
    # get section
    if hasattr(self,"_initialData") and \
           self._initialData.has_key("_section_name"):      
      section=self._initialData["_section_name"]
    else:
      section=self._fields["_section_name"]

    dataCon=self._parent._dataObject._dataConnection

    # delete
    if self._deleteFlag:
      GDebug.printMesg(5, 'Configfile database driver: Section removed')
      # section should be removed
      dataCon.remove_section(section)      

    # insert
    if self._insertFlag:      
      GDebug.printMesg(5, 'Configfile database driver: new Section '+\
                       'created and inserted')
      
      # check if name already exists
      if section in dataCon.sections():
        tmsg = _("The section name you have provided for this record already exists.") 
        raise Configfile_Error, tmsg

      # check if name is empty
      if len(section)<1:      
        tmsg = _("You have to provide a section name for this record!")
        raise Configfile_Error, tmsg
      
      dataCon.add_section(section)
      

    # modify/update 
    if not self._deleteFlag:
      if "_section_name" in self._modifiedFlags.keys() and \
             self._fields["_section_name"]!=section:
        
        # Section name has changed. Copy whole section to new name"
        newsection=self._fields["_section_name"]
        
        # check if name already exists
        if newsection in dataCon.sections():
          tmsg = _("The section name you have provided for this record already exists.")
          raise Configfile_Error, tmsg 
        
        # check if name is empty
        
        if len(newsection)<1:      
          tmsg = _("You have to provide a section name for this record!")
          raise Configfile_Error, tmsg
        
        # add new section
        dataCon.add_section(newsection)

        # copy values
        for option in dataCon.options(section):
          dataCon.set(newsection,option,dataCon.get(section,option))

        # remove old section
        dataCon.remove_section(section)

        # renaming
        section=newsection
        self._initialData["_section_name"]=newsection
         

      for field in (self._modifiedFlags.keys()):      
        if (field!="_section_name"):
          if self._fields[field]!="":
            dataCon.set(section,field,self._fields[field])
          else:
            dataCon.remove_option(section,field)
              
    self._updateFlag = 0
    self._insertFlag = 0
    self._deleteFlag = 0
      
