#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# Introspection.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['Introspection']

import string
from string import lower, join, split
import sys

from gnue.common.apps import GDebug, GConfig
from gnue.common.apps import GDebug, GConfig
from gnue.common.datasources import GIntrospection

class Introspection(GIntrospection.Introspection):

  # list of the types of Schema objects this driver provides
  types =[ ('view',_('Views'),1),
           ('table',_('Tables'),1) ]

  #
  # TODO: This is a quick hack to get this class
  # TODO: into the new-style schema format.
  # TODO: getSchema* should be merged into find()
  #
  def find(self, name=None, type=None):
    if name is None:
      return self.getSchemaList(type)
    else:
      rs = self.getSchemaByName(name, type)
      if rs:
        return [rs]
      else:
        return None


  # TODO: Merge into find()
  # Return a list of Schema objects
  def getSchemaList(self, type=None):

    if type!=None:
      where=" WHERE type='%s'" % type
    else:
      where=""

    statement = "SELECT type,name,tbl_name,sql FROM master "+\
                where+" UNION ALL "+\
                "SELECT type,name,tbl_name,sql FROM temp_master "+\
                where+" ORDER BY name;"

    cursor = self._connection.native.cursor()
    GDebug.printMesg(1,"** Executing: %s **" % statement)
    cursor.execute(statement)

    list = []
    for rs in cursor.fetchall():
      if rs[0] in ('table','view'):
        list.append(GIntrospection.Schema(attrs={'id':rs[1], 'name':rs[1], \
                                               'type':rs[0],},
                                        getChildSchema=self.__getFieldSchema))

    cursor.close()
    print list
    return list


  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):

    if type!=None:
      where=" AND type='%s'" % type
    else:
      where=""

    statement = ("SELECT type,name,tbl_name,sql FROM master "+\
                 "WHERE name='%s'"+where+" UNION ALL "+\
                 "SELECT type,name,tbl_name,sql FROM temp_master "+\
                 "WHERE name='%s' "+where+" ORDER BY name;") % (name,name)

    cursor = self._connection.native.cursor()
    GDebug.printMesg(1,"** Executing: %s **" % statement)
    cursor.execute(statement)

    rs = cursor.fetchone()
    if rs and rs[0] in ('table','view'):
      schema = GIntrospection.Schema(attrs={'id':rs[1], 'name':rs[1], \
                                          'type':rs[0],},
                                   getChildSchema=self.__getFieldSchema)
    else:
      schema = None

    cursor.close()
    return schema


  # Get fields for a table
  def __getFieldSchema(self, parent):

    if parent.type=='view':
      print "Views are not supported at the moment"
      return None

    statement = ("SELECT type,name,tbl_name,sql FROM master "+\
                 "WHERE type='%s' and name='%s' UNION ALL "+\
                 "SELECT type,name,tbl_name,sql FROM temp_master "+\
                 "WHERE type='%s' "+\
                 "and name='%s' ORDER BY name;") % (parent.type,parent.id,\
                                                    parent.type,parent.id)

    cursor = self._connection.native.cursor()
    GDebug.printMesg(1,"** Executing: %s **" % statement)
    cursor.execute(statement)
    columns = cursor.description

    # Because sqlite don't store column definitions, but computes it
    # every time anew from the 'create table' statement, we have to
    # parse that statement to get the data

    # get sql definition of table
    rs = cursor.fetchone()
    cursor.close()
    if rs:
      sql=rs[3]
    else:
      return None

    # parse the sql definition
    GDebug.printMesg(3,"** Table definition: %s **" % sql)

    sql=sql[find(sql,'(')+1:rfind(sql,')')]
    fields = split(sql,',')
    list = []
    for field in fields:

      fls=split(strip(field),' ',2)

      if not fls[0] in ('Constraint','Primary'):
        
        try:
          nativetype= fls[1][:find(fls[1],'(')]

          size=int(fls[1][find(fls[1],'(')+1:-1])
        except:
          nativetype = fls[1]
          size=None
        
        attrs={'id': "%s.%s" % (parent.id, fls[0]), 'name': fls[0],
               'type':'field', 'nativetype': nativetype,
               'required':fls[2]=="NOT NULL"}
        
        if size!=None:
          attrs['length'] = size
        
        if nativetype in ('int','integer','bigint','mediumint',
                           'smallint','tinyint','float','real',
                           'double','decimal'):
          attrs['datatype']='number'
        elif nativetype[0] in ('date','time','timestamp','datetime'):
          attrs['datatype']='date'
        else:
          attrs['datatype']='text'

        list.append(GIntrospection.Schema(attrs=attrs))

    return list

