#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# Objects.py
#
# DESCRIPTION:
# Helper classes used by the parser.
#
# NOTES:
#

from gnue.common.definitions.GObjects import GObj

# Top-level object
class GnuRpc (GObj):
  def __init__(self, parent=None):
    GObj.__init__(self, parent, type="RpGnuRpc")


# service object
class RpcService (GObj):
  def __init__(self, parent=None):
    GObj.__init__(self, parent, type="RpService")


# method object
class RpcMethod (GObj):
  def __init__(self, parent=None):
    GObj.__init__(self, parent, type="RpMethod")
    self._arguments = []


# argument object
class RpcArgument (GObj):
  def __init__(self, parent=None):
    GObj.__init__(self, parent, type="RpArgument")
    parent._arguments.append(self)


# attribute object
class RpcAttribute (GObj):
  def __init__(self, parent=None):
    GObj.__init__(self, parent, type="RpAttribute")


# object object (hehe)
class RpcObject (GObj):
  def __init__(self, parent=None):
    GObj.__init__(self, parent, type="RpObject")


# exception object
class RpcException (GObj):
  def __init__(self, parent=None):
    GObj.__init__(self, parent, type="RpException")


# exception declaration object
class RpcRaises (GObj):
  def __init__(self, parent=None):
    GObj.__init__(self, parent, type="RpException")



