# Usage: python setup.py py2exe -c
# or python setup.py py2exe -c -k
# for console apps.

from distutils.core import setup
import py2exe 
import sys

# The manifest will be inserted as resource into .exe files.  This
# gives the controls the Windows XP appearance (if run on XP).
manifest = '''
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<assembly xmlns="urn:schemas-microsoft-com:asm.v1" manifestVersion="1.0">
<assemblyIdentity
    version="5.0.0.0"
    processorArchitecture="x86"
    name="Controls"
    type="win32"
/>
<description>GNU Enterprise</description>
<dependency>
    <dependentAssembly>
        <assemblyIdentity
            type="win32"
            name="Microsoft.Windows.Common-Controls"
            version="6.0.0.0"
            processorArchitecture="X86"
            publicKeyToken="6595b64144ccf1df"
            language="*"
        />
    </dependentAssembly>
</dependency>
</assembly>
'''

RT_MANIFEST = 24


scripts = \
  ["gnue-appserver",
   {"script" : "gnue-navigator", "other_resources" : [(RT_MANIFEST, 1, manifest)]},
   {"script" : "gnue-designer",  "other_resources" : [(RT_MANIFEST, 1, manifest)]},
   {"script" : "gnue-forms",     "other_resources" : [(RT_MANIFEST, 1, manifest)]},
   "gnue-gsdgen",
   "gnue-readgcd",
   "gnue-readgld",
   "gnue-reports",
   "gnue-reports-server",
   "gnue-schema"]

console = []
windows = scripts

# If run with arg "-k", build console apps.
if len(sys.argv) == 4:
  if sys.argv[3] == "-k":
    print 'Building console apps.'
    console = scripts
    windows = []
  del sys.argv[3]

setup ( \
console = console,
windows = windows,
options = {"py2exe": {"typelibs": [('{EAB22AC0-30C1-11CF-A7EB-0000C05BAE0B}',0,1,1)],
                                  #'Microsoft Internet Controls'
                      "packages": ["encodings",
                                   "wx",
                                   "mx",
                                   "adodbapi",
                                   "kinterbasdb",
                                   "sapdb",
                                   "MySQLdb",
                                   "sqlite",
                                   "pysqlite2",
                                   "reportlab",
                                   "Pil"],
                      "includes": ["win32gui",
                                   "win32ui",
                                   "win32api",
                                   "win32con",
                                   "afxres",
                                   "commctrl",
                                   "win32clipboard",
                                   "win32print",
                                   "win32com.client",
                                   "pywin.mfc.activex",
                                   "pywin.mfc.window",
                                   "csv",
                                   "dbi",
                                   "odbc",
                                   "pysqlite2.dbapi2",
                                   "pyPgSQL.PgSQL",
                                   "psycopg",
                                   "dircache",
                                   "netrc",
                                   "struct",
                                   "textwrap",
                                   "BaseHTTPServer",
                                   "SimpleHTTPServer",
                                   "SocketServer",
                                   "xmlrpclib",
                                   "ConfigParser",
                                   "libxml2",
                                   "libxslt",
                                   "Image",
                                   "ImageWin",
                                   "BmpImagePlugin",
                                   "GifImagePlugin",
                                   "JpegImagePlugin",
                                   "PpmImagePlugin",
                                   "PngImagePlugin",
                                   "TiffImagePlugin",
                                   "wxPython.wx",
                                   "wxPython.grid"],
                      "dll_excludes": ["msvcp60.dll",
                                       "tcl84.dll",
                                       "tk84.dll",
                                       "oci.dll"],
                      "excludes": ["gnue"]}}) 
