#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# ColorScheme.py
#
# DESCRIPTION:
#
# NOTES:
#

import curses, sys



class ColorScheme:
  def loadColors(self, text):
    # temp
    #import sio
    #


    pair = 2
    self._cache = {}
    for raw in text.upper().split(';'):
      attr, raw2 = raw.split('=')
      try:
        fgcolor, bgcolor = raw2.split(',')
      except:
        fgcolor = raw2
        bgcolor = None

      fgcols = fgcolor.split('-')
      if fgcols[0] in ('BLINK','BOLD','DIM','REVERSE','STANDOUT','UNDERLINE'):
        mod = curses.__dict__['A_%s' % fgcols[0]]
        fgcols.pop(0)
      elif fgcols[0] == 'NONE':
        mod = 0
        fgcols.pop(0)
      else:
        mod = 0

      if fgcols:
        fg = curses.__dict__['COLOR_%s' % fgcols[0]]

      if bgcolor != None:
        bg = curses.__dict__['COLOR_%s' % bgcolor]
        try:
          pr = self._cache[(fg,bg)]
          pair -= 1
        except KeyError:
          curses.init_pair(pair,fg, bg)
          pr = pair
          self._cache[(fg,bg)] = pair
        v = curses.color_pair(pair)

        # Temp
        ##exec 'sio.C_%s = %s' % (attr,pr) in locals()
        #

      else:
        pr = None
        v = 0

      self.__dict__['CP_%s'%attr] = (mod, pr)
      self.__dict__['C_%s'%attr] = v | mod
      assert gDebug(5,'C_%s = %s' % (attr, v|mod))

      pair += 1


class Monochrome (ColorScheme):
  def __init__(self):
    self.loadColors (
        'BACKGROUND=NONE;'+
        'TITLEBAR=REVERSE;'
        'MENUBAR=REVERSE;'
        'MENUBAR_FOCUS=BOLD;'
        'LABEL=NONE;'
        'DIALOG=NONE;'
        'DIALOG_TITLE=REVERSE;'
        'TEXTBOX_FOCUS=REVERSE;'
        'TEXTBOX=BOLD;'
        'BUTTON=BOLD;'
        'BUTTON_FOCUS=REVERSE;'
        'SCROLL_BUTTON=REVERSE;'
        'SCROLL_BUTTON_FOCUS=BOLD;'
        'SCROLL_BACKGROUND=DIM;'
        'SCROLL_SLIDER=REVERSE;'
        'SCROLL_SLIDER_FOCUS=BOLD;'
        'STATUSBAR=REVERSE;'
        'STATUSBAR_FIELD=REVERSE;'
        'DROPSHADOW=REVERSE' )

class Safe (ColorScheme):
  def __init__(self):
    self.loadColors (
        'BACKGROUND=NONE;'
        'TITLEBAR=NONE;'
        'MENUBAR=NONE;'
        'MENUBAR_FOCUS=BOLD;'
        'LABEL=NONE;'
        'DIALOG=NONE;'
        'DIALOG_TITLE=NONE;'
        'TEXTBOX_FOCUS=UNDERLINE;'
        'TEXTBOX=NONE;'
        'BUTTON=NONE;'
        'BUTTON_FOCUS=NONE;'
        'SCROLL_BUTTON=NONE;'
        'SCROLL_BUTTON_FOCUS=NONE;'
        'SCROLL_BACKGROUND=NONE;'
        'SCROLL_SLIDER=NONE;'
        'SCROLL_SLIDER_FOCUS=NONE;'
        'STATUSBAR=NONE;'
        'STATUSBAR_FIELD=NONE;'
        'DROPSHADOW=NONE' )


class StandardWhiteOnBlue(ColorScheme):
  def __init__(self):
    self.loadColors (
        'BACKGROUND=WHITE,BLUE;'
        'TITLEBAR=WHITE,BLUE;'
        'TEXTBOX_FOCUS=BLACK,CYAN;'
        'TEXTBOX=BLUE,WHITE;'
        'MENUBAR=BLACK,WHITE;'
        'MENUBAR_FOCUS=BLUE,WHITE;'
        'LABEL=BLACK,WHITE;'
        'STATUSBAR=BLACK,WHITE;'
        'STATUSBAR_FIELD=BLACK,WHITE;'
        'DIALOG=BLACK,WHITE;'
        'DIALOG_TITLE=BLACK,WHITE;'
        'BUTTON=BLUE,WHITE;'
        'BUTTON_FOCUS=WHITE,CYAN;'
        'SCROLL_BUTTON=BLACK,WHITE;'
        'SCROLL_BUTTON_FOCUS=CYAN,WHITE;'
        'SCROLL_BACKGROUND=BLUE,WHITE;'
        'SCROLL_SLIDER=WHITE,BLUE;'
        'SCROLL_SLIDER_FOCUS=BLACK,CYAN;'
        'DROPSHADOW=WHITE,BLACK' )


class WhiteOnRed(ColorScheme):
  def __init__(self):
    self.loadColors (
        'BACKGROUND=RED,WHITE;'
        'TITLEBAR=WHITE,RED;'
        'MENUBAR=BOLD-YELLOW,RED;'
        'MENUBAR_FOCUS=RED,WHITE;'
        'LABEL=WHITE,RED;'
        'DIALOG=BLACK,RED;'
        'DIALOG_TITLE=YELLOW,RED;'
        'TEXTBOX_FOCUS=BLACK,CYAN;'
        'TEXTBOX=RED,WHITE;'
        'BUTTON=RED,WHITE;'
        'BUTTON_FOCUS=WHITE,CYAN;'
        'SCROLL_BUTTON=BLACK,WHITE;'
        'SCROLL_BUTTON_FOCUS=CYAN,WHITE;'
        'SCROLL_BACKGROUND=RED,WHITE;'
        'SCROLL_SLIDER=WHITE,RED;'
        'SCROLL_SLIDER_FOCUS=BLACK,CYAN;'
        'STATUSBAR=RED,WHITE;'
        'STATUSBAR_FIELD=RED,WHITE;'
        'DROPSHADOW=WHITE,WHITE' )




#def test(scr):
#StandardWhiteOnBlue()
##WhiteOnRed()
#curses.wrapper(test)
