#
# Copyright 2001-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can` redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# ModuleSupport.py
#
# DESCRIPTION:
#
# NOTES:
#


from gnue.common.apps import GDebug as _GDebug
from gnue.common.utils.FileUtils import dyn_import

SupportedModules = []
UnsupportedModules = []
Modules = (  'forms',
           'reports',
##           'navigator',
           'schema'
)

for module in Modules:
  try:
    SupportedModules.append(dyn_import("gnue.designer.%s" % module))
    _GDebug.printMesg(1,'Loaded Designer support for %s' % module)
  except ImportError, mesg:
    UnsupportedModules.append(module)
    _GDebug.printMesg(1,'Cannot load Designer support for %s' % module)
    _GDebug.printMesg(2,'  Error: %s' % mesg)

