#
# Copyright 2001-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# Debugger.py
#
# DESCRIPTION:
#
# NOTES:

import sys, os
from wxPython.wx import *
from gnue.common.apps import GDebug
from gnue.common.apps.GClientApp import GClientApp
from gnue.forms import GFForm, GFInstance, GFParser
from StringIO import StringIO
from gnue.forms.uidrivers.wx import UIdriver as UIwxpython
    

class DebugSession: 
  def __init__(self, caller): 
    self.caller = caller
    outputWindow = wxFrame(caller, -1, _("Console Output"), 
         size=wxSize(300,50))
    outputWindow.text = wxTextCtrl(outputWindow, -1, style=wxTE_MULTILINE)
    outputWindow.Show(true)
    caller.outputWindow = outputWindow

    self.stdoutcatcher = _stdoutcatcher(outputWindow.text)
    self.stderrcatcher = _stderrcatcher(outputWindow.text)

    try: 
      self._saveexit = sys.exit
      sys.exit = self.debugClosing
      
#      debugInstance = DebugInstance(caller._app)
      debugInstance = GFInstance.GFInstance(caller._app,connections=caller._app.connections,
                 ui=DummyInterfaceModule,disableSplash=1)
      debugInstance.addDialogs()
      debugInstance.addFormFromBuffer(caller.rootObject.dumpXML(treeDump=1))
          
      #debugInstance.setForm(GFParser.loadFile(StringIO(caller.rootObject.dumpXML(treeDump=1)), debugInstance))
      debugInstance.activate()
      debugInstance._ui._debuginstance = self
    except: 
      self.sanityCheck()
      raise
      self.outputWindow.text.AppendText(_('\n---- Form Closed Abruptly ----'))

  def debugClosing(self): 
    self.sanityCheck()
    self.outputWindow.text.AppendText(_('\n---- Form Closed ----'))

  def sanityCheck(self): 
    self.stdoutcatcher.restore()
    self.stderrcatcher.restore()
    sys.exit = self._saveexit

class DebugUserInterface(UIwxpython.GFUserInterface): 
  def closeTrap (self, event): 
    UIwxpython.GFUserInterface.closeTrap(self, event)
    eo = event.GetEventObject()
    object = wxPyTypeCast(eo, 'GFDInstance')
    object._debuginstance.debugClosing()

# Ack!!! 
class DummyInterfaceModule:     
  GFUserInterface = DebugUserInterface

#class DebugInstance(GFInstance.GFInstance): 
#  def __init__(self, manager, connections=None, ui=DummyInterfaceModule, disableSplash=1,
#               parameters={}):
#    GFInstance.GFInstance.__init__(self,connections=manager.connections,
#                                   ui=ui, disableSplash=disableSplash)
#
#                                   app, -1, app.connections, 
#                          DummyInterfaceModule,1)
    
    

class _stdoutcatcher:
  def __init__(self, textctrl): 
    self.orig = sys.__stdout__
    self.textctl = textctrl
    sys.__stdout__ = self
        
  def write(self, str):
    self.orig.write(str)
    self.textctl.AppendText(str)

  def writelines(self, list):
    for line in list:
      self.write(str)

  def restore(self): 
    self.__stdout__ = self.orig


class _stderrcatcher:
  def __init__(self, textctrl): 
    self.orig = sys.__stderr__
    self.origfh = GDebug._fh
    self.textctl = textctrl
    sys.__stderr__ = self
    GDebug._fh = self
        
  def write(self, str):
    self.origfh.write(str)
    self.textctl.AppendText(str)

  def writelines(self, list):
    for line in list:
      self.write(str)

  def restore(self): 
    self.__stderr__ = self.orig
    GDebug._fh = self.origfh


