#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# forms/wizards/AddBlock.py
#
# DESCRIPTION:
# Implements a basic form template
#
# NOTES:
#

from gnue.designer.forms.TemplateSupport import *
from gnue.designer import VERSION
import string


class AddBlockWizard(FormTemplate):

  # The first step in our wizard.
  # The template parser will initially
  # call GetStep(FIRST_STEP).
  FIRST_STEP = '0'


  ###############
  #
  # Initialize any runtime variables
  #
  def Start(self, root, current):
    self.form = root
    self.current = current
    self.variables['rows'] = '1'

    self.__getExistingDatasources()


  ###############
  #
  # Return the markup for a specific page
  #
  def GetStep(self, stepCode):

    if stepCode == '1':
      if self.variables['datasource'] == 0:
        stepCode = '1:new'
      elif self.variables['datasource'] == 1:
        stepCode = '1:reuse'
      else:
        stepCode = '1:none'

    #
    # Step #0 / Get Name
    #
    if stepCode == '0':

      if self.__firstConnection:
        self.variables['connection'] = self.__firstConnection

      if len (self.__datasourceMap):
          set=((0,_('Create a new datasource')),
               (1,_('Use an existing datasource')),
               (2,_('Create an unbound block (no datasource)') )
               )
      else:
          set=((0,_('Create a new datasource')),
               (2,_('Create an unbound block (no datasource)') )
               )

      content = [WizardText(_('This will insert a new block.')),
                 WizardInput('name',label=_('Object Name:'),required=1,size=20),
                 WizardText(_('Where will this block pull its data?')),
                 WizardInput('datasource', label=_('Source:'), required=1,
                                         maxSelections=1,
                                         set=set),
                 WizardText(_('How many rows should this block display at once?')),
                 WizardInput('rows', label=_('Rows Displayed:'), required=1,
                                typecast=whole
                             ) ]

      return   { 'title': _('Add Block'),
                 'content': content,
                 'prev': None,
                 'next': '1' }

    #
    # Step #2 [New Datasource] / Get Connection
    #
    elif stepCode == '1:new':
      return   { 'title': _('DataSource Connection'),
                 'content': (WizardText('What connection should this form use to connect to the \ndatabase?'),
                             WizardInput('connection',label='Connection:', required=1,
                                         set=self.GetAvailableConnections()),
                             WizardText('You may be asked to login to this connection.')),
                 'prev': '0',
                 'next': '2:new' }
    
    #
    # Step #3 [New Datasource] / Get Table
    #
    elif stepCode == '2:new':
      return   { 'title': 'Select Base Table/Source',
                 'content': (WizardText('Now, please select the table the dropdown will\nuse to populate its data set.'),
                             WizardInput('table', label='Table:', required=1, lines=5,
                                         set=self.GetAvailableSources(self.variables['connection'])), ),
                 'prev': '1:new',
                 'next': None }


    #
    # Step #2 [reuse Datasource] / Get DataSource
    #
    elif stepCode == '1:reuse':
      return   { 'title': 'Datasource Connection',
                 'content': (WizardText('Which existing datasource should be used?'),
                             WizardInput('source',label='Datasource:', required=1,
                                         set=self.__getExistingDatasources())),
                 'prev': '0',
                 'next': None }

    #
    # Step #2 [no DAtasource]
    #
    elif stepCode == '1:none':
      return   { 'title': _('Done'),
                 'content': (WizardText('We now have enough information to create your block.'),),
                 'prev': '0',
                 'next': None }

  ###############
  #
  # We have all the data, so generate our widget.
  #
  def Finalize(self):

    attrs = {'name': self.GetUniqueName(self.variables['name'] or 'Block1'),
             'rows': int(self.variables['rows'])}
    # Find form...
    logic = self.current['logic']



    #
    # Set up or retrieve our datasource
    #

    # Create new datasource
    if self.variables['datasource'] == 0:
      datasource = self.AddElement('datasource', self.form,
        { 'name': self.GetUniqueName("dts_%s_%s" % (self.variables['table'],
                                     self.variables['name'])),
          'connection': self.variables['connection'],
          'prequery': 1,
          'table': self.variables['table'] } )
      attrs['datasource'] = datasource.name

    # Reuse existing datasource
    elif self.variables['datasource'] == 1:
      datasource = self.__datasourceMap[self.variables['source']]
      attrs['source'] = datasource.name

    # Create a "static" datasource
    else:
      datasource = None


    block = self.AddElement('block', logic, attrs)

    return 1



  ###############
  #
  # Internal stuff
  # Get a list of all existing datasources
  #
  def __getExistingDatasources(self):
    self.__firstConnection = None
    self.__datasourceSet = []
    self.__datasourceMap = {}
    for child in self.form.findChildrenOfType('GFDataSource'):
      if hasattr(child,'table'):
        self.__datasourceSet.append((child.name,"%s (%s)" % (child.name, child.table)))
        self.__datasourceMap[child.name] = child
        if not self.__firstConnection:
          self.__firstConnection = child.connection
    return self.__datasourceSet



############
#
# Basic information about this template
#
TemplateInformation = {
    'Product': 'forms',
    'BaseID' : 'AddBlock',
    'BaseClass' : AddBlockWizard,
    'Name' : 'Add Block',
    'Description' : 'Inserts a Block',
    'Version' : VERSION,
    'Author' : 'The GNUe Designer Team',
    'Behavior': WIZARD,
    'MenuLocation' : ('Insert',_('Block'), 301.1)
}

