#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# reports/TreeView.py
#
# DESCRIPTION:
#
# NOTES:
#
# TODO: all the SetItemImage lines in this file have been commented out as on win32 it was segfaulting

import sys, os
from wxPython.wx import *
from gnue.common.apps import GDebug
from gnue.reports.base import GRReport, GRSources, GRParameters, GRSortOptions
from gnue.reports.base import layout as GRLayout
from gnue.designer.base.PopupMenu import ObjectMenu
from gnue.designer.base.Icons import treeIconMap, treeIconList
from gnue.designer.base.tools.TreeView import TreeView as BaseTreeView

class TreeView (BaseTreeView):

  rootDescr = 'Report'

  def inventoryObject (self, object):
    if object != self.rootObject:
      # TODO: icons for reports wanted (btami)
      icon = 'properties'
      parentTreeItem = object._parent._treeItem
      if isinstance(object, GRParameters.GRParameters):
        icon = 'properties'
      elif isinstance(object, GRSortOptions.GRSortOptions):
        icon = 'properties'
      elif isinstance(object, GRSources.GRSources):
        icon = 'datasource'
      elif isinstance(object, GRLayout.GRLayout):
        icon = 'page'
      elif object._type == 'GRSsection':
        icon = 'block'
      elif object._type == 'GRSumm':
        icon = 'entry'
      elif object._type == 'GRFiled':
        icon = 'entry'

      object._treeItem = self.AppendItem(parentTreeItem,
          "%s" % object.getDescription())
      self.tree.SetPyData(object._treeItem, object)
      self.tree.SetItemImage(object._treeItem, treeIconMap[icon])


