#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# ToolFrame.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['FloatingPane']

import os, sys, string
from gnue.common.apps import RuntimeSettings
from wxPython.wx import *
from gnue.common.apps import GDebug
from BasePane import BasePane
from gnue.designer.base.ToolBar import BaseToolBar, getIcon
from gnue.designer.base import Goat

#
# Any tool frames inherit from this
# It handles the Window menu and
# saving size/position/display settings
#
class FloatingPane (wxFrame, BasePane):

  default_width = 300
  default_height = 200

  def __init__(self, parent, instance, tool):
    style = wxMINIMIZE_BOX|wxRESIZE_BORDER|wxCAPTION|wxFRAME_NO_TASKBAR|wxFRAME_FLOAT_ON_PARENT

    wxFrame.__init__(self, instance, -1, tool.title, style=style)
    BasePane.__init__(self, parent, instance, tool)

    icon = Goat.getGoatIcon()
    self.SetIcon(icon)

    if tool.uses_feedback_bar:
      self.statusbar = self.CreateStatusBar()

    if tool.uses_toolbar:
      toolbar = tool.createToolbar(self)
      self.SetToolBar(toolbar)
    else:
      toolbar = self.CreateToolBar()
      toolbar.SetToolBitmapSize(wxSize(24,24))
      toolbar.ICON_SIZE = (24,24)

    toolbar.InsertSeparator(0)
    wid = wxNewId()
    toolbar.InsertTool(0, wid, getIcon("tb_dock", *toolbar.ICON_SIZE))
    toolbar.Realize()

    EVT_MENU(self, wid, self.__redock)
    EVT_CLOSE(self, self.OnClose)
    self.Refresh()

    self.SetPosition((tool._frame_x, tool._frame_y))
    self.SetSize((tool._frame_width, tool._frame_height))


##    instance.registerEventListeners(
##               { 'Show:Tool:%s' % self.id : self.show,
##                 'Hide:Tool:%s' % self.id : self.hide } )


  def saveRuntimeSettings(self):
    x, y = self.GetPositionTuple()
    width, height = self.GetSizeTuple()
    return ( self.runtime_section,
             {'x': x,
              'y': y,
              'height': height,
              'width': width,  } )


  def show(self):
    self.Show(1)

  def hide(self):
    self.Show(0)

  def OnClose(self, event):
    self.instance.dispatchEvent('Hide:Tool:%s' % self.tool.id)
    event.Veto()

  def __redock(self, event):
    self.instance.dispatchEvent('Docker:Dock', tool=self.tool)

  def closing(self):
    self.tool._frame_x, self.tool._frame_y = self.GetPositionTuple()
    self.tool._frame_width, self.tool._frame_height = self.GetSizeTuple()
