#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# MenuBar.py
#
# DESCRIPTION:
#
# NOTES:

import sys, os, string
from gnue.common.apps import GDebug
import MRUManager
from ModuleSupport import SupportedModules

#
#
#

class MenuBar:
  def __init__(self, instance):
    self.instance = instance

    self._menus = {}
    self._menuItems = {'':[]}

    print instance
    self.uimenu = instance.uiinstance.createMenuBar()


  # Locations can be <loc>|<loc> where <loc> is <location>/<translation>@group
  def addMenu(self, location, translation=None, grouping=499):

    loc = ''
    if translation:
      location += '/' + translation
    if grouping:
      location += '@' + str(grouping)

    for part in location.split('|'):
      try:
        part, group = part.split('@')
        group = float(group)
      except:
        group = 500.0
      try:
        part, trans = part.split('/')
      except:
        trans = part
      nloc = loc + part + '|'
      if not self._menuItems.has_key(nloc):
        self._menuItems[nloc] = []
        self._menuItems[loc].append((int(grouping),grouping, trans, 1, nloc,
                                     0, 0, None, None, None, None))
      loc = nloc
    return loc


  def addAction(self, location, text, event,
                      grouping=499, canToggle=0, canDisable=0,
                      icon=None, hotkey=None, eventdata={}, help=""):

    location = self.addMenu(location)
    self._menuItems[location].append((int(grouping), grouping, text, 0, event,
                                 canToggle, canDisable, icon, hotkey,
                                 eventdata, help))



  #
  # Called by Instance.py when the menu can finally be built
  #
  def finalize(self):
    for group, order, text, isMenu, action, canToggle, canDisable, \
        icon, hotkey, eventdata, help in self._menuItems['']:
      self.__setupMenu(None, action, text)


  #
  # Recursively build (sub)menus
  #
  def __setupMenu(self, parent, location, text):
    items = self._menuItems[location]

    # Don't add empty menus (???)
    if not items:
      return

    if parent:
      menu = self.uimenu.createSubMenu(text, location, parent)
    else:
      menu = self.uimenu.createMenu(text, location)

    items.sort()
    lastgroup = items[0][0]

    for group, order, text, isMenu, action, canToggle, canDisable, \
        icon, hotkey, eventdata, help in self._menuItems[location]:
      if group != lastgroup:
        self.uimenu.createSeparator(menu)
        lastgroup = group

      if isMenu:
        self.__setupMenu(menu, action, text)
      else:
        self.uimenu.createMenuItem(menu, text, canToggle, canDisable, icon, hotkey, eventdata, help, action)


  def getEventHelp(self, handle):
    """
    Return the help string of a menu event,
    so that it could be used for toolbar icon tooltips too.
    (Two to two too...)
    """
    try:
      for menuItems in self._menuItems.values():
        for group, order, text, isMenu, action, canToggle, canDisable, \
          icon, hotkey, eventdata, help in menuItems:
          if action == handle:
            return (text, help)
    except:
      pass

    return None

  #
  # Return the wxMenu(Item) associated with a location
  def getMenu(self, location):
    return self.uimenu.getMenu(location)


