#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# wx/MenuBar.py
#
# DESCRIPTION:
"""
MenuBar class for wxWidgets
"""
# NOTES:
#

from wxPython.wx import *

class MenuBar(wxMenuBar):
  def __init__(self, instance):
    wxMenuBar.__init__(self)
    self.instance = instance

    self._locationToWx= {}

  #
  # Return the wxMenu(Item) associated with a location
  def getMenu(self, location):
    return self._locationToWx[location]


  def createMenu(self, title, location):
    return self.createSubMenu(title, location, self)

  def createSubMenu(self, title, location, parent):
    menu = wxMenu()
    self._locationToWx[location] = menu
    parent.AppendMenu(wxNewId(), title, menu)
    return menu

  def createSeparator(self, menu):
    menu.AppendSeparator()

  def createMenuItem(self, menu, text, canToggle,
      canDisable, icon, hotkey, eventdata, help, action):

    mid = wxNewId()
    if hotkey:
      text += '\t' + hotkey
    item = wxMenuItem(menu, mid, text, help,
              (canToggle and [wxITEM_CHECK] or [wxITEM_NORMAL])[0])
    if canToggle:
      EVT_MENU(self.instance.base.ui, mid,
        lambda event, l=self.instance, m=item, e=action, x=eventdata:
              l.dispatchEvent('%s:%s' % (m.IsChecked() and 'Show' or 'Hide',e), **x))
      self.instance.registerEventListeners( {
                'Show:%s' % action:  lambda event, m=item: m.Check(1),
                'Hide:%s' % action: lambda event, m=item: m.Check(0) })
    else:
      EVT_MENU(self.instance.base.ui, mid,
        lambda event, l=self.instance, e=action, x=eventdata: l.dispatchEvent(e, **x))

    if canDisable:
      self.instance.registerEventListeners( {
                'Enable:%s' % action:  lambda event, m=item: m.Enable(1),
                'Disable:%s' % action: lambda event, m=item: m.Enable(0) })
    menu.AppendItem(item)
    return item


  #
  # Convenience methods to make the main menu bar appear to be a menu container
  #
  def AppendMenu(self, wxId, text, menu):
    self.Append(menu, text)



