
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# GFDisplayHandler.py
#
# $Id$
"""
DisplayHandler classes for Forms input validation
"""
__revision__ = "$Id$"

import types

from gnue.forms.input.displayHandlers.Cursor import BaseCursor

class Numeric(BaseCursor):
  """
  Class to handle the display and entry of numeric fields.
  """
  def __init__(self, entry, eventHandler, subEventHandler, displayMask,
               inputMask):
    BaseCursor.__init__(self, entry, eventHandler, subEventHandler)

  def setValue(self, value):
    if value in (None, ""):
      value = None
    else:
      value = value

    return BaseCursor.setValue(self, value)


  # TODO: Replace with format mask
  def _buildDisplayHelper(self, val, editing):
    try:
      if val in (None, ""):
        return ""
    except TypeError:
      pass

    if editing and type(val) == types.StringType:
      return val

#     if float(val) == val:
#    try:
    value = val
    try:
      if int(value) == value:
        value = "%d" % value
      else:
        value = "%s" % value
    except OverflowError:
        value = "%s" % value
    except ValueError:
        value = "%s" % value
#     else:
#       value = "%s" % val
#     if not editing:
#       # Comma-fy (Temporary!)
#       if value[:1] == '-':
#         minus = "-"
#         value = value[1:]
#       else:
#         minus = ""
#
#       try:
#         whole, decimal = string.split(value,'.')
#         value = ".%s" % decimal
#       except ValueError:
#         whole = value
#         value = ""
#
#       while len(whole) > 3:
#         value = ",%s%s" % (whole[-3:], value)
#         whole = whole[:-3]
#
#       value = minus + whole + value

    return value


  def _buildValue(self):
    if not len(self.work):
      self.value = None
      return True

    try:
      dummy = float(self.work)
      self.value = self.work
      return True
    except ValueError:
      return False