#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
import string
from gnue.common import events
from gnue.common.apps import GDebug

from gnue.common.cursing import *

class ScrollableWrapper(Frame):
  def __init__(self, uiform):
    self.uiform = uiform
    self.frame = frame = uiform.containerFrame
    self.form = form = uiform._form
    self.margin = 6

    self._formWidth = formWidth = int(form._layout["Char:width"])
    self._formHeight = formHeight = int(form._layout["Char:height"])
    x = y = 0
    Frame.__init__(self, frame, y, x, formHeight, formWidth)
    ##wxScrolledWindow.__init__(self, frame, -1)
    self.spacerpane = Frame(self,y, x, formHeight, formWidth)
    

    ##EVT_SIZE(self.frame, self.OnFrameSize)
    
    ##self.layoutSize = wxSize(formWidth*uiform._uiDriver.widgetWidth,
    ##                  formHeight*uiform._uiDriver.widgetHeight)
    self._fitted = 0
    self._pageList = []

  def finalize(self):
    # This is the initial panel window setup during init
    # not a wxPanel set per page right after this
    w,h = self.pane.GetSizeTuple()
    ##self.spacerpane.SetSize(wxSize(w+self.margin*2, h+self.margin*2))
    ##self.spacerpane.SetPosition(wxPoint(self.margin, self.margin))
    ##try:
    ##  self.SetVirtualSize(self.spacerpane.GetSize())
    ##except AttributeError:
    ##  pass # Yes, it is more wx2.2 goodness!!
    self.Show()
    ##self.fixScrollbars()


  ##def OnFrameSize(self, event):
  ##  self.SetSize(self.frame.GetClientSize())
  ##  self.fixScrollbars()

  ##def fixScrollbars(self):
  ##  x1, y1 = self.frame.GetClientSizeTuple()
  ##  x2, y2 = self.spacerpane.GetSizeTuple()
  ##  if x1 < x2 or y1 < y2:
  ##    self.SetScrollbars(5, 5, x2, y2)
  ##  else:
  ##    self.SetScrollbars(0, 0, 0, 0)

  def setPage(self, page):
    for p in self._pageList:
      if p != page:
        p.Hide()
      else:
        p.Show()

                         

#
# Notebook pages
#
class TabbedWrapper(ScrollableWrapper):
  def __init__(self, *args, **parms):
    ScrollableWrapper.__init__(self, *args, **parms)
    tabstyle  = _tabStyles[self.form._layout.tabbed]
    x = y = 0
##    self.pane = notebook = Frame(self.spacerpane,y, x, self._formHeight, self._formWidth)
    self.pane = self.frame
         
##     self.pane = notebook = wxNotebook(self.spacerpane,-1, #wxPoint(6,6),
##                                       style=tabstyle)
##     self.notebooksizer = sizer1 = wxNotebookSizer(notebook)

##     sizer2 = wxBoxSizer(wxVERTICAL)
##     sizer2.Add(self.notebooksizer)
##     self.frame.SetAutoLayout(1)
##     self.spacerpane.SetSizer(sizer2)

##     notebook.Show(1)
##     self.__notebookLoopTrap = 0
##     EVT_NOTEBOOK_PAGE_CHANGING(notebook, notebook.GetId(), self.notebookTabHandler)

  def createPage(self, object):
    x = y = 4
    newWidget = Frame(self.pane,y, x,
               self._formHeight, self._formWidth,
               object.findParentOfType('GFForm').title)

##     sizer = wxBoxSizer(wxVERTICAL)
##     newWidget = wxPanel(self.pane, -1, size=self.layoutSize)
##     sizer.Add(newWidget, 0, wxCENTER)
##     newWidget.SetAutoLayout(1)
##     newWidget.SetSizer(sizer)

##     self._pageList.append(newWidget)
##     self.pane.AddPage(newWidget,hasattr(object,'caption') and object.caption or object.name)
##     self.pane.SetClientSize(self.layoutSize)
##    self.fit()
    return newWidget

  def fit(self):
##     if self._fitted: return
##     self.notebooksizer.Layout()
##     self.notebooksizer.SetSizeHints(self.pane)
##     self.SetClientSize(self.layoutSize)
##     if not USING_WX_22:
##       w,h = self.pane.GetSizeTuple()
##       w += self.margin*2
##       h += self.margin*2
##       self.spacerpane.SetSize(wxSize(w,h))
##       self.SetSize(self.spacerpane.GetSize())
##     else:
##       # TODO: How fscking sad to have to do this.
##       # TODO: but, I can't get wx 2.2 to cooperate
##       w,h = self.GetClientSizeTuple()
##       self.SetSize(wxSize(w+20, h+50))
##     self.frame.SetClientSize(self.GetSize())
    self._fitted = 1


##   def notebookTabHandler(self,event):
##     if event.GetEventType() == wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGING:
##       #object = _IdToGFObj[_eventObjTowxWindow(event).GetId()]
##       action = None
##       if self.__notebookLoopTrap == 0:
##         action = events.Event('requestPAGE',event.GetSelection(), _form=self.form)
##         self.__notebookLoopTrap = 1
##       else:
##         self.__notebookLoopTrap = 0
##     if action:
##       self.uiform._eventHandler(action)

##   def setPage(self, page):
##     pageId = self._pageList.index(page)
##     self.pane.SetSelection(pageId)


#
# Single pages
#
class PlainWrapper(ScrollableWrapper):
  def __init__(self, *args, **parms):
    ScrollableWrapper.__init__(self, *args, **parms)
    x = y = 0
    self.pane = Frame(self.spacerpane,y, x, self._formHeight, self._formWidth)
    self.pane.Show()
##     self.pane = wxPanel(self.spacerpane, -1, size=self.layoutSize, pos=wxPoint(self.margin, self.margin))

  def createPage(self, object):
    x = y = 1
    newWidget = Frame(self.pane,y, x, self._formHeight, self._formWidth, border=0, dropshadow=0)
##     newWidget = wxPanel(self.pane, -1,  size=self.layoutSize)
     
    # Only show first page
    if not self._fitted:
      newWidget.Show()
    else:
      newWidget.Hide()

    self._pageList.append(newWidget)
    self.fit()
    return newWidget

  def fit(self):
##     if self._fitted: return
##     self.pane.SetClientSize(self.layoutSize)
##     self.pane.Fit()
##     self.SetClientSize(self.pane.GetSize())
##     self.SetSize(self.pane.GetSize())
##     self.frame.Fit()
    self._fitted = 1

##   def setPage(self, page):
##     for p in self._pageList:
##       if p != page:
##         p.Show(0)
##       else:
##         p.Show(1)

        
_tabStyles = {'top':0,
              'left':1,
              'right':2,
              'bottom':3,
                             }
 
