#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/ToolBar.py
#
# DESCRIPTION:
# A gtk2 based Toolbar
#
# NOTES:
#

import string, sys
import gtk
from gnue.forms.uidrivers._commonGuiToolkit.ToolBar import ToolBar as _BaseToolBar
  
class ToolBar(_BaseToolBar):

  # Create the menu
  def init(self): 
    self.toolbar = toolbar = gtk.Toolbar()

    toolbar.set_orientation(gtk.ORIENTATION_HORIZONTAL)

    # TODO:
    #   - add user preference for toolbar 
    #      choices: (use global toolbar settings| just icon | just text | both)
    #
    # (for now use ICONS only)
    toolbar.set_style(gtk.TOOLBAR_ICONS)   # gtk.TOOLBAR_BOTH | gtk.TOOLBAR_TEXT 
    toolbar.set_tooltips(gtk.TRUE)
    
    self.container.content_table.attach(toolbar,
                                        # X direction           Y direction
                                        0, 1,                      1, 2,
                                        gtk.EXPAND | gtk.FILL,     0,
                                        0,                         0)
    return toolbar

  # Add a menu item (action)
  def addAction(self, name, userAction):

    # TODO: try to use stock items for basic functions (load/save...)
    
    # TODO: remove decode step, when gettext translations are send
    # in unicode instead of local encoding
    label = unicode(name,gConfigForms('textEncoding'))
    toolTip = unicode(userAction.description,gConfigForms('textEncoding'))
    iconloc = userAction.getIconLocation(size="24x24")

    # Set the action icon if available
    if iconloc:
      try:
        # Some caching logic for faster second/third forms
        icon = _cachedIcons[iconloc]
      except KeyError:
        icon = gtk.Image()
        icon.set_from_file(iconloc)
        _cachedIcons[iconloc] = icon
    else:
      print "** WARNING: Cannot add '%s' to toolbar; no icon" % userAction.event
      return

    event = 'request%s' % userAction.event
    
    if userAction.canToggle:
      button = self.toolbar.append_element(gtk.TOOLBAR_CHILD_TOGGLEBUTTON,None,
                                  label,toolTip,
                                  None, icon, None, None)
      button.connect("toggled", lambda widget, l=self.driver, \
              e=event, te='request%s' % userAction.canToggle,
              s=button,
              f=self.form: 
              l.dispatchEvent((widget.get_active() and e or te),_form=f))

    else:
      button = self.toolbar.append_item(label,toolTip,
                                        None, icon, None, None)
    

      button.connect("clicked", lambda widget, l=self.driver, \
                     e=event, f=self.form: l.dispatchEvent(e,_form=f))
    return button  
        
  # Add a separator
  def addSeparator(self):
    self.toolbar.append_space()
    
  # Enable a menu item
  def enableItem(self, item):
    if item != None:
      item.set_sensitive(1)
  
  # Disable a menu item
  def disableItem(self, item):
    if item != None:
      item.set_sensitive(0)
  
  def startingItem(self, item):
    if item!=None:
      item.set_active(1)

  def endingItem(self, item):
    if item!=None:
      item.set_active(0)
        
    
_cachedIcons = {}
