#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/widgets/image.py
#
# DESCRIPTION:
# A part of a gtk2 based user interface driver for GNUe forms.
#
# NOTES:
#
import gtk

from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper

#
# UIImage
#
# Widget set specific function that creates a single instance of an image
#
class UIImage(UIHelper):

  def _createWidget(self, event, spacer):
    object = event.object

    image = gtk.Image()
    # image.set_from_file(
    
    png=wxEmptyBitmap(1,1)
    
    self.pane = gtk.ScrolledWindow()

    pane.add_with_viewport(image)
    
    pane.set_size_request(self.itemWidth, self.itemHeight)

    event.container.put(pane, object.Char__x * event.widgetWidth,
                        (object.Char__y + spacer) * event.widgetHeight)
    
    return self.image
    
  def setValue(self, value, index=0, enabled=1):
    widget = self.widgets[index]
    
    # widget.SetEvtHandlerEnabled(FALSE)

    # Convert the PIL Image to a wxBitmap
    #wxImg = wxEmptyImage(value.size[0],value.size[1])
    #wxImg.SetData(value.convert("RGB").tostring())
    #image = wxImg.ConvertToBitmap()
    print "Not Implemented Yet"

    # widget.SetEvtHandlerEnabled(TRUE)

configuration = {
    'baseClass'  : UIImage,
    'provides'   : 'GFImage',
    'container'  : 0,
    }
