#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/widgets/scrollbar.py
#
# DESCRIPTION:
# A part of the gtk2 based user interface driver for GNUe forms.
#
# NOTES:
#
import gtk

from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper
from gnue.common.apps import GDebug

#
# UIScrollBar
#
# Widget set specific function that creates a single instance of a scroll bar used
# to navigate multiple records
#
class UIScrollBar(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object

    GDebug.printMesg(2, "size #1: %s,%s " % (str(object.Char__height *\
                                                 event.widgetHeight),
                                             str((object.Char__y + spacer)* \
                                                 event.widgetHeight)))

    adjustment = gtk.Adjustment(70,500,80,2,3,80)
    
    newWidget = gtk.VScrollbar(adjustment)
    newWidget.set_size_request(object.Char__width * event.widgetWidth,
                               object.Char__height * event.widgetHeight)
    
    event.container.put(newWidget,600,60)
    
    GDebug.printMesg(2, "size #2: %s,%s " % (str(object.Char__x * \
                                                 event.widgetWidth),\
                                             str((object.Char__y + spacer) * \
                                                 event.widgetHeight)))
    #event.container.show_all()
    GDebug.printMesg(1, "i am in UIScrollBar")
    return newWidget

    object = event.object
    newWidget =wxScrollBar(event.container,-1,
                           wxPoint(object.Char__x*event.widgetWidth,(object.Char__y+spacer)*event.widgetHeight),
                           wxSize(object.Char__width*event.widgetWidth,object.Char__height*event.widgetHeight),
                           wxSB_VERTICAL)
  

configuration = {
    'baseClass'  : UIScrollBar,
    'provides'   : 'GFScrollBar',
    'container'  : 0,
    }
