#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIqt.py
#
# DESCRIPTION:
# A QT-based user interface driver for GNUe forms.
#
# NOTES:
#

from qt import *

from gnue.forms.uidrivers.qt.widgets._base import UIHelper

_alignmentStyle = { 'left'  : 0, #AlignAuto|AlignVCenter,
                    'center': 0, #AlignHCenter|AlignVCenter,
                    'right' : 0, #AlignRight|AlignVCenter,
                   }


#
# UILabel
#
# Widget set specific function that creates a single instance of a label
#
class UILabel(UIHelper):


  def _createWidget(self, event, spacer):
    object = event.object
    
    # Create a label..
    newWidget = QLabel(object.text, event.container)
    
    # ..move it to it's proper place..
    print object.Char__x*event.widgetWidth, \
                              (object.Char__y+spacer+(spacer*object._gap))*event.widgetHeight, \
                                                        self.itemWidth,self.itemHeight
    newWidget.setGeometry(object.Char__x*event.widgetWidth,
                          (object.Char__y+spacer+(spacer*object._gap))*event.widgetHeight, 
                          self.itemWidth,self.itemHeight)

    # ..and set justification
    newWidget.setAlignment(_alignmentStyle[object.alignment])
    
    return newWidget

    
    
    
configuration = {
    'baseClass'  : UILabel,
    'provides'   : 'GFLabel',
    'container'  : 0,
    }
