#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# win32/widgets/entry.py
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#

import win32gui, win32con
from gnue.common import events

from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Entry
from gnue.forms.uidrivers.win32.common import *

#
# UIEntry
#
# Widget set specific function that creates a single instance of a data entry widget
#
class UIEntry(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object

    ostyle = object.style
    height = self.itemHeight+2
    width = self.itemWidth+8
    title = ""
    
    if ostyle == 'dropdown':
      style = win32con.WS_CHILD | win32con.WS_VSCROLL | win32con.WS_BORDER | win32con.LBS_NOTIFY | \
                 win32con.CBS_DROPDOWNLIST | win32con.CBS_NOINTEGRALHEIGHT
      styleEx = 0
      className = "COMBOBOX"
      height = self.itemHeight +100 # TODO
      
    elif ostyle == 'label':
      style = win32con.WS_CHILD
      styleEx = 0
      className = "STATIC"

    elif ostyle == 'checkbox':
      style = win32con.WS_CHILD | win32con.BS_AUTOCHECKBOX
      styleEx = 0
      className = "BUTTON"
      title = object.label
      
    else: # Normal text box
      style = win32con.WS_CHILD | win32con.ES_NOHIDESEL #| \
                 #win32con.WS_BORDER #| win32con.ES_AUTOHSCROLL

      if hasattr(object,'Char__height') and object.Char__height > 1:
        style = style | win32con.ES_MULTILINE | win32con.ES_AUTOVSCROLL | \
                win32con.WS_VSCROLL #| win32con.ES_WANTRETURN
        width = self.itemWidth

      styleEx = win32con.WS_EX_CLIENTEDGE
      className = "EDIT"

    newWidget = Win32Entry(self._uiDriver, styleEx, className, title, style,
                        object.Char__x*event.widgetWidth,
                        (object.Char__y+spacer+(object._gap*spacer))*event.widgetHeight,
                        width,
                        height,
                        event.container, getNextId())

    if ostyle == 'dropdown':
      if event.initialize:
        choices = object._field.allowedValues()[1]
      else:
        choices = [""]
      for item in choices:
        win32gui.SendMessage(newWidget.GetHwnd(), win32con.CB_ADDSTRING, 0, textEncode(item))
      if event.initialize:
        newWidget._origAllowedValues = object._field._allowedValues
        newWidget.SetValue("")

    self._eventHandler = event.eventHandler
    return newWidget


configuration = {
    'baseClass'  : UIEntry,
    'provides'   : 'GFEntry',
    'container'  : 0,
  }
