#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#

import struct
import win32gui, win32con
from gnue.common import events

from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Window
from gnue.forms.uidrivers.win32.common import getNextId

#
# UIScrollBar
#
# Widget set specific function that creates a single instance of a scroll bar used
# to navigate multiple records
#
class UIScrollBar(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object

    style = win32con.WS_CHILD | win32con.WS_VISIBLE |win32con.SBS_VERT | win32con.SBS_RIGHTALIGN
    styleEx = 0

    newWidget = self._widget = Win32Window(self._uiDriver, styleEx, "Scrollbar", "", style,
                        object.Char__x*event.widgetWidth,
                        (object.Char__y+spacer)*event.widgetHeight,
                        object.Char__width*event.widgetWidth,
                        object.Char__height*event.widgetHeight,
                        event.container, getNextId())

    if event.initialize:
      self._eventHandler = event.eventHandler
      object._block.registerScrollbar(self)
      self._rows = object._block._rows
      self._hwnd = newWidget.GetHwnd()

    return newWidget

  def adjustScrollbar(self, pos, range):
      format = "IIiiIii"
      size = struct.calcsize(format)
      mask =  win32con.SIF_RANGE | win32con.SIF_PAGE | win32con.SIF_POS
      scrollinfo = struct.pack(format, size, mask, 0, range+self._rows-3, self._rows-1, pos, 0)
      win32gui.SendMessage(self._hwnd, win32con.SBM_SETSCROLLINFO , 1, scrollinfo)

configuration = {
    'baseClass'  : UIScrollBar,
    'provides'   : 'GFScrollBar',
    'container'  : 0,
    }
