#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
from wxPython.wx import *
from gnue.common import events
from types import UnicodeType

from gnue.forms.uidrivers.wx.widgets._base import UIHelper
from gnue.forms.uidrivers.wx.common import _eventObjTowxWindow, wxEncode, wxDecode
from gnue.forms.uidrivers.wx.common import _setDefaultEventHandlers

#
# UIEntry
#
# Widget set specific function that creates a single instance of a data entry widget
#
class UIEntry(UIHelper):
  """
  A wxPython-based UI driver for GNUe Forms
  """
  def _createWidget(self, event, spacer):
    """
    Creates a single instance of a data entry widget
    """
    object = event.object

    style = object.style
    defaultPoint =  wxPoint(object.Char__x*event.widgetWidth,
                            (object.Char__y+spacer+(object._gap*spacer))*event.widgetHeight)
    defaultSize  = wxSize(self.itemWidth,self.itemHeight+1)

    if style == 'dropdown':
      if event.initialize:
        choices = []
        for val in object._field.allowedValues()[1]:
          choices.append(wxEncode(val))
          
      else:
        choices = [""]

      choices.sort()

      newWidget = wxComboBox(event.container, -1, "",defaultPoint,
                              wxSize(self.itemWidth,self.itemHeight),
                             choices, wxCB_DROPDOWN,) #|wxWANTS_CHARS,)
      if event.initialize:
        newWidget._origAllowedValues = object._field._allowedValues
        newWidget.SetValue("")
        newWidget_Id = newWidget.GetId()
        EVT_COMBOBOX(newWidget, newWidget_Id, self.comboHandler)
        EVT_TEXT(event.container, newWidget_Id, self.comboHandler)
        EVT_TEXT_ENTER(event.container, newWidget_Id, self.comboHandler)
        self.comboDropped = True    # True if the combobox is dropped and the list is visible.
        # For some strange reason it is best to initialize it True as if
        # the list would be dropped down at startup, though it is not...


    elif style == 'label':
      newWidget = wxStaticText(event.container, -1, "",defaultPoint,defaultSize,
                               wxST_NO_AUTORESIZE)
      # To make the label consistent with the other entry styles...
      newWidget.SetValue = newWidget.SetLabel
      newWidget.GetValue = newWidget.GetLabel

    elif style == 'checkbox':
      newWidget = wxCheckBox(event.container, -1, wxEncode(object.label),defaultPoint,
                             wxSize(self.itemWidth,event.textHeight),
                             wxNO_BORDER|wxWANTS_CHARS)
      if event.initialize:
        newWidget.SetValue(0)
        EVT_CHECKBOX(newWidget, newWidget.GetId(), self.checkboxHandler)

    else: # Normal text box
      if event.initialize:
        styles = wxTE_PROCESS_TAB
        if hasattr(object,'Char__height') and object.Char__height > 1:
          styles = styles|wxTE_MULTILINE
        value = ""  ## object.getValue()
      else:
        styles = 0
        value = ""

      newWidget = wxTextCtrl(event.container, -1, value, defaultPoint, defaultSize, styles)
    self._eventHandler = event.eventHandler
    if event.initialize:
      _setDefaultEventHandlers(newWidget, event.eventHandler, event.initialize, self._uiDriver)
    return newWidget

  def comboHandler(self, event):
    """
    Handles combobox
    When combobox list is dropped, we call beginEdit, via event requestCOMBODROPPED
    When a value is selected from the list, we call replaceText, via event requestREPLACEVALUE
    """
    action = None
    eventType = event.GetEventType()

    if self.comboDropped == True:
      if eventType in [wxEVT_COMMAND_COMBOBOX_SELECTED, wxEVT_COMMAND_TEXT_UPDATED, wxEVT_COMMAND_TEXT_ENTER]:
        self.comboDropped = False

        object = _eventObjTowxWindow(event)
        gfObject = self._uiDriver._IdToGFObj[object.GetId()]
        selection = event.GetSelection()

        action = events.Event('requestREPLACEVALUE',object=gfObject,
                              index=selection, text=wxDecode(event.GetString()),
                            _form=gfObject._form)
    else:
      if eventType in [wxEVT_COMMAND_COMBOBOX_SELECTED,wxEVT_COMMAND_TEXT_ENTER]:
        self.comboDropped = True

        object = _eventObjTowxWindow(event)
        gfObject = self._uiDriver._IdToGFObj[object.GetId()]
        uiObject = self._uiDriver._IdToUIObj[object.GetId()]
        uiObject._eventHandler('requestFOCUS',gfObject,_form=gfObject._form)
        action = events.Event('requestCOMBODROPPED', _form=gfObject._form)

    self._eventHandler(action)
    #event.Skip()   #Is it needed here?


  def checkboxHandler(self,event):
    """
    Handles checkbox toggling if checkbox is clicked.
    """
    action = None
    if event.GetEventType() == wxEVT_COMMAND_CHECKBOX_CLICKED:
      object = _eventObjTowxWindow(event)
      id = object.GetId()

      gfObject     = self._uiDriver._IdToGFObj[id]
      eventdata = [gfObject, event.GetString()]
      action = events.Event('requestTOGGLECHKBOX', _form=gfObject._form)
    self._eventHandler(action)


configuration = {
    'baseClass'  : UIEntry,
    'provides'   : 'GFEntry',
    'container'  : 0,
  }
