#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
from wxPython.wx import *

from gnue.forms.uidrivers.wx.widgets._base import UIHelper
import Image

#
# UIImage
#
# Widget set specific function that creates a single instance of an image
#
class UIImage(UIHelper):

  def _createWidget(self, event, spacer):
    object = event.object
    #im = Image.open("/home/jamest/cvs/ajrs/imaging/src/testfoo.png")
    #wxImg = wxEmptyImage(im.size[0],im.size[1])
    #wxImg.SetData(im.tostring())
    #png = wxImg.ConvertToBitmap()
    
    png=wxEmptyBitmap(1,1)
    
    self.pane = wxScrolledWindow(event.container, -1,
                                 wxPoint(object.Char__x*event.widgetWidth,
                                         (object.Char__y+spacer+(spacer*object._gap))*event.widgetHeight),
                                 wxSize(self.itemWidth,self.itemHeight))
    EVT_SIZE(self.pane,self.OnFrameSize)
    EVT_PAINT(self.pane, self.onPaint)

    imageWidth = png.GetWidth()
    imageHeight = png.GetHeight()
    self.imageWindow = wxStaticBitmap(self.pane, -1, png,
                               wxPoint(0,0), #object.Char__x*event.widgetWidth,
                                             #(object.Char__y+spacer+(spacer*object._gap))*event.widgetHeight),
                               wxSize(imageWidth,imageHeight))
    #self.imageWindow = wxStaticBitmap(self.pane, -1, png,
    #                           wxPoint(object.Char__x*event.widgetWidth,
    #                                   (object.Char__y+spacer+(spacer*object._gap))*event.widgetHeight),
    #                           wxSize(self.itemWidth,self.itemHeight))
    self.fixScrollbars()
    
    return self.imageWindow
    
  def OnFrameSize(self, event):
    pass
    #self.pane.SetSize(self.pane.GetClientSize())
    #self.fixScrollbars()

  def onPaint(self,event):
    self.imageWindow.Refresh()

  def fixScrollbars(self):
    x1, y1 = self.pane.GetClientSizeTuple()
    x2, y2 = self.imageWindow.GetSizeTuple()
    if x1 < x2 or y1 < y2:
      self.pane.SetScrollbars(5, 5, x2/5, y2/5)
    else:
      self.pane.SetScrollbars(0, 0, 0, 0)

  def setValue(self, value, index=0, enabled=1):
    widget = self.widgets[index]
    widget.SetEvtHandlerEnabled(FALSE)

    # Convert the PIL Image to a wxBitmap
    wxImg = wxEmptyImage(value.size[0],value.size[1])
    wxImg.SetData(value.convert("RGB").tostring())
    image = wxImg.ConvertToBitmap()

    # Resize the bitmap holder to match the image size
    # and fix the scrollbars 
    imageWidth = image.GetWidth()
    imageHeight = image.GetHeight()
    widget.SetSize(wxSize(imageWidth,imageHeight))
    self.fixScrollbars()

    # Load the new image
    widget.SetBitmap(image)

    widget.Enable(enabled)
    widget.SetEvtHandlerEnabled(TRUE)
    widget.Refresh()

configuration = {
    'baseClass'  : UIImage,
    'provides'   : 'GFImage',
    'container'  : 0,
    }
