#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2003 Free Software Foundation
#
# FILE:
# GNClient.py
#
# DESCRIPTION:
# Client startup file that creates a navigation menu from a file
#
# NOTES:
#

import pstats
import os
import os.path
import sys
import urllib
import string

from gnue.navigator.GNParser import loadProcesses
from gnue.navigator import Actions
from gnue.common.apps import GDebug
from gnue.common.utils.FileUtils import openResource, dyn_import
from gnue.common.datasources import GDataObjects, GConnections
from gnue.common.apps.GClientApp import *
from gnue import paths
from gnue.navigator import VERSION

from GNConfig import ConfigOptions as NavigatorConfigOptions

# TODO: Please go away!!!!!
try: 
  from gnue.forms.GFConfig import ConfigOptions
except: 
  FORMS_SUPPORT=0
  
try: 
  from gnue.reports.base.GRConfig import ConfigOptions as ReportsConfigOptions
  REPORTS_SUPPORT=1
except: 
  REPORTS_SUPPORT=0
  

class GNClient(GClientApp):
  #
  # GClientApp() overrides
  #
  VERSION = VERSION
  COMMAND = "gnue-navigator"
  NAME = "GNUe Navigator"
  USAGE = "[options] file"
  COMMAND_OPTIONS = [
      [ 'user_interface', 'u', 'user_interface', 1, None, 'type',
          'The currently supported values for <type> are ' \
        + 'wx, gtk2, win32, web (a themable web-like interface), and text' ],
      [ 'splash_screen','s','no-splash', 0, None, None,
          'Disables the splash screen'],
      [ 'gnome_menu',None,'install-gnome-menu', 0, None, None,
          'Installs a menu structure into your local GNOME session'],
      [ 'kde_menu',None,'install-kde-menu', 0, None, None,
          'Installs a menu structure into your local KDE session']
      ]
  SUMMARY = \
     "GNUe Navigator is the primary menuing interface to the GNU Enterprise system."

  #
  # Initialize the class
  #
  def __init__(self, connections=None):
    GClientApp.__init__(self, connections,'forms', ConfigOptions)
    self.configurationManager.loadApplicationConfig(section="navigator",defaults=NavigatorConfigOptions)
    
    if REPORTS_SUPPORT: 
      self.configurationManager.loadApplicationConfig(section="reports",defaults=ReportsConfigOptions)
      self.configurationManager.registerAlias('gConfigReports', 'reports')
      
    self.configurationManager.registerAlias('gConfigNav', 'navigator')
    self.configurationManager.registerAlias('gConfigForms', 'forms')

    self._formInstances = {}
    self._lastSerialNumber = 0


  #
  # Run the client application
  #
  # GClientApp().run() override
  #
  def run(self):

    #
    # Initialize user interface
    #
    self.ui_type = self.OPTIONS['user_interface']
    if self.ui_type:
      SPECIFIC_UI = 1
    else:
      SPECIFIC_UI = 0
      self.ui_type = gConfigForms('DefaultUI')

    while 1:
      try:
        self._ui = dyn_import("gnue.navigator.UI%s" % (self.ui_type))
        break
      except ImportError, err:
        GDebug.printMesg(1,_("Unable to load UI driver")+" %s" % self.ui_type)
        GDebug.printMesg(1,err)

        # If user specified a specific UI, don't cycle...
        if SPECIFIC_UI:
          raise  # TODO: TEMPORARY
          self.handleStartupError(_("Unable to load any valid UI drivers.  Aborting.\n\nTraceback\n%s") % err)

        if self.ui_type != 'text':
          self.ui_type = 'text'
        else:
          self.handleStartupError(_("Unable to load any valid UI drivers.  Aborting."))


    #
    # assign menu file from 1st free argument
    #
    try:
      processFile = self.ARGUMENTS[0]
    except:
      try:
        if string.split(string.lower(os.path.basename(sys.argv[0])),'.')[0] not in ('gnue-navigator','gncvs'):
          processFile = paths.data+'/'+gConfigNav('ProcessDir')+"/"+os.path.basename(sys.argv[0])+".gpd"
        else:
          raise IndexError
      except IndexError:
        self.handleStartupError ("No Process Definition File Specified.")


    fileHandle = openResource(processFile)
    nav = loadProcesses (fileHandle)
    fileHandle.close()


    # Handle any action commands
    if self.OPTIONS['kde_menu']:
      from gnue.navigator.Actions import kde_menu
      kde_menu.run(nav, self.ARGUMENTS[1:])
      sys.exit()

    if self.OPTIONS['gnome_menu']:
      from gnue.navigator.Actions import gnome_menu
      gnome_menu.run(nav, self.ARGUMENTS[1:])
      sys.exit()


    if gConfigNav('disableSplash') == '1':
      self.disableSplash = 1
    else:
      self.disableSplash = self.OPTIONS['splash_screen']


    # add connections object to top object
    nav._connections=self.connections
    
    self._ui.Instance(nav).run(self.connections)

if __name__ == '__main__':
  GNClient().run()


