#
# Copyright 2002-2003 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# UIgtk2.py
#
# DESCRIPTION:
# Set of classes that provide a menuing interface via wxPython
#
# NOTES:
# This file is nothing but a temporary hack.  Navigator should
# reuse GNUe Form's UI* classes if at all possible.


import pygtk
pygtk.require('2.0')

import gtk
import pango
import gtkhtml2
import gobject

__gtk_mainloop = None

from time import sleep
import os, sys, string
from gnue.common.datasources import GDataObjects, GConnections
from gnue.common.utils.FileUtils import dyn_import, openResource
from gnue.common.apps import GConfig
from gnue.navigator import VERSION

try:
  from gnue.forms.GFInstance import GFInstance
  from gnue.forms import GFParser
  from gnue.forms.uidrivers import gtk2 as ui
  FORMS_SUPPORT=0
except ImportError:
  FORMS_SUPPORT=1
  print 'GNUe Forms is not installed on your system'

images_dir = GConfig.getInstalledBase('forms_images','common_images') + '/'

import urllib


class ProcessTree(gtk.TreeView):
  def __init__(self, processes, on_selected, on_activated):
    self._callbacks={}
    self._callbacks['on_selected']=on_selected
    self._callbacks['on_activated']=on_activated
    
    # a) the model
    self._treeStore = gtk.TreeStore(gobject.TYPE_STRING)
    self._mapping = {}
    processes.walk(self.__buildTreeStore)
    processes.walk(self.__removeNodes)

    #  b) the widget (i.e. "my-self")
    gtk.TreeView.__init__(self, self._treeStore)
    cell = gtk.CellRendererText()
    column = gtk.TreeViewColumn("tuples", cell, text=0)
    self.append_column(column)
    self.connect("row-activated",self._row_activated)
    self.connect("cursor-changed",self._row_selected)
    self.set_headers_visible(gtk.FALSE)
    self.expand_row((0,),gtk.FALSE)
    self._oldpath=(0,)

  def __buildTreeStore(self, object):

    if object._type == 'GNProcesses':
      # add parent (top) object
      node=self._treeStore.append(None)
      self._treeStore.set(node, 0, object.title)
      
    elif object._type in ('GNStep','GNProcess'):
      # add child
      node=self._treeStore.append(object._parent.__node)
      self._treeStore.set(node, 0, object.title)
    else:
      return

    object.__node = node 
    self._mapping[self._treeStore.get_path(node)] = object

  ## TODO: Is this necessary?
  def __removeNodes(self, object):
    if hasattr(object,"__node"):
      del object.__node

  def _row_selected(self, tree):
    (path,column)=self.get_cursor()
#    print  'selected:', path
    if path != self._oldpath:
      self._callbacks['on_selected'](self._mapping[path])
      self._oldpath=path

  def _row_activated(self,  view, path, column):
#    print  'activated:', path
    
    # 1. try to expand
    self.expand_row(path,gtk.FALSE)
    # 2. pass event further
    self._callbacks['on_activated'](self._mapping[path])

  def reload_definitions(self, processes):
    # remove elements from tree
    self.treeStore.clear()
    self._mapping = {}
    processes.walk(self.__buildTreeStore)
    processes.walk(self.__removeNodes)
    self.expand_row((0,),gtk.FALSE)

class Instance:
  def __init__(self, processes):
    self.processes = processes
    self._formInstances = {}
    self._lastSerialNumber = 0

    self.titlePage = _("""
    <html>
      <body>
        <center>
         <B>GNUe Navigator</B>
         <p><img src="%s"></p>
         <p>A part of the <a href="http://www.gnuenteprise.org/">GNU Enterprise Project</a></p>
        </center>
      </body>
    </html>
    """) % (images_dir+"/ship2.png")

    self.app = ui.getApp()
         
  def run(self, connections):
    #
    # Assign the proper login handler based upon the user interface choice
    #
    self.connections = connections
    self.connections.setLoginHandler(ui.UILoginHandler())

    self.mainWindow = gtk.Window()
    self.mainWindow.set_resizable(gtk.TRUE)
    self.content_table = gtk.Table(4, 1, gtk.FALSE)
    self.mainWindow.add(self.content_table)    
    self.mainWindow.set_title('GNUe Navigator')
    self.mainWindow.set_default_size(600,400)
    self.mainWindow.connect('delete_event', self.OnClose)

    #
    # StatusBar
    #
    self.statusbar = gtk.Statusbar();
    self.content_table.attach(self.statusbar,
                 # X direction           Y direction
                 0, 1,                   3, 4,
                 gtk.EXPAND | gtk.FILL,  0,
                 0,                      0)

    #
    # MenuBar
    #
    self.menu = self.createMenuBar()
    self.content_table.attach(self.menu,
                 # X direction           Y direction
                 0, 1,                      0, 1,
                 gtk.EXPAND | gtk.FILL,     0,
                 0,                         0)


    #
    # main part of window
    #
    self.splitter= gtk.HPaned()
    self.content_table.attach(self.splitter,
                 # X direction           Y direction
                 0, 1,                   2, 3,
                 gtk.EXPAND | gtk.FILL,  gtk.EXPAND | gtk.FILL,
                 0,                      0)

    self.panel1 = gtk.ScrolledWindow()
    self.panel1.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_AUTOMATIC)
    #self.panel1.set_border_width(2)
    self.panel1.set_shadow_type(gtk.SHADOW_IN)

    self.splitter.add1(self.panel1)

    self.panel2 = gtk.ScrolledWindow()
    self.panel2.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_AUTOMATIC)
#    self.panel2.set_border_width(2)
    self.panel2.set_shadow_type(gtk.SHADOW_IN)
    self.splitter.add2(self.panel2)

    self.splitter.set_position(200)
    
    # Panel 1 contents
    self.tree = ProcessTree(self.processes,
                            self.loadDescription,
                            self.executeStep)
    self.panel1.add(self.tree)


    # Panel 2 contents
    self.document = gtkhtml2.Document()
    self.document.connect('request_url', self.request_url)
    self.document.connect('link_clicked', self.link_clicked)
                                                                                
    self.document.clear()
    self.document.open_stream('text/html')
    self.document.write_stream(self.titlePage)
    self.document.close_stream()
                                                                                 
    view = gtkhtml2.View()
    view.set_document(self.document)
    self.panel2.add(view)
    
    self.processes.setClientHandlers({'form':self.runForm})

    self.mainWindow.show_all()
    self.app.mainLoop()


  def request_url(self,obj,url,stream):    
#    print "request url",url
    opener = urllib.FancyURLopener()
    f = opener.open(url)
    stream.write(f.read())

  def link_clicked(self,obj,link):
#    print "Link clicked",link
    opener = urllib.FancyURLopener()
    try:
        f = opener.open(link)
    except OSError:
        print "failed to open", link
        return
    currentUrl = resolve_uri(link)
    document.clear()
    headers = f.info()
    mime = headers.getheader('Content-type')
    # TODO: test content type for gnue/process, if yes, load process file into tree widget
    if mime:
        document.open_stream(mime)
    else:
        document.open_stream('text/plain')
    document.write_stream(f.read())
    document.close_stream()

  def setStatus(self,mesg):
    self.statusbar.pop(0)
    self.statusbar.push(0,mesg)

  def OnClose(self, obj, more, muchmore=1):
    # close down
    # TODO: use GFgtkAPP instead, so open form widgets wouldn't get closed by accident.
    self.app.quit()

  def OnAbout(self, obj, more, muchmore):
    # TODO: Create a more beautiful about box
    text = _("GNUE Navigator")+"\n"+      \
    _("    Version : ")+"%s\n"+         \
    _("    Driver  : UIgtk2")+"\n"+ \
    _("-= Process Info =-                  ")+"\n"+        \
    _("    Name   : ")+"%s\n"+          \
    _("    Version: ")+"%s\n"+          \
    _("    Author : ")+"%s\n"+          \
    _("    Description: ")+"%s\n"
    dlg = gtk.MessageDialog(self.mainWindow,
                            gtk.DIALOG_DESTROY_WITH_PARENT + gtk.DIALOG_MODAL,
                            gtk.MESSAGE_INFO,
                            gtk.BUTTONS_CLOSE,
                            text % (VERSION,'-','-','-','-'))
    dlg.connect('response', lambda dlg, response: dlg.destroy())
    dlg.show()

  def OnOpen(self, obj, more, muchmore):
    # TODO: Implement for other uidrivers
    self.fs=fs=gtk.FileSelection()
    fs.complete('*.gpd') # todo: make this work
    fs.hide_fileop_buttons()
    fs.ok_button.connect('clicked',lambda obj, self: self.reloadProcesses(self.fs.get_filename()),self)
    fs.cancel_button.connect('clicked',lambda obj, self: self.fs.destroy(),self)
    fs.ok_button.connect_after('clicked',lambda obj, self: self.fs.destroy(),self)
    fs.show()

  def reloadProcesses(self,filename):
    # TODO: 1. finish 2. move this part into ui independent part
    print filename
    return
    self.processes=loadDefinition(filename)
    self.tree.reload_definitions(self.processes)

  def loadDescription(self,obj):
    # a) get description
    newDescr="<HTML><HEAD></HEAD><BODY></BODY></HTML>"
    for item in obj._children:
      if item._type == 'GNDescription':
        newDescr=item.getChildrenAsContent()
        break
      
    # b) write to document
    self.document.clear()
    self.document.open_stream('text/html')
    self.document.write_stream(newDescr)
    self.document.close_stream()


  def executeStep(self,step):
    print "executing step:", step
    if step._type != 'GNStep':
      pass
    else:
      step.run()

  # Called whenever forms goes into a "wait" state in which user cannot
  # interact with interface (e.g., while waiting for a query or a commit)
  def beginWait (self):
    pass #wxBeginBusyCursor()

  # Called whenever forms leaves a "wait" state
  def endWait (self):
    pass #wxEndBusyCursor()


  def getNextSerialNumber (self):
     self._lastSerialNumber = self._lastSerialNumber + 1
     return self._lastSerialNumber

  # forms compatibility
  def handleStartupError(self, mesg):
    self.handleError(mesg)
                         
  def handleError(self, mesg):
    dlg = gtk.MessageDialog(self.mainWindow,
                            gtk.DIALOG_DESTROY_WITH_PARENT + gtk.DIALOG_MODAL,
                            gtk.MESSAGE_ERROR,
                            gtk.BUTTONS_CLOSE,
                             "Error: %s!" % mesg)
    dlg.connect('response', lambda dlg, response: dlg.destroy())
    dlg.show()

  def runFormFromTrigger(self, form, parameters = {}):
    self.setStatus('running form %s from trigger' % formfile)
    self._runForm(form)

  def runForm(self, step, parameters = {}):
    # This is the code executing in the new thread. Simulation of
    # a long process (well, 10s here) as a simple loop - you will
    # need to structure your processing so that you periodically
    # peek at the abort variable

    # TODO: Pass parameters

    if os.path.basename(step.location) == step.location:
      try:
        formdir = gConfigNav('FormDir')
      except KeyError:
        formdir = ""
      formfile = formdir+"/"+step.location
    else:
      formfile = step.location

    self.setStatus('running form %s' % formfile)
    self._runForm(formfile, parameters)


  def _runForm(self, formfile, parameters):
    try:
      #
      # Create the instance
      #
      #instance = GFInstance(id(self),
      #    connections=self.connections,
      #    ui=ui, disableSplash=1)
      instance = GFInstance(self,connections=self.connections,
                            ui=ui,disableSplash=1, parameters=parameters)
      self._formInstances[id(self)] = instance
         
      #
      # Build the form tree
      #
      instance.addFormFromFile(formfile)

      #
      # Start the instance
      #
      instance.addDialogs()
          
      #instance.buildForm(form)
      instance.activate()

    except GConnections.Error, mesg:
      self.handleError(mesg)

    except IOError, mesg:
      self.handleError(_("Unable to open file\n\n     %s")%mesg)

    except GDataObjects.ConnectError, mesg:
      self.handleError(\
         _("Unable to login to datasource.\n\n       %s") %mesg)

    except GDataObjects.ConnectionError, mesg:
      self.handleError(\
         _("Error while communicating with datasource.\n\n       %s") %mesg)

    except GDataObjects.Error, mesg:
      self.handleError(mesg)
    print 'closed'


  def createMenuBar(self):    

    menu_items = (
      ('/_File',            None,         None,        0, '<Branch>' ),
#      ('/File/_New',        '<control>N', menuitem_cb, 0, '<StockItem>', gtk.STOCK_NEW),
      ('/File/_Open',       '<control>O', self.OnOpen, 0, '<StockItem>', gtk.STOCK_OPEN),
#      ('/File/_Save',       '<control>S', menuitem_cb, 0, '<StockItem>', gtk.STOCK_SAVE),
#      ('/File/Save _As...', None,         menuitem_cb, 0, '<StockItem>', gtk.STOCK_SAVE),
      ('/File/_Quit',       '<control>Q', self.OnClose, 0, '<StockItem>', gtk.STOCK_QUIT),
      
      ('/_Favorites',          None,        None,  0, '<Branch>'),
      ('/_Favorites/_Add Favorite',       None,        None,  0, ''),
      ('/_Favorites/_Organize Favorites', None,        None,  0, ''),
 
      ('/_Help',               None,        None,  0, '<Branch>'),
      ('/Help/_About',         None, self.OnAbout, 0,''),
      )

    self.accel_group = gtk.AccelGroup()
    self.mainWindow.add_accel_group(self.accel_group)
    
    self.item_factory = gtk.ItemFactory(gtk.MenuBar, '<main>', self.accel_group)
    
    self.item_factory.create_items(menu_items, self.mainWindow)
    
    return self.item_factory.get_widget('<main>')

