#
# Copyright 2002-2003 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
# Set of classes that provide a menuing interface via wxPython
#
# NOTES:
# This file is nothing but a temporary hack.  Navigator should
# reuse GNUe Form's UI* classes if at all possible.


from wxPython.wx import *
from wxPython.html import *
from time import sleep
import os, sys, string
from gnue.common.datasources import GDataObjects, GConnections
from gnue.common.utils.FileUtils import dyn_import, openResource
from gnue.common.apps import GConfig
from gnue.navigator import VERSION

try:
  from gnue.forms.GFInstance import GFInstance
  from gnue.forms import GFParser
  from gnue.forms.uidrivers import wx as ui
  FORMS_SUPPORT=0
except ImportError:
  FORMS_SUPPORT=1
  print 'GNUe Forms is not installed on your system'

images_dir = GConfig.getInstalledBase('forms_images','common_images') + '/'

class Instance:
  def __init__(self, processes):
    self.processes = processes
    self._formInstances = {}
    self._lastSerialNumber = 0

    self.titlePage = """
    <html>
      <body>
        <center>
         <B>GNUe Navigator</B>
         <p><img src="%s"></p>
         <p>A part of the <a href="http://www.gnuenteprise.org/">GNU Enterprise Project</a></p>
        </center>
      </body>
    </html>
    """ % (images_dir+"/ship2.png")

  def run(self, connections):
    #
    # Assign the proper login handler based upon the user interface choice
    #
    self.connections = connections
    self.connections.setLoginHandler(ui.UILoginHandler())

    app = ui.getWxApp()
    self._app = app
    self.frame = wxFrame(NULL, -1, "GNUe Navigator", size=wxSize(600,400))
    EVT_CLOSE(self.frame,self.OnClose)

    self.menu = MenuBar(self)
    self.frame.SetMenuBar(self.menu)

    EVT_MENU (self.frame, ID_EXIT, self.OnClose)
    EVT_MENU (self.frame, ID_ABOUT, self.OnAbout)        

    self.splitter= wxSplitterWindow(self.frame,-1)

    self.panel1 = wxWindow(self.splitter, -1)
    self.panel2 = wxWindow(self.splitter, -1)

    # Panel 1 contents
    self.panel1.SetBackgroundColour(wxWHITE)
    self.tree = wxTreeCtrl(self.panel1,-1)
    self.processes.setClientHandlers({'form':self.runForm})

    EVT_TREE_SEL_CHANGED(app, self.tree.GetId(), self.OnTreeItemSelected)
    EVT_TREE_ITEM_ACTIVATED(app, self.tree.GetId(), self.OnTreeItemActivated)

    self._mapping = {}
    self.processes.walk(self.__buildTreeControl)

    self.tree.Expand(self.processes.__node)

    # Panel 2 contents
    self.panel2.SetBackgroundColour(wxWHITE)
    self.helpText = wxHtmlWindow(self.panel2, -1)
    self.helpText.SetPage(self.titlePage)

    EVT_SIZE(self.panel1,self.onResize)
    EVT_SIZE(self.panel2,self.onResize)

    self.frame.Show(true)

    self.splitter.SetMinimumPaneSize(20)
    self.splitter.SplitVertically(self.panel1, self.panel2)
    self.splitter.SetSashPosition(200)


    app.MainLoop()

  def onResize(self,evt):
    self.tree.SetSize(self.panel1.GetSize())
    self.helpText.SetSize(self.panel2.GetSize())


  def __buildTreeControl(self, object):

    if object._type == 'GNProcesses':
      node = self.tree.AddRoot(object.title)
    elif object._type in ('GNStep','GNProcess'):
      node = self.tree.AppendItem(object._parent.__node, object.title)
    else:
      return

    object.__node = node
    self.tree.SetPyData(node, object)
    self._mapping[object] = node


  def OnClose(self, event):
    # close down 
    self.frame.Destroy()

  def OnAbout(self, event):
    text = _("GNUE Navigator")+"\n"+      \
    _("  Version : ")+"%s\n"+         \
    _("  Driver  : UIwxpython")+"\n"+ \
    _("-= Process Info =-")+"\n"+        \
    _("  Name   : ")+"%s\n"+          \
    _("  Version: ")+"%s\n"+          \
    _("  Author : ")+"%s\n"+          \
    _("  Description:")+"%s\n"
    dlg = wxMessageDialog(self.frame,
                          text % (VERSION,"","","",""),
                          _("About"), wxOK | wxICON_INFORMATION)
    dlg.ShowModal()
      
    dlg.Destroy()

  def buildMenu(self, process):
    self.tree.Expand(process.__node)
    return 1


  def OnTreeItemSelected(self, event):
    object = self.tree.GetPyData(event.GetItem())
    self.helpText.SetPage("")
    for item in object._children:
      if item._type == 'GNDescription':
        self.helpText.SetPage(item.getChildrenAsContent())
        break


  def OnTreeItemActivated(self, event):
    object = self.tree.GetPyData(event.GetItem())

    if object._type != 'GNStep':
      self.buildMenu(object)
    else:
##      delay = gConfigNav('hourglassDelay','')
##      if not delay:
##        delay = 2
##      else:
##        delay = int(delay)
##      self.beginWait()

      object.run()

##      sleep(delay)
##      self.endWait()


  # Called whenever forms goes into a "wait" state in which user cannot
  # interact with interface (e.g., while waiting for a query or a commit)
  def beginWait (self):
    wxBeginBusyCursor()

  # Called whenever forms leaves a "wait" state
  def endWait (self):
    wxEndBusyCursor()


  def getNextSerialNumber (self):
     self._lastSerialNumber = self._lastSerialNumber + 1
     return self._lastSerialNumber


  def handleError(self, mesg):
    dlg = wxMessageDialog(self.frame, "Error: %s!" % mesg, \
                          "Error", \
                          wxOK)
    dlg.ShowModal()

    dlg.Destroy()

    # print mesg

  def runFormFromTrigger(self, form, parameters = {}):
    self._runForm(form)

  def runForm(self, step, parameters = {}):
    # This is the code executing in the new thread. Simulation of
    # a long process (well, 10s here) as a simple loop - you will
    # need to structure your processing so that you periodically
    # peek at the abort variable

    # TODO: Pass parameters

    if os.path.basename(step.location) == step.location:
      try:
        formdir = gConfigNav('FormDir')
      except KeyError:
        formdir = ""
      formfile = formdir+"/"+step.location
    else:
      formfile = step.location

    self._runForm(formfile, parameters)


  def _runForm(self, formfile, parameters):

    try:
      #
      # Create the instance
      #
      #instance = GFInstance(id(self),
      #    connections=self.connections,
      #    ui=ui, disableSplash=1)
      instance = GFInstance(self,connections=self.connections,
                            ui=ui,disableSplash=1, parameters=parameters)
      self._formInstances[id(self)] = instance
         
      #
      # Build the form tree
      #
      instance.addFormFromFile(formfile)

      #
      # Start the instance
      #
      instance.addDialogs()
          
      #instance.buildForm(form)
      instance.activate()

    except GConnections.Error, mesg:
      self.handleError(mesg)

    except IOError, mesg:
      self.handleError(_("Unable to open file\n\n     %s")%mesg)

    except GDataObjects.ConnectError, mesg:
      self.handleError(\
         _("Unable to login to datasource.\n\n       %s") %mesg)

    except GDataObjects.ConnectionError, mesg:
      self.handleError(\
         _("Error while communicating with datasource.\n\n       %s") %mesg)

    except GDataObjects.Error, mesg:
      self.handleError(mesg)


ID_EXIT = wxNewId()
ID_FAV_ORG = wxNewId()
ID_FAV_ADD = wxNewId()
ID_ABOUT = wxNewId()

class MenuBar(wxMenuBar):
  def __init__(self, frame):
    wxMenuBar.__init__(self)

    self._frame = frame

    self._menu = wxMenu()
    self._favorites = wxMenu()
    self._help = wxMenu()

#    self._menu.AppendSeparator()
    self._menu.Append(ID_EXIT, "E&xit", "Exit GNUe Designer")

    self._favorites.Append(ID_FAV_ADD, '&Add Favorite', 'Add highlighted item to favorites')
    self._favorites.Append(ID_FAV_ORG, '&Organize Favorites', 'Organize favorites')
    self._help.Append(ID_ABOUT,'&About','About')

    self.Append(self._menu,'&Menu')
    self.Append(self._favorites,'&Favorites')
    self.Append(self._help,'&Help')

