// Copyright (C) 2001 Nils Bokermann <Nils.Bokermann@mediaWays.net>
//
// PURPOSE OF THIS FILE: Class definition of authentication class.
//
// - Automatic Version Information via RCS:
//   $Id: LDAP_SBindRequest_authentication.h,v 1.1.10.1 2002/05/06 11:06:49 mstormi Exp $
//   $Source: /cvsroot/openh323gk/openh323gk/ldap/src/LDAP_SBindRequest_authentication.h,v $
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <ptlib.h>
#include <ldap_asn.h>

#ifndef __LDAP_SBINDREQUEST_AUTHENTICATION_H
#define __LDAP_SBINDREQUEST_AUTHENTICATION_H "@(#) $Id: LDAP_SBindRequest_authentication.h,v 1.1.10.1 2002/05/06 11:06:49 mstormi Exp $"

class LDAP_SBindRequest_authentication : public LDAP_BindRequest_authentication {
public:
  LDAP_SBindRequest_authentication(unsigned tag = 0, TagClass tagClass = ContextSpecificTagClass) :
    LDAP_BindRequest_authentication(tag, tagClass){};
  bool SetCredentials(char *val, int len);
};
#endif // __LDAP_SBINDREQUEST_AUTHENTICATION_H
//
// End of LDAP_BindRequest_authentication.h
//
