/*
**  NSBundle+Extensions.m
**
**  Copyright (c) 2005
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "NSBundle+Extensions.h"

#include "Constants.h"
#include "ConsoleWindowController.h"
#include <GNUMail/PreferencesModule.h>


@implementation NSBundle (GNUMailBundleExtensions)

//
// Can be:  $GNUSTEP_INSTALATION_DIR/{Local,Network,System}/Apps/GNUMail.app/Resources or
//     or:  ANY_OTHER_DIRECTORY/GNUMail/GNUMail.app/Resources
//
+ (id) instanceForBundleWithName: (NSString *) theName
{
  NSString *aString;
  NSBundle *aBundle;
  Class aClass;

#ifdef MACOSX
  aString = [[[NSBundle mainBundle] builtInPlugInsPath] 
	      stringByAppendingPathComponent: [theName 
						stringByAppendingPathExtension: @"prefs"]];
#else
  aString = [[[NSBundle mainBundle] resourcePath] stringByDeletingLastPathComponent];
  aString = [aString stringByDeletingPathExtension];

  // We verify if we must load the bundles in the GNUstep's Local, Network or System dir.
  // We must also be careful in case poeple are using GNUstep with --enable-flattened
  if ([aString hasSuffix: @"/Applications/GNUMail"])
    {
      aString = [NSString stringWithFormat: @"%@/Library/GNUMail/%@.prefs",
			  [[aString stringByDeletingLastPathComponent] 
			    stringByDeletingLastPathComponent],
			  theName];
    }
  else
    {
      aString = [NSString stringWithFormat: @"%@/Bundles/%@/%@.prefs",
			  [aString stringByDeletingLastPathComponent],
			  theName, theName];
    }
#endif

  ADD_CONSOLE_MESSAGE(_(@"Loading preferences bundle at path %@."), aString);
  
  aBundle = [NSBundle bundleWithPath: aString];

  aClass = [aBundle principalClass];
  
  if ([aClass conformsToProtocol: @protocol(PreferencesModule)])
    {
      return [aClass singleInstance];
    }

  return nil;
}

@end
