/*
     This file is part of GNUnet.
     (C) 2005, 2006 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/core/main.c
 * @brief Main function of gnunet-gtk
 * @author Christian Grothoff
 */

#include "platform.h"
#include "gnunetgtk_common.h"
#include <GNUnet/gnunet_directories.h>
#include <GNUnet/gnunet_util_boot.h>
#include "eggtrayicon.h"

#ifdef WINDOWS
static int debug_mode = NO;
#endif

static char * cfgFilename = DEFAULT_CLIENT_CONFIG_FILE;

/**
 * All gnunet-gtk command line options
 */
static struct CommandLineOption gnunetgtkOptions[] = {
  COMMAND_LINE_OPTION_CFG_FILE(&cfgFilename), /* -c */
#ifdef WINDOWS
  { 'd', "debug", NULL,
    gettext_noop("run in debug mode"),
    0, &gnunet_getopt_configure_set_one, &debug_mode },
#endif
  COMMAND_LINE_OPTION_HELP(gettext_noop("GNUnet GTK user interface.")), /* -h */
  COMMAND_LINE_OPTION_HOSTNAME, /* -H */
  COMMAND_LINE_OPTION_LOGGING, /* -L */
  COMMAND_LINE_OPTION_VERSION(VERSION), /* -v */
  COMMAND_LINE_OPTION_VERBOSE,
  COMMAND_LINE_OPTION_END,
};

static void * shutdownCode(void * unused) {
  shutdownPlugins();
  return NULL;
}

void gnunet_gtk_main_quit() {
  GE_setDefaultContext(NULL);
  run_with_save_calls(&shutdownCode,
		      NULL);
  gtk_main_quit();
}

#if 0
static void customLog(const char * msg) {
  addLogEntry("%s", msg);
}
#endif

int main(int argc,
	 char * const * argv) {
  GtkWidget * root;
  int i;
  struct GE_Context * ectx;
  struct GC_Configuration * cfg;
#if ENABLE_NLS
  char * path;
#endif

#ifdef WINDOWS
  SetCursor(LoadCursor(NULL, IDC_APPSTARTING));
#endif

  g_thread_init(NULL);
  gtk_init(&argc, (char***) &argv);
  i = GNUNET_init(argc,
		  argv,
		  "gnunet-gtk",
		  &cfgFilename,
		  gnunetgtkOptions,
		  &ectx,
		  &cfg);
  if (i == -1) {
    GNUNET_fini(ectx, cfg);
    return -1;
  }
#ifdef WINDOWS
  if (!debug_mode)
    FreeConsole();
#endif

#if ENABLE_NLS
  setlocale (LC_ALL, "");
  path = os_get_installation_path(IPK_LOCALEDIR);
  BINDTEXTDOMAIN("gnunet-gtk", path);
  FREE(path);
  textdomain("gnunet-gtk");
  bind_textdomain_codeset("GNUnet", "UTF-8");
  bind_textdomain_codeset("gnunet-gtk", "UTF-8");
#endif
  initGNUnetGTKCommon(ectx,
		      cfg,
		      &gnunet_gtk_main_quit);
  root
    = glade_xml_get_widget(getMainXML(),
			   "mainWindow");
  gtk_window_maximize(GTK_WINDOW(root));
#ifndef WINDOWS
  initTrayIcon();
#endif
  gtk_widget_show(root);
  //  GE_setDefaultContext(customLog);
  /* start the event loop */
  gdk_threads_enter();

#ifdef WINDOWS
  SetCursor(LoadCursor(NULL, IDC_ARROW));
#endif

  gtk_main();
  gdk_threads_leave();
  doneGNUnetGTKCommon();
  GNUNET_fini(ectx, cfg);
  return 0;
}

/* ************* end of main.c ************ */
