/*
     This file is part of GNUnet.
     (C) 2007 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/directory.c
 * @brief code for opening directories
 * @author Christian Grothoff
 */

#include "platform.h"
#include "gnunetgtk_common.h"
#include "fs.h"
#include "helper.h"
#include "meta.h"
#include "search.h"
#include <GNUnet/gnunet_util_crypto.h>
#include <GNUnet/gnunet_uritrack_lib.h>
#include <GNUnet/gnunet_namespace_lib.h>
#include <extractor.h>

#ifndef MINGW
static char *
selectFile() {
  GladeXML * uploadXML;
  GtkFileChooser * dialog;
  char * ret;

  uploadXML
    = glade_xml_new(getGladeFileName(),
		    "openDirectoryFileDialog",
		    PACKAGE_NAME);
  connectGladeWithPlugins(uploadXML);
  dialog = GTK_FILE_CHOOSER(glade_xml_get_widget(uploadXML,
						 "openDirectoryFileDialog"));
  if (gtk_dialog_run(GTK_DIALOG(dialog)) != GTK_RESPONSE_CANCEL)
    ret = gtk_file_chooser_get_filename(dialog);
  else
    ret = NULL;
  gtk_widget_destroy(GTK_WIDGET(dialog));
  UNREF(uploadXML);
  return ret;
}
#else /* MINGW */
static char *
selectFile() {
  return plibc_ChooseFile(_("Choose the directory you want to open."),
			  OFN_FILEMUSTEXIST | OFN_SHAREAWARE);
}
#endif /* MINGW */

static int
spcb(const ECRS_FileInfo * fi,
     const HashCode512 * key,
     int isRoot,
     void * closure) {
  SearchList * list = closure;
  fs_search_result_received(list,
			    fi,
			    list->uri);
  return OK;
}


void on_open_menu_activate_fs(GtkWidget * dummy1,
			      GtkWidget * dummy2) {
  char * dn;
  char * directory_data;
  unsigned long long directory_data_len;
  size_t dlen;
  struct ECRS_MetaData * md;
  int fd;
  SearchList * list;
  struct ECRS_URI * uri;
  const char * kws[2];
#if 1
  /* somehow on my system I get this (and only this event)
     always twice -- not sure why, but this is a workaround
     for now */
  static int modulo;

  if (0 == (1 & modulo++))
    return; 
#endif
  dn = selectFile();
  if (dn == NULL)
    return;
  if ( (YES != disk_file_test(NULL,
			      dn)) ||
       (OK != disk_file_size(NULL,
			     dn,
			     &directory_data_len,
			     YES)) ) {
    addLogEntry(_("Error accessing file `%s'."),
		dn);
    FREE(dn);
    return;
  }
  fd = disk_file_open(NULL,
		      dn,
#ifdef O_LARGEFILE
		      O_LARGEFILE | 
#endif          
          O_RDONLY);
  if (fd == -1) {
    addLogEntry(_("Error opening file `%s'."),
		dn);
    FREE(dn);
    return;
  }
  dlen = (size_t) directory_data_len;
  directory_data = MMAP(NULL,
			dlen,
			PROT_READ,
			MAP_SHARED,
			fd,
			0);
  if (directory_data == MAP_FAILED) {
    addLogEntry(_("Error mapping file `%s' into memory."),
		dn);
    CLOSE(fd);
    FREE(dn);
    return;
  }
  kws[0] = dn;
  kws[1] = NULL;
  uri = ECRS_keywordsToUri(kws);
  md = NULL;
  list = fs_search_started(NULL,
			   uri,
			   0,
			   0,
			   NULL,
			   FSUI_COMPLETED);
  ECRS_freeUri(uri);
  ECRS_listDirectory(NULL,
		     directory_data,
		     directory_data_len,
		     &md,
		     &spcb,
		     list);
  if (md != NULL)
    ECRS_freeMetaData(md);
  MUNMAP(directory_data, dlen);
  CLOSE(fd);
  FREE(dn);
}

/* end of directory.c */
