/*
     This file is part of GNUnet.
     (C) 2005 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/fs.h
 * @brief file-sharing globals of gnunet-gtk
 * @author Christian Grothoff
 */

#ifndef GTK_FS_H
#define GTK_FS_H

#include <GNUnet/gnunet_ecrs_lib.h>
#include <GNUnet/gnunet_fsui_lib.h>
#include "gnunetgtk_common.h"

/**
 * On search box, for namespace selection
 * (for input of search URI; lists known namespaces).
 */
enum {
  NS_SEARCH_DESCRIPTION = 0,
  NS_SEARCH_ENCNAME,
  NS_SEARCH_METADATA,
  NS_SEARCH_RATING,
  NS_SEARCH_NUM,
};

/**
 * For listing of search results for main search.
 * Represents a search result.
 */
enum {
  SEARCH_NAME = 0,
  SEARCH_SIZE,
  SEARCH_HSIZE,
  SEARCH_MIME,
  SEARCH_DESC,
  SEARCH_PIXBUF,
  SEARCH_URI,
  SEARCH_META,
  SEARCH_CELL_BG_COLOR,
  SEARCH_CELL_FG_COLOR,
  SEARCH_INTERNAL,
  SEARCH_INTERNAL_PARENT,
  SEARCH_NUM,
};

/**
 * Search entry in search summary list.
 * Represents a search process.
 */
enum {
  SEARCH_SUMMARY_NAME = 0,
  SEARCH_SUMMARY_RESULT_COUNT,
  SEARCH_SUMMARY_INTERNAL,
  SEARCH_SUMMARY_NUM
};

/**
 * Entry in download summary.
 */
enum {
  DOWNLOAD_FILENAME = 0,
  DOWNLOAD_SHORTNAME,
  DOWNLOAD_SIZE,
  DOWNLOAD_HSIZE,
  DOWNLOAD_PROGRESS,
  DOWNLOAD_URISTRING,
  DOWNLOAD_INTERNAL, /* struct DL */
  DOWNLOAD_NUM
};

enum {
  NAMESPACE_FILENAME = 0,
  NAMESPACE_SIZE,
  NAMESPACE_HSIZE,
  NAMESPACE_URISTRING,
  NAMESPACE_URI,
  NAMESPACE_META,
  NAMESPACE_NUM
};

enum {
  IN_NAMESPACE_FILENAME = 0,
  IN_NAMESPACE_SIZE,
  IN_NAMESPACE_HSIZE,
  IN_NAMESPACE_DESCRIPTION,
  IN_NAMESPACE_MIMETYPE,
  IN_NAMESPACE_LAST_STRING,
  IN_NAMESPACE_NEXT_STRING,
  IN_NAMESPACE_PUB_FREQ_STRING,
  IN_NAMESPACE_PUB_DATE_STRING,
  IN_NAMESPACE_URI,
  IN_NAMESPACE_META,
  IN_NAMESPACE_NUM
};

/**
 * Entry in upload summary.
 */
enum {
  UPLOAD_FILENAME = 0,
  UPLOAD_PROGRESS,
  UPLOAD_URISTRING,
  UPLOAD_INTERNAL,
  UPLOAD_NUM
};

enum {
  META_TYPE = 0,
  META_STYPE,
  META_VALUE,
  META_NUM,
};

enum {
  KTYPE_STRING = 0,
  KTYPE_TYPE,
  KTYPE_NUM,
};


/**
 * @brief linked list of pages in the search notebook
 */
typedef struct SL {
  struct SL * next;
  /**
   * Reference to the glade XML context that was
   * used to create the search page.
   */
  GladeXML * searchXML;

  /**
   * Reference to the glade XML context that was
   * used to create the search label.
   */
  GladeXML * labelXML;

  /**
   * Tree view widget that is used to display the
   * search results.
   */
  GtkTreeView * treeview;

  /**
   * Model of the tree view.
   */
  GtkTreeStore * tree;

  /**
   * The label used in the notebook page.
   */
  GtkWidget * tab_label;

  /**
   * The notebook page that is associated with this
   * search.
   */
  GtkWidget * searchpage;

  /**
   * Path to the entry in the summary list
   * for this search.
   */
  GtkTreeRowReference * summaryViewRowReference;

  /**
   * URI for this search.
   */
  struct ECRS_URI * uri;

  /**
   * String describing the search.
   */
  char * searchString;

  /**
   * FSUI search handle.
   */
  struct FSUI_SearchList * fsui_list;

  /**
   * Number of results received so far.
   */
  unsigned int resultsReceived;

  /**
   * X-coordinate of the last right-click in the search list.
   */
  unsigned int last_x;

  /**
   * Y-coordinate of the last right-click in the search list.
   */ 
  unsigned int last_y;

} SearchList;


typedef struct DL {
  struct DL * next;

  /**
   * URI of the download.
   */
  struct ECRS_URI * uri;

  /**
   * Where is the download being saved to?
   */
  char * filename;

  /**
   * Path in the summary view for this download.
   */
  GtkTreeRowReference * summaryViewRowReference;

  /**
   * Search that this download belongs to.
   * Maybe NULL.
   */
  struct SL * searchList;

  /**
   * Path in the search view that this
   * download is represented by.  Maybe NULL
   * if search has been closed or if download
   * was initiated from URI without search.
   */
  GtkTreeRowReference * searchViewRowReference;

  /**
   * FSUI reference for the download.
   */
  struct FSUI_DownloadList * fsui_list;

  /**
   * Total size of the download.
   */
  unsigned long long total;

  /**
   * Is this a GNUnet directory? (by mime-type)
   */
  int is_directory;

  int has_terminated;

} DownloadList;

typedef struct UL {
  struct UL * next;

  /**
   * Which file or directory are we uploading?
   */
  char * filename;

  /**
   * Path in the summary view for this download.
   */
  GtkTreeRowReference * summaryViewRowReference;

  struct FSUI_UploadList * fsui_list;

  /**
   * Set to final URI upon successful completion.
   */
  struct ECRS_URI * uri;

  /**
   * Total size of the upload.
   */
  unsigned long long total;

  int has_terminated;

} UploadList;

extern struct FSUI_Context * ctx;

extern struct GE_Context * ectx;

extern struct GC_Configuration * cfg;

extern SearchList * search_head;

extern DownloadList * download_head;

extern UploadList * upload_head;

extern GtkListStore * search_summary;

extern GtkTreeStore * download_summary;

extern GtkTreeStore * upload_summary;

#endif
