/*
     This file is part of GNUnet.
     (C) 2007, 2008 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/status.c
 * @brief status codes for files
 * @author Christian Grothoff
 */

#include "platform.h"
#include <GNUnet/gnunet_uritrack_lib.h>
#include "status.h"



const char *
getColorCode (enum GNUNET_URITRACK_STATE state)
{
  if (state & (GNUNET_URITRACK_DIRECTORY_ADDED))
    return "blue";
  if (state & (GNUNET_URITRACK_INSERTED || GNUNET_URITRACK_INDEXED))
    return "cyan";
  if ((state & GNUNET_URITRACK_DOWNLOAD_STARTED) &&
      (0 == (state &
             (GNUNET_URITRACK_DOWNLOAD_COMPLETED |
              GNUNET_URITRACK_DOWNLOAD_ABORTED))))
    return "yellow";
  if (state & GNUNET_URITRACK_DOWNLOAD_COMPLETED)
    return "springgreen";
  if (state & GNUNET_URITRACK_DOWNLOAD_ABORTED)
    return "red";
  if (state &
      (GNUNET_URITRACK_SEARCH_RESULT | GNUNET_URITRACK_DIRECTORY_FOUND))
    return "gray";
  if (0 == state)
    return "aquamarine";
  return NULL;
}


const char *
getStatusName (enum GNUNET_URITRACK_STATE state)
{
  if (state & (GNUNET_URITRACK_DIRECTORY_ADDED))
    return _("added");
  if (state & (GNUNET_URITRACK_INSERTED || GNUNET_URITRACK_INDEXED))
    return _("shared");
  if ((state & GNUNET_URITRACK_DOWNLOAD_STARTED) &&
      (0 == (state &
             (GNUNET_URITRACK_DOWNLOAD_COMPLETED |
              GNUNET_URITRACK_DOWNLOAD_ABORTED))))
    return _("started");
  if (state & GNUNET_URITRACK_DOWNLOAD_COMPLETED)
    return _("completed");
  if (state & GNUNET_URITRACK_DOWNLOAD_ABORTED)
    return _("aborted");
  if (state &
      (GNUNET_URITRACK_SEARCH_RESULT | GNUNET_URITRACK_DIRECTORY_FOUND))
    return "";
  if (0 == state)
    return _("new");
  return "";
}

GdkPixbuf *
getStatusLogo (enum GNUNET_URITRACK_STATE state)
{
  if (state & (GNUNET_URITRACK_DIRECTORY_ADDED))
    return gtk_icon_theme_load_icon (gtk_icon_theme_get_default (),
                                     GTK_STOCK_ADD, 16, 0, (GError **) NULL);
  if (state & (GNUNET_URITRACK_INSERTED || GNUNET_URITRACK_INDEXED))
    return gtk_icon_theme_load_icon (gtk_icon_theme_get_default (),
                                     GTK_STOCK_ADD, 16, 0, (GError **) NULL);
  if ((state & GNUNET_URITRACK_DOWNLOAD_STARTED) &&
      (0 == (state &
             (GNUNET_URITRACK_DOWNLOAD_COMPLETED |
              GNUNET_URITRACK_DOWNLOAD_ABORTED))))
    return gtk_icon_theme_load_icon (gtk_icon_theme_get_default (),
                                     GTK_STOCK_GO_DOWN, 16, 0,
                                     (GError **) NULL);
  if (state & GNUNET_URITRACK_DOWNLOAD_COMPLETED)
    return gtk_icon_theme_load_icon (gtk_icon_theme_get_default (),
                                     GTK_STOCK_APPLY, 16, 0,
                                     (GError **) NULL);
  if (state & GNUNET_URITRACK_DOWNLOAD_ABORTED)
    return gtk_icon_theme_load_icon (gtk_icon_theme_get_default (),
                                     GTK_STOCK_CANCEL, 16, 0,
                                     (GError **) NULL);
  if (0 == state)
    return gtk_icon_theme_load_icon (gtk_icon_theme_get_default (),
                                     GTK_STOCK_NEW, 16, 0, (GError **) NULL);
  return NULL;
}


/* end of status.c */
